/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.openide.filesystems.FileObjectLines;
import org.openide.util.Exceptions;

final class FileObjectLineIterator
implements ListIterator<String> {
    private final String encoding;
    private final FileObjectLines lines;
    private byte[] buffer;
    private BufferedReader reader;
    private String line;
    private int index;

    public FileObjectLineIterator(FileObjectLines fileObjectLines, String string) throws IOException {
        this.lines = fileObjectLines;
        this.encoding = string;
        this.initReader();
    }

    private FileObjectLineIterator(FileObjectLineIterator fileObjectLineIterator) {
        this.lines = fileObjectLineIterator.lines;
        this.encoding = fileObjectLineIterator.encoding;
        this.buffer = fileObjectLineIterator.buffer;
        try {
            this.initReader();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.line == null) {
            try {
                this.line = this.reader.readLine();
                if (this.line == null) {
                    this.reader.close();
                }
                ++this.index;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this.line != null;
    }

    @Override
    public synchronized String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this.line;
        this.line = null;
        return string;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public synchronized String previous() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        try {
            int n = this.index - 1;
            this.initReader();
            String string = null;
            while (this.index <= n) {
                string = this.next();
            }
            --this.index;
            return string;
        }
        catch (IOException iOException) {
            throw (NoSuchElementException)new NoSuchElementException().initCause(iOException);
        }
    }

    @Override
    public synchronized int nextIndex() {
        return this.index;
    }

    @Override
    public synchronized int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void set(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void add(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initReader() throws UnsupportedEncodingException, IOException {
        InputStream inputStream;
        if (this.lines.fo.getSize() < 65536L) {
            if (this.buffer == null) {
                this.buffer = this.lines.fo.asBytes();
            }
            inputStream = new ByteArrayInputStream(this.buffer);
        } else {
            inputStream = this.lines.fo.getInputStream();
        }
        this.reader = new BufferedReader(new InputStreamReader(inputStream, this.encoding));
        this.index = 0;
        while (this.index < this.index) {
            this.next();
        }
    }

    final FileObjectLineIterator cloneIterator() {
        return new FileObjectLineIterator(this);
    }
}

