/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.convert.ExternalUtils;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import gps.log.out.GPSFile;

public final class GPSSqlFile
extends GPSFile {
    private static final String LOGSPEED_FIELD = "logspeed";
    private static final String LOGDISTANCE_FIELD = "logdistance";
    private static final String LOGTIME_FIELD = "logtime";
    private static final String VOX_FIELD = "vox";
    private static final String SATINFO_FIELD = "satinfo";
    private static final String DISTANCE_FIELD = "distance";
    private static final String NSATVIEW_FIELD = "nsatview";
    private static final String NSATUSED_FIELD = "nsatused";
    private static final String VDOP_FIELD = "vdop";
    private static final String HDOP_FIELD = "hdop";
    private static final String PDOP_FIELD = "pdop";
    private static final String DAGE_FIELD = "dage";
    private static final String DSTA_FIELD = "dsta";
    private static final String HEADING_FIELD = "heading";
    private static final String SPEED_FIELD = "speed";
    private static final String GEOID_FIELD = "geosep";
    private static final String HEIGHT_FIELD = "height";
    private static final String LATITUDE_FIELD = "latitude";
    private static final String INDEX_FIELD = "idx";
    private static final String TIME_FIELD = "time";
    private static final String MILLISEC_FIELD = "millisecond";
    private static final String LONGITUDE_FIELD = "longitude";
    private static final String VALID_FIELD = "valid";
    private static final String RCR_FIELD = "rcr";
    private static final float METERS_TO_FEET = 3.28084f;
    private final StringBuffer rec = new StringBuffer(1024);
    private final StringBuffer recPost = new StringBuffer(1024);
    private String satSeperator = ";";
    private String tableName = "defaulttable";
    private String dbName = "defaultdb";

    public final void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        if (this.getParamObject().hasParam("sql-table")) {
            this.tableName = this.getParamObject().getStringParam("sql-table");
        }
    }

    public final boolean needPassToFindFieldsActivatedInLog() {
        return true;
    }

    protected final void writeFileHeader(String string) {
        this.rec.setLength(0);
        this.recPost.setLength(0);
        int n = 32;
        this.rec.append("CREATE TABLE ");
        this.rec.append(this.tableName);
        this.rec.append(" (");
        if (this.selectedFileFields.hasUtc()) {
            this.rec.append(' ');
            this.rec.append(" time TIMESTAMP");
            n = 44;
        }
        if (this.selectedFileFields.hasMillisecond()) {
            this.rec.append((char)n);
            this.rec.append(" millisecond INTEGER");
            n = 44;
        }
        this.rec.append((char)n);
        this.rec.append(" idx INTEGER");
        if (this.selectedFileFields.hasRcr()) {
            this.rec.append(", rcr TEXT");
        }
        if (this.selectedFileFields.hasValid()) {
            this.rec.append(", valid INTEGER");
        }
        if (this.selectedFileFields.hasLatitude()) {
            this.rec.append(", longitude FLOAT");
        }
        if (this.selectedFileFields.hasLongitude()) {
            this.rec.append(", latitude FLOAT");
        }
        if (this.selectedFileFields.hasHeight()) {
            this.rec.append(", height FLOAT");
        }
        if (this.selectedFileFields.hasGeoid()) {
            this.rec.append(", geosep FLOAT");
        }
        if (this.selectedFileFields.hasSpeed()) {
            this.rec.append(", speed FLOAT");
        }
        if (this.selectedFileFields.hasHeading()) {
            this.rec.append(", heading FLOAT");
        }
        if (this.selectedFileFields.hasDsta()) {
            this.rec.append(", dsta INTEGER");
        }
        if (this.selectedFileFields.hasDage()) {
            this.rec.append(", dage INTEGER");
        }
        if (this.selectedFileFields.hasPdop()) {
            this.rec.append(", pdop FLOAT");
        }
        if (this.selectedFileFields.hasHdop()) {
            this.rec.append(", hdop FLOAT");
        }
        if (this.selectedFileFields.hasVdop()) {
            this.rec.append(", vdop FLOAT");
        }
        if (this.selectedFileFields.hasNsat()) {
            this.rec.append(", nsatused INTEGER");
            this.rec.append(", nsatview INTEGER");
        }
        if (this.selectedFileFields.hasDistance()) {
            this.rec.append(", distance FLOAT");
        }
        if (this.selectedFileFields.hasSid()) {
            this.rec.append(", satinfo TEXT");
        }
        if (this.selectedFileFields.hasVoxStr()) {
            this.rec.append(", vox TEXT");
        }
        if (this.addLogConditionInfo) {
            this.rec.append(", logtime FLOAT");
            this.rec.append(", logdistance FLOAT");
            this.rec.append(", logspeed FLOAT");
        }
        this.rec.append(" );\r\n");
        this.rec.append("CREATE INDEX " + this.tableName + "_idx_index ON " + this.tableName + "(idx);\r\n");
        this.writeTxt(this.rec.toString());
        this.rec.setLength(0);
    }

    protected final boolean recordIsNeeded(GPSRecord gPSRecord) {
        return this.ptFilters[0].doFilter(gPSRecord) || this.ptFilters[1].doFilter(gPSRecord);
    }

    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (this.cachedRecordIsNeeded(gPSRecord)) {
            this.rec.setLength(0);
            this.recPost.setLength(0);
            this.rec.append("INSERT INTO ");
            this.rec.append(this.tableName);
            this.rec.append(" (");
            this.recPost.append(" VALUES (");
            char c = ' ';
            if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                this.rec.append(TIME_FIELD);
                c = ',';
                this.recPost.append("TIMESTAMP '");
                this.recPost.append(CommonOut.getDateTimeISO8601(this.t, gPSRecord.hasMillisecond() ? gPSRecord.milisecond : -1));
                this.recPost.append("'");
            }
            if (gPSRecord.hasMillisecond() && this.selectedFileFields.hasMillisecond()) {
                this.rec.append(c);
                this.rec.append(MILLISEC_FIELD);
                c = ',';
                this.recPost.append(',');
                this.recPost.append(gPSRecord.getMilisecond());
            }
            if (gPSRecord.hasRecCount()) {
                this.rec.append(c);
                this.rec.append(INDEX_FIELD);
                this.recPost.append(c);
                this.recPost.append(gPSRecord.getRecCount());
            }
            if (this.selectedFileFields.hasRcr()) {
                this.rec.append(',');
                this.rec.append(RCR_FIELD);
                this.recPost.append(',');
                this.recPost.append('\"');
                if (gPSRecord.hasRcr()) {
                    this.recPost.append(CommonOut.getRCRstr(gPSRecord));
                }
                this.recPost.append('\"');
            }
            if (gPSRecord.hasValid() && this.selectedFileFields.hasValid()) {
                this.rec.append(',');
                this.rec.append(VALID_FIELD);
                this.recPost.append(',');
                this.recPost.append(gPSRecord.getValid());
            }
            if (gPSRecord.hasLatitude() && this.selectedFileFields.hasLatitude()) {
                this.rec.append(',');
                this.rec.append(LATITUDE_FIELD);
                this.recPost.append(',');
                this.recPost.append(JavaLibBridge.toString(gPSRecord.getLatitude(), 6));
            }
            if (gPSRecord.hasLongitude() && this.selectedFileFields.hasLongitude()) {
                this.rec.append(',');
                this.rec.append(LONGITUDE_FIELD);
                this.recPost.append(',');
                this.recPost.append(JavaLibBridge.toString(gPSRecord.getLongitude(), 6));
            }
            if (gPSRecord.hasHeight() && this.selectedFileFields.hasHeight()) {
                this.rec.append(',');
                this.rec.append(HEIGHT_FIELD);
                this.recPost.append(',');
                if (!this.imperial) {
                    this.recPost.append(JavaLibBridge.toString(gPSRecord.getHeight(), 3));
                } else {
                    this.recPost.append(JavaLibBridge.toString(gPSRecord.getHeight() * 3.28084f, 3));
                }
            }
            if (this.selectedFileFields.hasGeoid() && gPSRecord.hasPosition()) {
                float f = gPSRecord.hasGeoid() ? gPSRecord.getGeoid() : (float)((long)(10.0 * ExternalUtils.wgs84Separation(gPSRecord.getLatitude(), gPSRecord.getLongitude()))) / 10.0f;
                if (this.imperial) {
                    f *= 3.28084f;
                }
                this.rec.append(',');
                this.rec.append(GEOID_FIELD);
                this.recPost.append(',');
                this.recPost.append(JavaLibBridge.toString(f, 1));
            }
            if (gPSRecord.hasSpeed() && this.selectedFileFields.hasSpeed()) {
                this.rec.append(',');
                this.rec.append(SPEED_FIELD);
                this.recPost.append(',');
                if (!this.imperial) {
                    this.recPost.append(JavaLibBridge.toString(gPSRecord.getSpeed(), 3));
                } else {
                    this.recPost.append(JavaLibBridge.toString(gPSRecord.getSpeed() * 0.6213712f, 3));
                }
            }
            if (gPSRecord.hasHeading() && this.selectedFileFields.hasHeading()) {
                this.rec.append(',');
                this.rec.append(HEADING_FIELD);
                this.recPost.append(',');
                this.recPost.append(JavaLibBridge.toString(gPSRecord.getHeading(), 6));
            }
            if (gPSRecord.hasDsta() && this.selectedFileFields.hasDsta()) {
                this.rec.append(',');
                this.rec.append(DSTA_FIELD);
                this.recPost.append(',');
                this.recPost.append(gPSRecord.getDsta());
            }
            if (gPSRecord.hasDage() && this.selectedFileFields.hasDage()) {
                this.rec.append(',');
                this.rec.append(DAGE_FIELD);
                this.recPost.append(',');
                this.recPost.append(gPSRecord.getDage());
            } else if (this.selectedFileFields.hasDage()) {
                this.recPost.append(',');
            }
            if (gPSRecord.hasPdop() && this.selectedFileFields.hasPdop()) {
                this.rec.append(',');
                this.rec.append(PDOP_FIELD);
                this.recPost.append(',');
                this.recPost.append(JavaLibBridge.toString((float)gPSRecord.getPdop() / 100.0f, 2));
            }
            if (gPSRecord.hasHdop() && this.selectedFileFields.hasHdop()) {
                this.rec.append(',');
                this.rec.append(HDOP_FIELD);
                this.recPost.append(',');
                this.recPost.append(JavaLibBridge.toString((float)gPSRecord.getHdop() / 100.0f, 2));
            }
            if (gPSRecord.hasVdop() && this.selectedFileFields.hasVdop()) {
                this.rec.append(',');
                this.rec.append(VDOP_FIELD);
                this.recPost.append(',');
                this.recPost.append(JavaLibBridge.toString((float)gPSRecord.getVdop() / 100.0f, 2));
            }
            if (gPSRecord.hasNsat() && this.selectedFileFields.hasNsat()) {
                this.rec.append(',');
                this.rec.append(NSATVIEW_FIELD);
                this.rec.append(',');
                this.rec.append(NSATUSED_FIELD);
                this.recPost.append(',');
                this.recPost.append(gPSRecord.getNsat() >> 8 & 0xFF);
                this.recPost.append(',');
                this.recPost.append(gPSRecord.getNsat() & 0xFF);
            }
            if (gPSRecord.hasDistance() && this.selectedFileFields.hasDistance()) {
                this.rec.append(',');
                this.rec.append(DISTANCE_FIELD);
                this.recPost.append(',');
                if (!this.imperial) {
                    this.recPost.append(JavaLibBridge.toString(gPSRecord.distance, 2));
                } else {
                    this.recPost.append(JavaLibBridge.toString(gPSRecord.distance * 3.28083989501312, 2));
                }
            }
            if (this.selectedFileFields.hasSid()) {
                int n = 0;
                this.rec.append(',');
                this.rec.append(SATINFO_FIELD);
                this.recPost.append(",\"");
                if (gPSRecord.hasSid()) {
                    for (int i = gPSRecord.sid.length - 1; i >= 0; --i) {
                        if (n != 0) {
                            this.recPost.append(this.satSeperator);
                        }
                        if (gPSRecord.sidinuse[n]) {
                            this.recPost.append('#');
                        }
                        if (gPSRecord.sid[n] < 10) {
                            this.recPost.append('0');
                        }
                        this.recPost.append(gPSRecord.sid[n]);
                        if (this.selectedFileFields.hasEle()) {
                            this.recPost.append('-');
                            if (gPSRecord.hasEle()) {
                                if (gPSRecord.ele[n] < 10) {
                                    this.recPost.append('0');
                                }
                                this.recPost.append(gPSRecord.ele[n]);
                            }
                        }
                        if (this.selectedFileFields.hasAzi()) {
                            this.recPost.append('-');
                            if (gPSRecord.hasAzi()) {
                                if (gPSRecord.azi[n] < 10) {
                                    this.recPost.append('0');
                                }
                                this.recPost.append(gPSRecord.azi[n]);
                            }
                        }
                        if (this.selectedFileFields.hasSnr()) {
                            this.recPost.append('-');
                            if (gPSRecord.hasSnr()) {
                                if (gPSRecord.snr[n] < 10) {
                                    this.recPost.append('0');
                                }
                                this.recPost.append(gPSRecord.snr[n]);
                            }
                        }
                        ++n;
                    }
                }
                this.recPost.append('\"');
            }
            if (this.selectedFileFields.hasVoxStr()) {
                this.rec.append(',');
                this.rec.append(VOX_FIELD);
                this.recPost.append(",\"");
                if (gPSRecord.voxStr != null) {
                    this.recPost.append(gPSRecord.voxStr);
                }
                this.recPost.append('\"');
            }
            if (this.addLogConditionInfo) {
                this.rec.append(',');
                this.rec.append(LOGTIME_FIELD);
                this.rec.append(',');
                this.rec.append(LOGDISTANCE_FIELD);
                this.rec.append(',');
                this.rec.append(LOGSPEED_FIELD);
                this.recPost.append(',');
                if (gPSRecord.logPeriod % 10 == 0) {
                    this.recPost.append(gPSRecord.logPeriod / 10);
                } else {
                    this.recPost.append(JavaLibBridge.toString((double)gPSRecord.logPeriod / 10.0, 1));
                }
                this.recPost.append(',');
                if (gPSRecord.logDistance % 10 == 0) {
                    this.recPost.append(gPSRecord.logDistance / 10);
                } else {
                    this.recPost.append(JavaLibBridge.toString((double)gPSRecord.logDistance / 10.0, 1));
                }
                this.recPost.append(',');
                if (gPSRecord.logSpeed % 10 == 0) {
                    this.recPost.append(gPSRecord.logSpeed / 10);
                } else {
                    this.recPost.append(JavaLibBridge.toString((double)gPSRecord.logSpeed / 10.0, 1));
                }
            }
            this.rec.append(" ) ");
            this.recPost.append(" )");
            this.recPost.append(";\r\n");
            this.rec.append(this.recPost.toString());
            this.recPost.setLength(0);
            this.writeTxt(this.rec.toString());
            this.rec.setLength(0);
        }
    }
}

