/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class ForEachProcessor
extends AbstractProcessor {
    public static final String TYPE = "foreach";
    private final String field;
    private final Processor processor;

    ForEachProcessor(String tag, String field, Processor processor) {
        super(tag);
        this.field = field;
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IngestDocument ingestDocument) throws Exception {
        List values = (List)ingestDocument.getFieldValue(this.field, List.class);
        ArrayList newValues = new ArrayList(values.size());
        for (Object value : values) {
            Object previousValue = ingestDocument.getIngestMetadata().put("_value", value);
            try {
                this.processor.execute(ingestDocument);
            }
            finally {
                newValues.add(ingestDocument.getIngestMetadata().put("_value", previousValue));
            }
        }
        ingestDocument.setFieldValue(this.field, newValues);
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    Processor getProcessor() {
        return this.processor;
    }

    public static final class Factory
    implements Processor.Factory {
        public ForEachProcessor create(Map<String, Processor.Factory> factories, String tag, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)ForEachProcessor.TYPE, (String)tag, config, (String)"field");
            Map processorConfig = ConfigurationUtils.readMap((String)ForEachProcessor.TYPE, (String)tag, config, (String)"processor");
            Set entries = processorConfig.entrySet();
            if (entries.size() != 1) {
                throw ConfigurationUtils.newConfigurationException((String)ForEachProcessor.TYPE, (String)tag, (String)"processor", (String)"Must specify exactly one processor type");
            }
            Map.Entry entry = entries.iterator().next();
            Processor processor = ConfigurationUtils.readProcessor(factories, (String)((String)entry.getKey()), (Map)((Map)entry.getValue()));
            return new ForEachProcessor(tag, field, processor);
        }
    }
}

