/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.ForecastJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.action.TransportJobTaskAction;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.ForecastParams;

public class TransportForecastJobAction
extends TransportJobTaskAction<ForecastJobAction.Request, ForecastJobAction.Response> {
    private final JobProvider jobProvider;

    @Inject
    public TransportForecastJobAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobProvider jobProvider, AutodetectProcessManager processManager) {
        super(settings, "cluster:admin/xpack/ml/job/forecast", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ForecastJobAction.Request::new, ForecastJobAction.Response::new, "same", processManager);
        this.jobProvider = jobProvider;
    }

    protected ForecastJobAction.Response readTaskResponse(StreamInput in) throws IOException {
        ForecastJobAction.Response response = new ForecastJobAction.Response();
        response.readFrom(in);
        return response;
    }

    protected void taskOperation(ForecastJobAction.Request request, TransportOpenJobAction.JobTask task, ActionListener<ForecastJobAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        Job job = JobManager.getJobOrThrowIfUnknown(task.getJobId(), state);
        TransportForecastJobAction.validate(job, request);
        ForecastParams.Builder paramsBuilder = ForecastParams.builder();
        if (request.getDuration() != null) {
            paramsBuilder.duration(request.getDuration());
        }
        if (request.getExpiresIn() != null) {
            paramsBuilder.expiresIn(request.getExpiresIn());
        }
        ForecastParams params = paramsBuilder.build();
        this.processManager.forecastJob(task, params, e -> {
            if (e == null) {
                Consumer<ForecastRequestStats> forecastRequestStatsHandler = forecastRequestStats -> {
                    if (forecastRequestStats == null) {
                        listener.onFailure((Exception)new ElasticsearchException("Cannot run forecast: internal error, please check the logs", new Object[0]));
                    } else if (forecastRequestStats.getStatus() == ForecastRequestStats.ForecastRequestStatus.FAILED) {
                        List messages = forecastRequestStats.getMessages();
                        if (messages.size() > 0) {
                            listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)("Cannot run forecast: " + (String)messages.get(0)), (Object[])new Object[0]));
                        } else {
                            listener.onFailure((Exception)new ElasticsearchException("Cannot run forecast: internal error, please check the logs", new Object[0]));
                        }
                    } else {
                        listener.onResponse((Object)new ForecastJobAction.Response(true, params.getForecastId()));
                    }
                };
                this.jobProvider.getForecastRequestStats(request.getJobId(), params.getForecastId(), forecastRequestStatsHandler, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            } else {
                listener.onFailure(e);
            }
        });
    }

    static void validate(Job job, ForecastJobAction.Request request) {
        TimeValue bucketSpan;
        TimeValue duration;
        if (job.getJobVersion() == null || job.getJobVersion().before(Version.V_6_1_0)) {
            throw ExceptionsHelper.badRequestException((String)"Cannot run forecast because jobs created prior to version 6.1 are not supported", (Object[])new Object[0]);
        }
        if (request.getDuration() != null && (duration = request.getDuration()).compareTo(bucketSpan = job.getAnalysisConfig().getBucketSpan()) < 0) {
            throw ExceptionsHelper.badRequestException((String)("[" + ForecastJobAction.Request.DURATION.getPreferredName() + "] must be greater or equal to the bucket span: [" + duration.getStringRep() + "/" + bucketSpan.getStringRep() + "]"), (Object[])new Object[0]);
        }
    }
}

