/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.jira;

import java.io.IOException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.jira.ExecutableJiraAction;
import org.elasticsearch.xpack.watcher.actions.jira.JiraAction;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.jira.JiraService;

public class JiraActionFactory
extends ActionFactory {
    private final TextTemplateEngine templateEngine;
    private final JiraService jiraService;

    public JiraActionFactory(Settings settings, TextTemplateEngine templateEngine, JiraService jiraService) {
        super(Loggers.getLogger(ExecutableJiraAction.class, (Settings)settings, (String[])new String[0]));
        this.templateEngine = templateEngine;
        this.jiraService = jiraService;
    }

    public ExecutableJiraAction parseExecutable(String watchId, String actionId, XContentParser parser) throws IOException {
        JiraAction action = JiraAction.parse(watchId, actionId, parser);
        this.jiraService.getAccount(action.getAccount());
        return new ExecutableJiraAction(action, this.actionLogger, this.jiraService, this.templateEngine);
    }
}

