/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.stats;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.watcher.WatcherMetaData;
import org.elasticsearch.xpack.watcher.WatcherService;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.transport.actions.stats.OldWatcherStatsRequest;
import org.elasticsearch.xpack.watcher.transport.actions.stats.OldWatcherStatsResponse;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;

public class OldTransportWatcherStatsAction
extends TransportMasterNodeAction<OldWatcherStatsRequest, OldWatcherStatsResponse> {
    private final WatcherService watcherService;
    private final ExecutionService executionService;
    private final XPackLicenseState licenseState;
    private final TriggerService triggerService;

    @Inject
    public OldTransportWatcherStatsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherService watcherService, ExecutionService executionService, XPackLicenseState licenseState, TriggerService triggerService) {
        super(settings, "cluster:monitor/xpack/watcher/stats", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, OldWatcherStatsRequest::new);
        this.watcherService = watcherService;
        this.executionService = executionService;
        this.licenseState = licenseState;
        this.triggerService = triggerService;
    }

    protected String executor() {
        return "same";
    }

    protected void doExecute(Task task, OldWatcherStatsRequest request, ActionListener<OldWatcherStatsResponse> listener) {
        if (this.licenseState.isWatcherAllowed()) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"watcher"));
        }
    }

    protected OldWatcherStatsResponse newResponse() {
        return new OldWatcherStatsResponse();
    }

    protected void masterOperation(OldWatcherStatsRequest request, ClusterState state, ActionListener<OldWatcherStatsResponse> listener) throws ElasticsearchException {
        OldWatcherStatsResponse statsResponse = new OldWatcherStatsResponse();
        statsResponse.setWatcherState(this.watcherService.state());
        statsResponse.setThreadPoolQueueSize(this.executionService.executionThreadPoolQueueSize());
        statsResponse.setWatchesCount(this.triggerService.count());
        statsResponse.setThreadPoolMaxSize(this.executionService.executionThreadPoolMaxSize());
        statsResponse.setWatcherMetaData(this.getWatcherMetaData());
        if (request.includeCurrentWatches()) {
            statsResponse.setSnapshots(this.executionService.currentExecutions());
        }
        if (request.includeQueuedWatches()) {
            statsResponse.setQueuedWatches(this.executionService.queuedWatches());
        }
        listener.onResponse((Object)statsResponse);
    }

    protected ClusterBlockException checkBlock(OldWatcherStatsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    private WatcherMetaData getWatcherMetaData() {
        WatcherMetaData watcherMetaData = (WatcherMetaData)this.clusterService.state().getMetaData().custom("watcher");
        if (watcherMetaData == null) {
            watcherMetaData = new WatcherMetaData(false);
        }
        return watcherMetaData;
    }
}

