/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.definition.ProcessorDefinition;
import org.elasticsearch.xpack.sql.tree.Location;

public abstract class BinaryProcessorDefinition
extends ProcessorDefinition {
    private final ProcessorDefinition left;
    private final ProcessorDefinition right;

    public BinaryProcessorDefinition(Location location, Expression expression, ProcessorDefinition left, ProcessorDefinition right) {
        super(location, expression, Arrays.asList(left, right));
        this.left = left;
        this.right = right;
    }

    @Override
    public final ProcessorDefinition replaceChildren(List<ProcessorDefinition> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    public ProcessorDefinition left() {
        return this.left;
    }

    public ProcessorDefinition right() {
        return this.right;
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.left.supportedByAggsOnlyQuery() && this.right.supportedByAggsOnlyQuery();
    }

    @Override
    public final ProcessorDefinition resolveAttributes(ProcessorDefinition.AttributeResolver resolver) {
        ProcessorDefinition newLeft = this.left.resolveAttributes(resolver);
        ProcessorDefinition newRight = this.right.resolveAttributes(resolver);
        if (newLeft == this.left && newRight == this.right) {
            return this;
        }
        return this.replaceChildren(newLeft, newRight);
    }

    protected abstract BinaryProcessorDefinition replaceChildren(ProcessorDefinition var1, ProcessorDefinition var2);

    @Override
    public boolean resolved() {
        return this.left().resolved() && this.right().resolved();
    }

    @Override
    public final void collectFields(SqlSourceBuilder sourceBuilder) {
        this.left.collectFields(sourceBuilder);
        this.right.collectFields(sourceBuilder);
    }
}

