/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin.dynamic;

import javax.swing.JPanel;
import org.gephi.statistics.plugin.dynamic.DynamicDegree;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.statistics.plugin.dynamic.DynamicDegreePanel;
import org.openide.util.NbBundle;

public class DynamicDegreeUI
implements StatisticsUI {
    private final StatSettings settings = new StatSettings();
    private DynamicDegree degree;
    private DynamicDegreePanel panel;

    public JPanel getSettingsPanel() {
        this.panel = new DynamicDegreePanel();
        return this.panel;
    }

    public void setup(Statistics statistics) {
        this.degree = (DynamicDegree)statistics;
        if (this.panel != null) {
            this.settings.load(this.degree);
            this.panel.setDirected(this.degree.isDirected());
            this.panel.setAverageOnly(this.degree.isAverageOnly());
        }
    }

    public void unsetup() {
        if (this.panel != null) {
            this.degree.setDirected(this.panel.isDirected());
            this.degree.setAverageOnly(this.panel.isAverageOnly());
            this.settings.save(this.degree);
        }
        this.degree = null;
        this.panel = null;
    }

    public Class<? extends Statistics> getStatisticsClass() {
        return DynamicDegree.class;
    }

    public String getValue() {
        return "";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"DynamicDegreeUI.name");
    }

    public String getCategory() {
        return StatisticsUI.CATEGORY_DYNAMIC;
    }

    public int getPosition() {
        return 300;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"DynamicDegreeUI.shortDescription");
    }

    private static class StatSettings {
        private boolean averageOnly = false;
        private double window = 0.0;
        private double tick = 0.0;

        private StatSettings() {
        }

        private void save(DynamicDegree stat) {
            this.averageOnly = stat.isAverageOnly();
            this.window = stat.getWindow();
            this.tick = stat.getTick();
        }

        private void load(DynamicDegree stat) {
            stat.setAverageOnly(this.averageOnly);
            stat.setWindow(this.window);
            stat.setTick(this.tick);
        }
    }
}

