/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.gpsies;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.function.gpsies.GpsiesXmlHandler;
import tim.prune.function.search.GenericDownloaderFunction;
import tim.prune.function.search.SearchResult;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.ZipFileLoader;

public class GetGpsiesFunction
extends GenericDownloaderFunction {
    private static final int RESULTS_PER_PAGE = 20;
    private static final int MAX_RESULTS = 60;
    private static final String GPSIES_API_KEY = "oumgvvbckiwpvsnb";

    public GetGpsiesFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.getgpsies";
    }

    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.gpsies.column.name";
        }
        return "dialog.gpsies.column.length";
    }

    public void run() {
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        double[] dArray = this._app.getViewport().getBounds();
        int n = 1;
        ArrayList<SearchResult> arrayList = null;
        URL uRL = null;
        String string = "";
        InputStream inputStream = null;
        do {
            String string2 = "http://ws.gpsies.com/api.do?BBOX=" + dArray[1] + "," + dArray[0] + "," + dArray[3] + "," + dArray[2] + "&limit=" + 20 + "&resultPage=" + n + "&key=" + GPSIES_API_KEY;
            GpsiesXmlHandler gpsiesXmlHandler = new GpsiesXmlHandler();
            try {
                uRL = new URL(string2);
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setRequestProperty("User-Agent", "GpsPrune v19");
                inputStream = uRLConnection.getInputStream();
                sAXParser.parse(inputStream, (DefaultHandler)gpsiesXmlHandler);
            }
            catch (Exception exception) {
                string = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            arrayList = gpsiesXmlHandler.getTrackList();
            this._trackListModel.addTracks(arrayList);
            ++n;
        } while (arrayList != null && arrayList.size() == 20 && this._trackListModel.getRowCount() < 60 && !this._cancelled);
        if (string.equals("") && (arrayList == null || arrayList.size() == 0)) {
            string = I18nManager.getText("dialog.gpsies.nonefound");
        }
        this._statusLabel.setText(string);
    }

    protected void loadSelected() {
        int n = this._trackTable.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this._trackTable.getSelectedRows();
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 >= 0 && n3 < this._trackListModel.getRowCount()) {
                String string = this._trackListModel.getTrack(n3).getDownloadLink();
                XmlFileLoader xmlFileLoader = new XmlFileLoader(this._app);
                ZipFileLoader zipFileLoader = new ZipFileLoader(this._app, xmlFileLoader);
                if (n2 > 0) {
                    this._app.autoAppendNextFile();
                }
                try {
                    zipFileLoader.openStream(new URL(string).openStream());
                }
                catch (IOException iOException) {
                    System.err.println("IO Exception : " + iOException.getMessage());
                }
            }
            ++n2;
        }
        this._cancelled = true;
        this._dialog.dispose();
    }
}

