/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.sort.SortEngine;
import org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;

public class ResolverManifestIterable {
    private final BasicResolver resolver;

    public ResolverManifestIterable(BasicResolver basicResolver) {
        this.resolver = basicResolver;
    }

    public Iterator iterator() {
        return new ResolverManifestIterator();
    }

    class ResolverManifestIterator
    implements Iterator {
        private OrganisationEntry[] organisations;
        private int indexOrganisation = 0;
        private OrganisationEntry organisation;
        private ModuleEntry[] modules;
        private int indexModule = -1;
        private ModuleEntry module;
        private ManifestAndLocation next = null;
        private RevisionEntry[] revisions;
        private int indexRevision;
        private RevisionEntry revision;
        private Artifact[] artifacts;
        private int indexArtifact;
        private Artifact artifact;
        private ModuleRevisionId mrid;
        private ResolveData data;

        public ResolverManifestIterator() {
            this.organisations = ResolverManifestIterable.this.resolver.listOrganisations();
            IvySettings ivySettings = new IvySettings();
            ResolveEngine resolveEngine = new ResolveEngine(ivySettings, new EventManager(), new SortEngine(ivySettings));
            this.data = new ResolveData(resolveEngine, new ResolveOptions());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            while (this.next == null) {
                Object object;
                Object object2;
                Object object3;
                if (this.organisation == null) {
                    if (this.indexOrganisation >= this.organisations.length) {
                        return false;
                    }
                    this.organisation = this.organisations[this.indexOrganisation++];
                    this.modules = ResolverManifestIterable.this.resolver.listModules(this.organisation);
                    this.indexModule = 0;
                    this.module = null;
                }
                if (this.module == null) {
                    if (this.indexModule >= this.modules.length) {
                        this.organisation = null;
                        continue;
                    }
                    this.module = this.modules[this.indexModule++];
                    this.revisions = ResolverManifestIterable.this.resolver.listRevisions(this.module);
                    this.indexRevision = 0;
                    this.revision = null;
                }
                if (this.revision == null) {
                    if (this.indexRevision >= this.revisions.length) {
                        this.module = null;
                        continue;
                    }
                    this.revision = this.revisions[this.indexRevision++];
                    this.mrid = ModuleRevisionId.newInstance(this.organisation.getOrganisation(), this.module.getModule(), this.revision.getRevision());
                    object3 = new DefaultDependencyDescriptor(this.mrid, false);
                    try {
                        object2 = ResolverManifestIterable.this.resolver.getDependency((DependencyDescriptor)object3, this.data);
                    }
                    catch (ParseException parseException) {
                        Message.error("Error while resolving " + this.mrid + " : " + parseException.getMessage());
                        this.revision = null;
                        continue;
                    }
                    if (object2 == null) {
                        this.revision = null;
                        continue;
                    }
                    object = ((ResolvedModuleRevision)object2).getDescriptor();
                    this.mrid = object.getModuleRevisionId();
                    this.artifacts = object.getAllArtifacts();
                    this.indexArtifact = 0;
                    this.artifact = null;
                }
                if (this.artifact == null) {
                    if (this.indexArtifact >= this.artifacts.length) {
                        this.revision = null;
                        continue;
                    }
                    this.artifact = this.artifacts[this.indexArtifact++];
                }
                if ((object3 = ResolverManifestIterable.this.resolver.doFindArtifactRef(this.artifact, null)) == null) {
                    this.artifact = null;
                    continue;
                }
                try {
                    object2 = new JarInputStream(((ResolvedResource)object3).getResource().openStream());
                }
                catch (IOException iOException) {
                    Message.warn("Unreadable jar " + ((ResolvedResource)object3).getResource().getName() + " (" + iOException.getMessage() + ")");
                    this.artifact = null;
                    continue;
                }
                try {
                    object = ((JarInputStream)object2).getManifest();
                }
                finally {
                    try {
                        ((ZipInputStream)object2).close();
                    }
                    catch (IOException iOException) {}
                }
                if (object == null) {
                    Message.debug("No manifest on " + this.artifact);
                } else {
                    URI uRI = BundleInfoAdapter.buildIvyURI(this.artifact);
                    this.next = new ManifestAndLocation((Manifest)object, uRI);
                }
                this.artifact = null;
            }
            return true;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ManifestAndLocation manifestAndLocation = this.next;
            this.next = null;
            return manifestAndLocation;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

