/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.ScrollBarBehavior;
import com.sun.javafx.scene.control.skin.EndButton;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;

public class ScrollBarSkin
extends SkinBase<ScrollBar, ScrollBarBehavior> {
    public static int DEFAULT_LENGTH = 100;
    public static int DEFAULT_WIDTH = 20;
    private StackPane thumb;
    private StackPane trackBackground;
    private StackPane track;
    private EndButton incButton;
    private EndButton decButton;
    private double trackLength;
    private double thumbLength;
    private double preDragThumbPos;
    private Point2D dragStart;
    private double trackPos;

    public ScrollBarSkin(ScrollBar scrollBar) {
        super(scrollBar, new ScrollBarBehavior(scrollBar));
        this.initialize();
        this.requestLayout();
        this.registerChangeListener(scrollBar.minProperty(), "MIN");
        this.registerChangeListener(scrollBar.maxProperty(), "MAX");
        this.registerChangeListener(scrollBar.valueProperty(), "VALUE");
        this.registerChangeListener(scrollBar.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(scrollBar.visibleAmountProperty(), "VISIBLE_AMOUNT");
    }

    private void initialize() {
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.trackBackground = new StackPane();
        this.trackBackground.getStyleClass().setAll((String[])new String[]{"track-background"});
        this.thumb = new StackPane();
        this.thumb.getStyleClass().setAll((String[])new String[]{"thumb"});
        if (!PlatformUtil.isEmbedded()) {
            this.incButton = new EndButton("increment-button", "increment-arrow");
            this.incButton.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).incButtonPressed(mouseEvent);
                    }
                    mouseEvent.consume();
                }
            });
            this.incButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).incButtonReleased(mouseEvent);
                    }
                    mouseEvent.consume();
                }
            });
            this.decButton = new EndButton("decrement-button", "decrement-arrow");
            this.decButton.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).decButtonPressed(mouseEvent);
                    }
                    mouseEvent.consume();
                }
            });
            this.decButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (!ScrollBarSkin.this.thumb.isVisible() || ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).decButtonReleased(mouseEvent);
                    }
                    mouseEvent.consume();
                }
            });
        }
        this.track.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (!ScrollBarSkin.this.thumb.isPressed()) {
                    if (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                        if (ScrollBarSkin.this.trackLength != 0.0) {
                            ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).trackPress(mouseEvent, mouseEvent.getY() / ScrollBarSkin.this.trackLength);
                            mouseEvent.consume();
                        }
                    } else if (ScrollBarSkin.this.trackLength != 0.0) {
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).trackPress(mouseEvent, mouseEvent.getX() / ScrollBarSkin.this.trackLength);
                        mouseEvent.consume();
                    }
                }
            }
        });
        this.track.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).trackRelease(mouseEvent, 0.0);
                mouseEvent.consume();
            }
        });
        this.thumb.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isSynthesized()) {
                    mouseEvent.consume();
                    return;
                }
                if (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() > ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) {
                    ScrollBarSkin.this.dragStart = ScrollBarSkin.this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                    double d = Utils.clamp(((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin(), ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getValue(), ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax());
                    ScrollBarSkin.this.preDragThumbPos = (d - ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) / (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() - ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin());
                    mouseEvent.consume();
                }
            }
        });
        this.thumb.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isSynthesized()) {
                    mouseEvent.consume();
                    return;
                }
                if (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() > ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) {
                    if (ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        Point2D point2D = ScrollBarSkin.this.thumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
                        double d = ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? point2D.getY() - ScrollBarSkin.this.dragStart.getY() : point2D.getX() - ScrollBarSkin.this.dragStart.getX();
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).thumbDragged(mouseEvent, ScrollBarSkin.this.preDragThumbPos + d / (ScrollBarSkin.this.trackLength - ScrollBarSkin.this.thumbLength));
                    }
                    mouseEvent.consume();
                }
            }
        });
        this.thumb.setOnScrollStarted((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                if (scrollEvent.isDirect() && ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() > ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) {
                    ScrollBarSkin.this.dragStart = ScrollBarSkin.this.thumb.localToParent(scrollEvent.getX(), scrollEvent.getY());
                    double d = Utils.clamp(((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin(), ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getValue(), ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax());
                    ScrollBarSkin.this.preDragThumbPos = (d - ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) / (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() - ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin());
                    scrollEvent.consume();
                }
            }
        });
        this.thumb.setOnScroll((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                if (scrollEvent.isDirect() && ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMax() > ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getMin()) {
                    if (ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                        Point2D point2D = ScrollBarSkin.this.thumb.localToParent(scrollEvent.getX(), scrollEvent.getY());
                        double d = ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? point2D.getY() - ScrollBarSkin.this.dragStart.getY() : point2D.getX() - ScrollBarSkin.this.dragStart.getX();
                        ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).thumbDragged(null, ScrollBarSkin.this.preDragThumbPos + d / (ScrollBarSkin.this.trackLength - ScrollBarSkin.this.thumbLength));
                    }
                    scrollEvent.consume();
                    return;
                }
            }
        });
        this.setOnScroll((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                if (ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                    double d;
                    double d2 = scrollEvent.getDeltaX();
                    double d3 = scrollEvent.getDeltaY();
                    d2 = Math.abs(d2) < Math.abs(d3) ? d3 : d2;
                    ScrollBar scrollBar = (ScrollBar)ScrollBarSkin.this.getSkinnable();
                    double d4 = d = ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? d3 : d2;
                    if (scrollEvent.isDirect()) {
                        if (ScrollBarSkin.this.trackLength > ScrollBarSkin.this.thumbLength) {
                            ((ScrollBarBehavior)ScrollBarSkin.this.getBehavior()).thumbDragged(null, (((ScrollBar)ScrollBarSkin.this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? scrollEvent.getY() : scrollEvent.getX()) / ScrollBarSkin.this.trackLength);
                            scrollEvent.consume();
                        }
                    } else if (d > 0.0 && scrollBar.getValue() > scrollBar.getMin()) {
                        scrollBar.decrement();
                        scrollEvent.consume();
                    } else if (d < 0.0 && scrollBar.getValue() < scrollBar.getMax()) {
                        scrollBar.increment();
                        scrollEvent.consume();
                    }
                }
            }
        });
        this.getChildren().clear();
        if (!PlatformUtil.isEmbedded()) {
            this.getChildren().addAll((Node[])new Node[]{this.trackBackground, this.incButton, this.decButton, this.track, this.thumb});
        } else {
            this.getChildren().addAll((Node[])new Node[]{this.track, this.thumb});
        }
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "ORIENTATION") {
            this.requestLayout();
        } else if (string == "MIN" || string == "MAX" || string == "VALUE" || string == "VISIBLE_AMOUNT") {
            this.positionThumb();
            this.requestLayout();
        }
    }

    double getBreadth() {
        if (!PlatformUtil.isEmbedded()) {
            if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                return Math.max(this.decButton.prefWidth(-1.0) + this.getInsets().getLeft() + this.getInsets().getRight(), this.incButton.prefWidth(-1.0) + this.getInsets().getLeft() + this.getInsets().getRight());
            }
            return Math.max(this.decButton.prefHeight(-1.0) + this.getInsets().getTop() + this.getInsets().getBottom(), this.incButton.prefHeight(-1.0) + this.getInsets().getTop() + this.getInsets().getBottom());
        }
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return Math.max(this.getInsets().getLeft() + this.getInsets().getRight(), this.getInsets().getLeft() + this.getInsets().getRight());
        }
        return Math.max(this.getInsets().getTop() + this.getInsets().getBottom(), this.getInsets().getTop() + this.getInsets().getBottom());
    }

    double minThumbLength() {
        return 1.5 * this.getBreadth();
    }

    double minTrackLength() {
        return 2.0 * this.getBreadth();
    }

    @Override
    protected double computeMinWidth(double d) {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.getBreadth();
        }
        if (!PlatformUtil.isEmbedded()) {
            return this.decButton.minWidth(-1.0) + this.incButton.minWidth(-1.0) + this.minTrackLength() + this.getInsets().getLeft() + this.getInsets().getRight();
        }
        return this.minTrackLength() + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            if (!PlatformUtil.isEmbedded()) {
                return this.decButton.minHeight(-1.0) + this.incButton.minHeight(-1.0) + this.minTrackLength() + this.getInsets().getTop() + this.getInsets().getBottom();
            }
            return this.minTrackLength() + this.getInsets().getTop() + this.getInsets().getBottom();
        }
        return this.getBreadth();
    }

    @Override
    protected double computePrefWidth(double d) {
        return ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? this.getBreadth() : (double)DEFAULT_LENGTH + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        return ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? (double)DEFAULT_LENGTH + this.getInsets().getTop() + this.getInsets().getBottom() : this.getBreadth();
    }

    @Override
    protected double computeMaxWidth(double d) {
        return ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? ((ScrollBar)this.getSkinnable()).prefWidth(-1.0) : Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? Double.MAX_VALUE : ((ScrollBar)this.getSkinnable()).prefHeight(-1.0);
    }

    void positionThumb() {
        ScrollBar scrollBar = (ScrollBar)this.getSkinnable();
        double d = Utils.clamp(scrollBar.getMin(), scrollBar.getValue(), scrollBar.getMax());
        double d2 = this.trackPos = scrollBar.getMax() - scrollBar.getMin() > 0.0 ? (this.trackLength - this.thumbLength) * (d - scrollBar.getMin()) / (scrollBar.getMax() - scrollBar.getMin()) : 0.0;
        if (!PlatformUtil.isEmbedded()) {
            this.trackPos = scrollBar.getOrientation() == Orientation.VERTICAL ? (this.trackPos += this.decButton.prefHeight(-1.0)) : (this.trackPos += this.decButton.prefWidth(-1.0));
        }
        this.thumb.setTranslateX(scrollBar.getOrientation() == Orientation.VERTICAL ? this.getInsets().getLeft() : this.trackPos + this.getInsets().getLeft());
        this.thumb.setTranslateY(scrollBar.getOrientation() == Orientation.VERTICAL ? this.trackPos + this.getInsets().getTop() : this.getInsets().getTop());
    }

    @Override
    protected void layoutChildren() {
        double d = this.getInsets().getLeft();
        double d2 = this.getInsets().getTop();
        double d3 = this.snapSize(this.getWidth());
        double d4 = this.snapSize(this.getHeight());
        double d5 = this.snapSize(d3 - (this.getInsets().getLeft() + this.getInsets().getRight()));
        double d6 = this.snapSize(d4 - (this.getInsets().getTop() + this.getInsets().getBottom()));
        double d7 = ((ScrollBar)this.getSkinnable()).getMax() > ((ScrollBar)this.getSkinnable()).getMin() ? ((ScrollBar)this.getSkinnable()).getVisibleAmount() / (((ScrollBar)this.getSkinnable()).getMax() - ((ScrollBar)this.getSkinnable()).getMin()) : 1.0;
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            if (!PlatformUtil.isEmbedded()) {
                double d8 = this.snapSize(this.decButton.prefHeight(-1.0));
                double d9 = this.snapSize(this.incButton.prefHeight(-1.0));
                this.decButton.resize(d5, d8);
                this.incButton.resize(d5, d9);
                this.trackLength = this.snapSize(d6 - (d8 + d9));
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * d7, this.trackLength));
                this.trackBackground.resizeRelocate(this.snapPosition(d), this.snapPosition(d2), d5, this.trackLength + d8 + d9);
                this.decButton.relocate(this.snapPosition(d), this.snapPosition(d2));
                this.incButton.relocate(this.snapPosition(d), this.snapPosition(d2 + d6 - d9));
                this.track.resizeRelocate(this.snapPosition(d), this.snapPosition(d2 + d8), d5, this.trackLength);
                this.thumb.resize(this.snapSize(d >= 0.0 ? d5 : d5 + d), this.thumbLength);
                this.positionThumb();
            } else {
                this.trackLength = this.snapSize(d6);
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * d7, this.trackLength));
                this.track.resizeRelocate(this.snapPosition(d), this.snapPosition(d2), d5, this.trackLength);
                this.thumb.resize(this.snapSize(d >= 0.0 ? d5 : d5 + d), this.thumbLength);
                this.positionThumb();
            }
        } else {
            if (!PlatformUtil.isEmbedded()) {
                double d10 = this.snapSize(this.decButton.prefWidth(-1.0));
                double d11 = this.snapSize(this.incButton.prefWidth(-1.0));
                this.decButton.resize(d10, d6);
                this.incButton.resize(d11, d6);
                this.trackLength = this.snapSize(d5 - (d10 + d11));
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * d7, this.trackLength));
                this.trackBackground.resizeRelocate(this.snapPosition(d), this.snapPosition(d2), this.trackLength + d10 + d11, d6);
                this.decButton.relocate(this.snapPosition(d), this.snapPosition(d2));
                this.incButton.relocate(this.snapPosition(d + d5 - d11), this.snapPosition(d2));
                this.track.resizeRelocate(this.snapPosition(d + d10), this.snapPosition(d2), this.trackLength, d6);
                this.thumb.resize(this.thumbLength, this.snapSize(d2 >= 0.0 ? d6 : d6 + d2));
                this.positionThumb();
            } else {
                this.trackLength = this.snapSize(d5);
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * d7, this.trackLength));
                this.track.resizeRelocate(this.snapPosition(d), this.snapPosition(d2), this.trackLength, d6);
                this.thumb.resize(this.thumbLength, this.snapSize(d2 >= 0.0 ? d6 : d6 + d2));
                this.positionThumb();
            }
            this.resize(this.snapSize(this.getWidth()), this.snapSize(this.getHeight()));
        }
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL && d6 >= this.computeMinHeight(-1.0) - (this.getInsets().getTop() + this.getInsets().getBottom()) || ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL && d5 >= this.computeMinWidth(-1.0) - (this.getInsets().getLeft() + this.getInsets().getRight())) {
            this.trackBackground.setVisible(true);
            this.track.setVisible(true);
            this.thumb.setVisible(true);
            if (!PlatformUtil.isEmbedded()) {
                this.incButton.setVisible(true);
                this.decButton.setVisible(true);
            }
        } else {
            this.trackBackground.setVisible(false);
            this.track.setVisible(false);
            this.thumb.setVisible(false);
            if (!PlatformUtil.isEmbedded()) {
                if (d6 >= this.decButton.computeMinWidth(-1.0)) {
                    this.decButton.setVisible(true);
                } else {
                    this.decButton.setVisible(false);
                }
                if (d6 >= this.incButton.computeMinWidth(-1.0)) {
                    this.incButton.setVisible(true);
                } else {
                    this.incButton.setVisible(false);
                }
            }
        }
    }
}

