/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authentication;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationIndicatorsPanel;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.LayoutHelper;

public class ContextAuthenticationPanel
extends AbstractContextPropertiesPanel {
    private static final Logger log = Logger.getLogger(ContextAuthenticationPanel.class);
    private static final long serialVersionUID = -898084998156067286L;
    private static final String PANEL_NAME = Constant.messages.getString("authentication.panel.title");
    private static final String FIELD_LABEL_LOGGED_IN_INDICATOR = Constant.messages.getString("authentication.panel.label.loggedIn");
    private static final String FIELD_LABEL_LOGGED_OUT_INDICATOR = Constant.messages.getString("authentication.panel.label.loggedOut");
    private static final String FIELD_LABEL_TYPE_SELECT = Constant.messages.getString("authentication.panel.label.typeSelect");
    private static final String LABEL_DESCRIPTION = Constant.messages.getString("authentication.panel.label.description");
    private static final String PANEL_TITLE_CONFIG = Constant.messages.getString("authentication.panel.label.configTitle");
    private static final String LABEL_CONFIG_NOT_NEEDED = Constant.messages.getHtmlWrappedString("sessionmanagement.panel.label.noConfigPanel");
    private ExtensionAuthentication extension;
    private JComboBox<AuthenticationMethodType> authenticationMethodsComboBox;
    private AuthenticationMethod selectedAuthenticationMethod;
    private AuthenticationMethodType shownMethodType;
    private AbstractAuthenticationMethodOptionsPanel shownConfigPanel;
    private JPanel configContainerPanel;
    private ZapTextField loggedInIndicaterRegexField = null;
    private ZapTextField loggedOutIndicaterRegexField = null;
    private boolean needsConfirm = true;
    private AuthenticationIndicatorsPanel authenticationIndicatorsPanel;

    public ContextAuthenticationPanel(ExtensionAuthentication extension, Context context) {
        super(context.getIndex());
        this.extension = extension;
        this.initialize();
    }

    public static String buildName(int contextId) {
        return contextId + ": " + PANEL_NAME;
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(ContextAuthenticationPanel.buildName(this.getContextIndex()));
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add((Component)new JLabel(LABEL_DESCRIPTION), LayoutHelper.getGBC(0, 0, 1, 1.0));
        this.add((Component)new JLabel(FIELD_LABEL_TYPE_SELECT), LayoutHelper.getGBC(0, 1, 1, 1.0, new Insets(20, 0, 5, 5)));
        this.add(this.getAuthenticationMethodsComboBox(), LayoutHelper.getGBC(0, 2, 1, 1.0));
        this.add((Component)this.getConfigContainerPanel(), LayoutHelper.getGBC(0, 3, 1, 1.0, new Insets(10, 0, 10, 0)));
        this.add((Component)new JLabel(FIELD_LABEL_LOGGED_IN_INDICATOR), LayoutHelper.getGBC(0, 4, 1, 1.0));
        this.add((Component)this.getLoggedInIndicaterRegexField(), LayoutHelper.getGBC(0, 5, 1, 1.0));
        this.add((Component)new JLabel(FIELD_LABEL_LOGGED_OUT_INDICATOR), LayoutHelper.getGBC(0, 6, 1, 1.0));
        this.add((Component)this.getLoggedOutIndicaterRegexField(), LayoutHelper.getGBC(0, 7, 1, 1.0));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(0, 99, 1, 1.0, 1.0));
    }

    private void changeMethodConfigPanel(AuthenticationMethodType newMethodType) {
        if (newMethodType == null) {
            this.getConfigContainerPanel().removeAll();
            this.getConfigContainerPanel().setVisible(false);
            this.shownMethodType = null;
            return;
        }
        if (this.shownMethodType != null && newMethodType.getClass().equals(this.shownMethodType.getClass())) {
            return;
        }
        log.info((Object)("Creating new panel for configuring: " + newMethodType.getName()));
        this.getConfigContainerPanel().removeAll();
        if (newMethodType.hasOptionsPanel()) {
            this.shownConfigPanel = newMethodType.buildOptionsPanel(this.getUISharedContext());
            this.getConfigContainerPanel().add((Component)this.shownConfigPanel, "Center");
        } else {
            this.shownConfigPanel = null;
            this.getConfigContainerPanel().add((Component)new JLabel(LABEL_CONFIG_NOT_NEEDED), "Center");
        }
        this.shownMethodType = newMethodType;
        this.getConfigContainerPanel().setVisible(true);
        this.getConfigContainerPanel().revalidate();
    }

    protected JComboBox<AuthenticationMethodType> getAuthenticationMethodsComboBox() {
        if (this.authenticationMethodsComboBox == null) {
            Vector<AuthenticationMethodType> methods = new Vector<AuthenticationMethodType>(this.extension.getAuthenticationMethodTypes());
            this.authenticationMethodsComboBox = new JComboBox<AuthenticationMethodType>(methods);
            this.authenticationMethodsComboBox.setSelectedItem(null);
            this.authenticationMethodsComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !e.getItem().equals(ContextAuthenticationPanel.this.shownMethodType)) {
                        log.debug((Object)("Selected new Authentication type: " + e.getItem()));
                        if (ContextAuthenticationPanel.this.needsConfirm && !ContextAuthenticationPanel.this.confirmAndExecuteUsersDeletion()) {
                            log.debug((Object)"Cancelled change of authentication type.");
                            ContextAuthenticationPanel.this.authenticationMethodsComboBox.setSelectedItem(ContextAuthenticationPanel.this.shownMethodType);
                            return;
                        }
                        ContextAuthenticationPanel.this.resetLoggedInOutIndicators();
                        AuthenticationMethodType type = (AuthenticationMethodType)e.getItem();
                        if (ContextAuthenticationPanel.this.selectedAuthenticationMethod == null || !type.isTypeForMethod(ContextAuthenticationPanel.this.selectedAuthenticationMethod)) {
                            ContextAuthenticationPanel.this.selectedAuthenticationMethod = type.createAuthenticationMethod(ContextAuthenticationPanel.this.getContextIndex());
                        }
                        ContextAuthenticationPanel.this.changeMethodConfigPanel(type);
                        if (type.hasOptionsPanel()) {
                            ContextAuthenticationPanel.this.shownConfigPanel.bindMethod(ContextAuthenticationPanel.this.selectedAuthenticationMethod, ContextAuthenticationPanel.this.getAuthenticationIndicatorsPanel());
                        }
                    }
                }
            });
        }
        return this.authenticationMethodsComboBox;
    }

    private AuthenticationIndicatorsPanel getAuthenticationIndicatorsPanel() {
        if (this.authenticationIndicatorsPanel == null) {
            this.authenticationIndicatorsPanel = new AuthenticationIndicatorsPanelImpl();
        }
        return this.authenticationIndicatorsPanel;
    }

    private boolean confirmAndExecuteUsersDeletion() {
        ExtensionUserManagement usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
        if (usersExtension != null && usersExtension.getSharedContextUsers(this.getUISharedContext()).size() > 0) {
            this.authenticationMethodsComboBox.transferFocus();
            int choice = JOptionPane.showConfirmDialog(this, Constant.messages.getString("authentication.dialog.confirmChange.label"), Constant.messages.getString("authentication.dialog.confirmChange.title"), 2);
            if (choice == 2) {
                return false;
            }
            usersExtension.removeSharedContextUsers(this.getUISharedContext());
        }
        return true;
    }

    private JPanel getConfigContainerPanel() {
        if (this.configContainerPanel == null) {
            this.configContainerPanel = new JPanel(new BorderLayout());
            this.configContainerPanel.setBorder(BorderFactory.createTitledBorder(null, PANEL_TITLE_CONFIG, 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
        }
        return this.configContainerPanel;
    }

    private ZapTextField getLoggedInIndicaterRegexField() {
        if (this.loggedInIndicaterRegexField == null) {
            this.loggedInIndicaterRegexField = new ZapTextField();
        }
        return this.loggedInIndicaterRegexField;
    }

    private ZapTextField getLoggedOutIndicaterRegexField() {
        if (this.loggedOutIndicaterRegexField == null) {
            this.loggedOutIndicaterRegexField = new ZapTextField();
        }
        return this.loggedOutIndicaterRegexField;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.context-auth";
    }

    @Override
    public void initContextData(Session session, Context uiSharedContext) {
        this.selectedAuthenticationMethod = uiSharedContext.getAuthenticationMethod();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing configuration panel for authentication method: " + this.selectedAuthenticationMethod + " for context " + uiSharedContext.getName()));
        }
        this.resetLoggedInOutIndicators();
        if (this.selectedAuthenticationMethod != null) {
            if (this.selectedAuthenticationMethod.getLoggedInIndicatorPattern() != null) {
                this.getLoggedInIndicaterRegexField().setText(this.selectedAuthenticationMethod.getLoggedInIndicatorPattern().pattern());
            } else {
                this.getLoggedInIndicaterRegexField().setText("");
            }
            if (this.selectedAuthenticationMethod.getLoggedOutIndicatorPattern() != null) {
                this.getLoggedOutIndicaterRegexField().setText(this.selectedAuthenticationMethod.getLoggedOutIndicatorPattern().pattern());
            } else {
                this.getLoggedOutIndicaterRegexField().setText("");
            }
            if (this.shownMethodType != null && this.shownMethodType.isTypeForMethod(this.selectedAuthenticationMethod)) {
                if (this.shownMethodType.hasOptionsPanel()) {
                    log.debug((Object)("Binding authentication method to existing panel of proper type for context " + uiSharedContext.getName()));
                    this.shownConfigPanel.bindMethod(this.selectedAuthenticationMethod, this.getAuthenticationIndicatorsPanel());
                }
                return;
            }
            for (AuthenticationMethodType type : this.extension.getAuthenticationMethodTypes()) {
                if (!type.isTypeForMethod(this.selectedAuthenticationMethod)) continue;
                log.debug((Object)("Binding authentication method to new panel of proper type for context " + uiSharedContext.getName()));
                this.needsConfirm = false;
                this.getAuthenticationMethodsComboBox().setSelectedItem(type);
                this.needsConfirm = true;
                break;
            }
        }
    }

    private void resetLoggedInOutIndicators() {
        this.getLoggedInIndicaterRegexField().setToolTipText(null);
        this.getLoggedInIndicaterRegexField().setEnabled(true);
        this.getLoggedOutIndicaterRegexField().setToolTipText(null);
        this.getLoggedOutIndicaterRegexField().setEnabled(true);
    }

    @Override
    public void validateContextData(Session session) throws Exception {
        if (this.shownConfigPanel != null) {
            this.shownConfigPanel.validateFields();
        }
        try {
            Pattern.compile(this.getLoggedInIndicaterRegexField().getText());
            Pattern.compile(this.getLoggedOutIndicaterRegexField().getText());
        }
        catch (PatternSyntaxException e) {
            throw new IllegalStateException(Constant.messages.getString("authentication.panel.error.illegalPattern", this.getUISharedContext().getName()), e);
        }
    }

    private void saveMethod() {
        if (this.shownConfigPanel != null) {
            this.shownConfigPanel.saveMethod();
        }
        this.selectedAuthenticationMethod.setLoggedInIndicatorPattern(this.getLoggedInIndicaterRegexField().getText());
        this.selectedAuthenticationMethod.setLoggedOutIndicatorPattern(this.getLoggedOutIndicaterRegexField().getText());
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        this.saveMethod();
        Context context = session.getContext(this.getContextIndex());
        if (context.getAuthenticationMethod() != null && !this.shownMethodType.isTypeForMethod(context.getAuthenticationMethod())) {
            context.getAuthenticationMethod().onMethodDiscarded();
        }
        context.setAuthenticationMethod(this.selectedAuthenticationMethod);
        this.selectedAuthenticationMethod.onMethodPersisted();
    }

    @Override
    public void saveTemporaryContextData(Context uiSharedContext) {
        this.saveMethod();
        uiSharedContext.setAuthenticationMethod(this.selectedAuthenticationMethod);
    }

    private class AuthenticationIndicatorsPanelImpl
    implements AuthenticationIndicatorsPanel {
        private AuthenticationIndicatorsPanelImpl() {
        }

        @Override
        public String getLoggedInIndicatorPattern() {
            return ContextAuthenticationPanel.this.getLoggedInIndicaterRegexField().getText();
        }

        @Override
        public void setLoggedInIndicatorPattern(String loggedInIndicatorPattern) {
            ContextAuthenticationPanel.this.getLoggedInIndicaterRegexField().setText(loggedInIndicatorPattern);
        }

        @Override
        public void setLoggedInIndicatorEnabled(boolean enabled) {
            ContextAuthenticationPanel.this.getLoggedInIndicaterRegexField().setEnabled(enabled);
        }

        @Override
        public void setLoggedInIndicatorToolTip(String toolTip) {
            ContextAuthenticationPanel.this.getLoggedInIndicaterRegexField().setToolTipText(toolTip);
        }

        @Override
        public String getLoggedOutIndicatorPattern() {
            return ContextAuthenticationPanel.this.getLoggedOutIndicaterRegexField().getText();
        }

        @Override
        public void setLoggedOutIndicatorPattern(String loggedOutIndicatorPattern) {
            ContextAuthenticationPanel.this.getLoggedOutIndicaterRegexField().setText(loggedOutIndicatorPattern);
        }

        @Override
        public void setLoggedOutIndicatorEnabled(boolean enabled) {
            ContextAuthenticationPanel.this.getLoggedOutIndicaterRegexField().setEnabled(enabled);
        }

        @Override
        public void setLoggedOutIndicatorToolTip(String toolTip) {
            ContextAuthenticationPanel.this.getLoggedOutIndicaterRegexField().setToolTipText(toolTip);
        }
    }
}

