/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.ACM;
import Ice.ACMClose;
import Ice.ACMHeartbeat;
import Ice.AsyncResult;
import Ice.BadMagicException;
import Ice.Callback;
import Ice.Callback_Connection_flushBatchRequests;
import Ice.Callback_Connection_heartbeat;
import Ice.CloseCallback;
import Ice.CloseConnectionException;
import Ice.CloseTimeoutException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.CompressBatch;
import Ice.ConnectTimeoutException;
import Ice.Connection;
import Ice.ConnectionClose;
import Ice.ConnectionInfo;
import Ice.ConnectionLostException;
import Ice.ConnectionManuallyClosedException;
import Ice.ConnectionNotValidatedException;
import Ice.ConnectionTimeoutException;
import Ice.DatagramLimitException;
import Ice.EncodingVersion;
import Ice.Endpoint;
import Ice.Exception;
import Ice.FeatureNotSupportedException;
import Ice.HeartbeatCallback;
import Ice.Identity;
import Ice.IllegalMessageSizeException;
import Ice.InitializationData;
import Ice.InputStream;
import Ice.Instrumentation.ConnectionObserver;
import Ice.Instrumentation.ConnectionState;
import Ice.IntOptional;
import Ice.LocalException;
import Ice.Logger;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.ObjectPrx;
import Ice.OperationInterruptedException;
import Ice.Optional;
import Ice.OutputStream;
import Ice.ProtocolVersion;
import Ice.SocketException;
import Ice.SyscallException;
import Ice.SystemException;
import Ice.TimeoutException;
import Ice.UnknownException;
import Ice.UnknownMessageException;
import Ice.UnmarshalOutOfBoundsException;
import IceInternal.ACMConfig;
import IceInternal.ACMMonitor;
import IceInternal.BZip2;
import IceInternal.BatchRequestQueue;
import IceInternal.Buffer;
import IceInternal.CallbackBase;
import IceInternal.CancellationHandler;
import IceInternal.ConnectionFlushBatch;
import IceInternal.Connector;
import IceInternal.DefaultsAndOverrides;
import IceInternal.DispatchWorkItem;
import IceInternal.EndpointI;
import IceInternal.EventHandler;
import IceInternal.Ex;
import IceInternal.Functional_BoolCallback;
import IceInternal.Functional_CallbackBase;
import IceInternal.Functional_GenericCallback1;
import IceInternal.Functional_VoidCallback;
import IceInternal.Incoming;
import IceInternal.Instance;
import IceInternal.OutgoingAsync;
import IceInternal.OutgoingAsyncBase;
import IceInternal.Protocol;
import IceInternal.ReadyCallback;
import IceInternal.ResponseHandler;
import IceInternal.RetryException;
import IceInternal.ServantError;
import IceInternal.ServantManager;
import IceInternal.ThreadPool;
import IceInternal.ThreadPoolCurrent;
import IceInternal.Time;
import IceInternal.TraceLevels;
import IceInternal.TraceUtil;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.SelectableChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ConnectionI
extends EventHandler
implements Connection,
ResponseHandler,
CancellationHandler {
    public static final int ObjectAdapterDeactivated = 0;
    public static final int CommunicatorDestroyed = 1;
    private static final String _flushBatchRequests_name = "flushBatchRequests";
    private static final String _heartbeat_name = "heartbeat";
    private static final int StateNotInitialized = 0;
    private static final int StateNotValidated = 1;
    private static final int StateActive = 2;
    private static final int StateHolding = 3;
    private static final int StateClosing = 4;
    private static final int StateClosingPending = 5;
    private static final int StateClosed = 6;
    private static final int StateFinished = 7;
    private Communicator _communicator;
    private final Instance _instance;
    private ACMMonitor _monitor;
    private final Transceiver _transceiver;
    private String _desc;
    private final String _type;
    private final Connector _connector;
    private final EndpointI _endpoint;
    private ObjectAdapter _adapter;
    private ServantManager _servantManager;
    private final boolean _dispatcher;
    private final Logger _logger;
    private final TraceLevels _traceLevels;
    private final ThreadPool _threadPool;
    private final ScheduledExecutorService _timer;
    private final Runnable _writeTimeout;
    private Future<?> _writeTimeoutFuture;
    private final Runnable _readTimeout;
    private Future<?> _readTimeoutFuture;
    private StartCallback _startCallback = null;
    private final boolean _warn;
    private final boolean _warnUdp;
    private long _acmLastActivity;
    private final int _compressionLevel;
    private int _nextRequestId;
    private Map<Integer, OutgoingAsyncBase> _asyncRequests = new HashMap<Integer, OutgoingAsyncBase>();
    private LocalException _exception;
    private final int _messageSizeMax;
    private BatchRequestQueue _batchRequestQueue;
    private LinkedList<OutgoingMessage> _sendStreams = new LinkedList();
    private InputStream _readStream;
    private boolean _readHeader;
    private OutputStream _writeStream;
    private ConnectionObserver _observer;
    private int _readStreamPos;
    private int _writeStreamPos;
    private int _dispatchCount;
    private int _state;
    private boolean _shutdownInitiated = false;
    private boolean _initialized = false;
    private boolean _validated = false;
    private Incoming _incomingCache;
    private final Object _incomingCacheMutex = new Object();
    private ProtocolVersion _readProtocol = new ProtocolVersion();
    private EncodingVersion _readProtocolEncoding = new EncodingVersion();
    private int _cacheBuffers;
    private ConnectionInfo _info;
    private CloseCallback _closeCallback;
    private HeartbeatCallback _heartbeatCallback;
    private static ConnectionState[] connectionStateMap = new ConnectionState[]{ConnectionState.ConnectionStateValidating, ConnectionState.ConnectionStateValidating, ConnectionState.ConnectionStateActive, ConnectionState.ConnectionStateHolding, ConnectionState.ConnectionStateClosing, ConnectionState.ConnectionStateClosing, ConnectionState.ConnectionStateClosed, ConnectionState.ConnectionStateClosed};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartCallback callback) {
        try {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                if (this._state >= 6) {
                    assert (this._exception != null);
                    throw (LocalException)this._exception.fillInStackTrace();
                }
                if (!this.initialize(0) || !this.validate(0)) {
                    this._startCallback = callback;
                    return;
                }
                this.setState(3);
            }
        }
        catch (LocalException ex) {
            this.exception(ex);
            callback.connectionStartFailed(this, this._exception);
            return;
        }
        callback.connectionStartCompleted(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAndWait() throws InterruptedException {
        try {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                if (this._state >= 6) {
                    assert (this._exception != null);
                    throw (LocalException)this._exception.fillInStackTrace();
                }
                if (!this.initialize(0) || !this.validate(0)) {
                    while (this._state <= 1) {
                        this.wait();
                    }
                    if (this._state >= 4) {
                        assert (this._exception != null);
                        throw (LocalException)this._exception.fillInStackTrace();
                    }
                }
                this.setState(3);
            }
        }
        catch (LocalException ex) {
            this.exception(ex);
            this.waitUntilFinished();
        }
    }

    public synchronized void activate() {
        if (this._state <= 1) {
            return;
        }
        if (this._acmLastActivity > 0L) {
            this._acmLastActivity = Time.currentMonotonicTimeMillis();
        }
        this.setState(2);
    }

    public synchronized void hold() {
        if (this._state <= 1) {
            return;
        }
        this.setState(3);
    }

    public synchronized void destroy(int reason) {
        switch (reason) {
            case 0: {
                this.setState(4, new ObjectAdapterDeactivatedException());
                break;
            }
            case 1: {
                this.setState(4, new CommunicatorDestroyedException());
            }
        }
    }

    @Override
    public void close(final ConnectionClose mode) {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        if (this._instance.queueRequests()) {
            this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ConnectionI.this.closeImpl(mode);
                    return null;
                }
            });
        } else {
            this.closeImpl(mode);
        }
    }

    private synchronized void closeImpl(ConnectionClose mode) {
        if (mode == ConnectionClose.Forcefully) {
            this.setState(6, new ConnectionManuallyClosedException(false));
        } else if (mode == ConnectionClose.Gracefully) {
            this.setState(4, new ConnectionManuallyClosedException(true));
        } else {
            assert (mode == ConnectionClose.GracefullyWithWait);
            while (!this._asyncRequests.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new OperationInterruptedException();
                }
            }
            this.setState(4, new ConnectionManuallyClosedException(true));
        }
    }

    public synchronized boolean isActiveOrHolding() {
        return this._state > 1 && this._state < 4;
    }

    public synchronized boolean isFinished() {
        if (this._state != 7 || this._dispatchCount != 0) {
            return false;
        }
        assert (this._state == 7);
        return true;
    }

    @Override
    public synchronized void throwException() {
        if (this._exception != null) {
            assert (this._state >= 4);
            throw (LocalException)this._exception.fillInStackTrace();
        }
    }

    public synchronized void waitUntilHolding() throws InterruptedException {
        while (this._state < 3 || this._dispatchCount > 0) {
            this.wait();
        }
    }

    public synchronized void waitUntilFinished() throws InterruptedException {
        while (this._state < 7 || this._dispatchCount > 0) {
            this.wait();
        }
        assert (this._state == 7);
        this._adapter = null;
    }

    public synchronized void updateObserver() {
        if (this._state < 1 || this._state > 6) {
            return;
        }
        assert (this._instance.initializationData().observer != null);
        this._observer = this._instance.initializationData().observer.getConnectionObserver(this.initConnectionInfo(), this._endpoint, this.toConnectionState(this._state), this._observer);
        if (this._observer != null) {
            this._observer.attach();
        } else {
            this._writeStreamPos = -1;
            this._readStreamPos = -1;
        }
    }

    public synchronized void monitor(long now, ACMConfig acm) {
        if (this._state != 2) {
            return;
        }
        if ((acm.heartbeat == ACMHeartbeat.HeartbeatAlways || acm.heartbeat != ACMHeartbeat.HeartbeatOff && this._writeStream.isEmpty() && now >= this._acmLastActivity + (long)(acm.timeout / 4)) && (acm.heartbeat != ACMHeartbeat.HeartbeatOnDispatch || this._dispatchCount > 0)) {
            this.sendHeartbeatNow();
        }
        if (this._readStream.size() > 14 || !this._writeStream.isEmpty()) {
            return;
        }
        if (acm.close != ACMClose.CloseOff && now >= this._acmLastActivity + (long)acm.timeout) {
            if (acm.close == ACMClose.CloseOnIdleForceful || acm.close != ACMClose.CloseOnIdle && !this._asyncRequests.isEmpty()) {
                this.setState(6, new ConnectionTimeoutException());
            } else if (acm.close != ACMClose.CloseOnInvocation && this._dispatchCount == 0 && this._batchRequestQueue.isEmpty() && this._asyncRequests.isEmpty()) {
                this.setState(4, new ConnectionTimeoutException());
            }
        }
    }

    public synchronized int sendAsyncRequest(OutgoingAsyncBase out, boolean compress, boolean response, int batchRequestNum) throws RetryException {
        int status;
        OutputStream os = out.getOs();
        if (this._exception != null) {
            throw new RetryException((LocalException)this._exception.fillInStackTrace());
        }
        assert (this._state > 1);
        assert (this._state < 4);
        this._transceiver.checkSendSize(os.getBuffer());
        out.cancelable(this);
        int requestId = 0;
        if (response) {
            if ((requestId = this._nextRequestId++) <= 0) {
                this._nextRequestId = 1;
                requestId = this._nextRequestId++;
            }
            os.pos(14);
            os.writeInt(requestId);
        } else if (batchRequestNum > 0) {
            os.pos(14);
            os.writeInt(batchRequestNum);
        }
        out.attachRemoteObserver(this.initConnectionInfo(), this._endpoint, requestId);
        try {
            status = this.sendMessage(new OutgoingMessage(out, os, compress, requestId));
        }
        catch (LocalException ex) {
            this.setState(6, ex);
            assert (this._exception != null);
            throw (LocalException)this._exception.fillInStackTrace();
        }
        if (response) {
            this._asyncRequests.put(requestId, out);
        }
        return status;
    }

    public BatchRequestQueue getBatchRequestQueue() {
        return this._batchRequestQueue;
    }

    @Override
    public void flushBatchRequests(CompressBatch compressBatch) {
        this.end_flushBatchRequests(this.begin_flushBatchRequests(compressBatch));
    }

    @Override
    public AsyncResult begin_flushBatchRequests(CompressBatch compressBatch) {
        return this.begin_flushBatchRequestsInternal(compressBatch, null);
    }

    @Override
    public AsyncResult begin_flushBatchRequests(CompressBatch compressBatch, Callback cb) {
        return this.begin_flushBatchRequestsInternal(compressBatch, cb);
    }

    @Override
    public AsyncResult begin_flushBatchRequests(CompressBatch compressBatch, Callback_Connection_flushBatchRequests cb) {
        return this.begin_flushBatchRequestsInternal(compressBatch, cb);
    }

    @Override
    public AsyncResult begin_flushBatchRequests(CompressBatch compressBatch, Functional_VoidCallback responseCb, Functional_GenericCallback1<Exception> exceptionCb, Functional_BoolCallback sentCb) {
        return this.begin_flushBatchRequestsInternal(compressBatch, new Functional_CallbackBase(false, exceptionCb, sentCb){

            @Override
            public final void _iceCompleted(AsyncResult result) {
                try {
                    result.getConnection().end_flushBatchRequests(result);
                }
                catch (Exception ex) {
                    this._exceptionCb.apply(ex);
                }
            }
        });
    }

    private AsyncResult begin_flushBatchRequestsInternal(CompressBatch compressBatch, CallbackBase cb) {
        ConnectionFlushBatch result = new ConnectionFlushBatch(this, this._communicator, this._instance, _flushBatchRequests_name, cb);
        result.invoke(compressBatch);
        return result;
    }

    @Override
    public void end_flushBatchRequests(AsyncResult ir) {
        ConnectionFlushBatch r = ConnectionFlushBatch.check(ir, this, _flushBatchRequests_name);
        r.waitForResponseOrUserEx();
    }

    @Override
    public synchronized void setCloseCallback(final CloseCallback callback) {
        if (this._state >= 6) {
            if (callback != null) {
                this._threadPool.dispatch(new DispatchWorkItem(this){

                    @Override
                    public void run() {
                        try {
                            callback.closed(ConnectionI.this);
                        }
                        catch (Exception ex) {
                            ConnectionI.this._logger.error("connection callback exception:\n" + ex + '\n' + ConnectionI.this._desc);
                        }
                    }
                });
            }
        } else {
            this._closeCallback = callback;
        }
    }

    @Override
    public synchronized void setHeartbeatCallback(HeartbeatCallback callback) {
        if (this._state >= 6) {
            return;
        }
        this._heartbeatCallback = callback;
    }

    @Override
    public void heartbeat() {
        this.end_heartbeat(this.begin_heartbeat());
    }

    @Override
    public AsyncResult begin_heartbeat() {
        return this.begin_heartbeatInternal(null);
    }

    @Override
    public AsyncResult begin_heartbeat(Callback cb) {
        return this.begin_heartbeatInternal(cb);
    }

    @Override
    public AsyncResult begin_heartbeat(Callback_Connection_heartbeat cb) {
        return this.begin_heartbeatInternal(cb);
    }

    @Override
    public AsyncResult begin_heartbeat(Functional_VoidCallback responseCb, final Functional_GenericCallback1<Exception> exceptionCb, Functional_BoolCallback sentCb) {
        return this.begin_heartbeatInternal(new Functional_CallbackBase(false, exceptionCb, sentCb){

            @Override
            public final void _iceCompleted(AsyncResult result) {
                try {
                    result.getConnection().end_heartbeat(result);
                }
                catch (Exception ex) {
                    exceptionCb.apply(ex);
                }
            }
        });
    }

    private AsyncResult begin_heartbeatInternal(CallbackBase cb) {
        HeartbeatAsync result = new HeartbeatAsync(this, this._communicator, this._instance, _heartbeat_name, cb);
        result.invoke();
        return result;
    }

    @Override
    public void end_heartbeat(AsyncResult ir) {
        HeartbeatAsync r = HeartbeatAsync.check(ir, this, _heartbeat_name);
        r.waitForResponseOrUserEx();
    }

    @Override
    public synchronized void setACM(IntOptional timeout, Optional<ACMClose> close, Optional<ACMHeartbeat> heartbeat) {
        if (this._monitor == null || this._state >= 6) {
            return;
        }
        if (this._state == 2) {
            this._monitor.remove(this);
        }
        this._monitor = this._monitor.acm(timeout, close, heartbeat);
        if (this._monitor.getACM().timeout <= 0) {
            this._acmLastActivity = -1L;
        } else if (this._state == 2 && this._acmLastActivity == -1L) {
            this._acmLastActivity = Time.currentMonotonicTimeMillis();
        }
        if (this._state == 2) {
            this._monitor.add(this);
        }
    }

    @Override
    public synchronized ACM getACM() {
        return this._monitor != null ? this._monitor.getACM() : new ACM(0, ACMClose.CloseOff, ACMHeartbeat.HeartbeatOff);
    }

    @Override
    public synchronized void asyncRequestCanceled(OutgoingAsyncBase outAsync, LocalException ex) {
        Object o;
        if (this._state >= 6) {
            return;
        }
        Iterator it = this._sendStreams.iterator();
        while (it.hasNext()) {
            o = (OutgoingMessage)it.next();
            if (((OutgoingMessage)o).outAsync != outAsync) continue;
            if (((OutgoingMessage)o).requestId > 0) {
                this._asyncRequests.remove(((OutgoingMessage)o).requestId);
            }
            if (ex instanceof ConnectionTimeoutException) {
                this.setState(6, ex);
            } else {
                ((OutgoingMessage)o).canceled();
                if (o != this._sendStreams.getFirst()) {
                    it.remove();
                }
                if (outAsync.completed(ex)) {
                    outAsync.invokeCompletedAsync();
                }
            }
            return;
        }
        if (outAsync instanceof OutgoingAsync) {
            o = (OutgoingAsync)outAsync;
            Iterator<OutgoingAsyncBase> it2 = this._asyncRequests.values().iterator();
            while (it2.hasNext()) {
                if (it2.next() != o) continue;
                if (ex instanceof ConnectionTimeoutException) {
                    this.setState(6, ex);
                } else {
                    it2.remove();
                    if (outAsync.completed(ex)) {
                        outAsync.invokeCompletedAsync();
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(int requestId, final OutputStream os, final byte compressFlag, boolean amd) {
        boolean queueResponse = this._instance.queueRequests();
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            assert (this._state > 1);
            if (!queueResponse) {
                this.sendResponseImpl(os, compressFlag);
            }
        }
        if (queueResponse) {
            this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ConnectionI.this.sendResponseImpl(os, compressFlag);
                    return null;
                }
            });
        }
    }

    private synchronized void sendResponseImpl(OutputStream os, byte compressFlag) {
        try {
            if (--this._dispatchCount == 0) {
                if (this._state == 7) {
                    this.reap();
                }
                this.notifyAll();
            }
            if (this._state < 6) {
                this.sendMessage(new OutgoingMessage(os, compressFlag != 0, true));
                if (this._state == 4 && this._dispatchCount == 0) {
                    this.initiateShutdown();
                }
            }
        }
        catch (LocalException ex) {
            this.setState(6, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNoResponse() {
        boolean shutdown = false;
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            assert (this._state > 1);
            try {
                if (--this._dispatchCount == 0) {
                    if (this._state == 7) {
                        this.reap();
                    }
                    this.notifyAll();
                }
                if (this._state >= 6) {
                    assert (this._exception != null);
                    throw (LocalException)this._exception.fillInStackTrace();
                }
                if (this._state == 4 && this._dispatchCount == 0) {
                    if (this._instance.queueRequests()) {
                        shutdown = true;
                    } else {
                        this.initiateShutdown();
                    }
                }
            }
            catch (LocalException ex) {
                this.setState(6, ex);
            }
        }
        if (shutdown) {
            this.queueShutdown(false);
        }
    }

    @Override
    public boolean systemException(int requestId, SystemException ex, boolean amd) {
        return false;
    }

    @Override
    public synchronized void invokeException(int requestId, LocalException ex, int invokeNum, boolean amd) {
        this.setState(6, ex);
        if (invokeNum > 0) {
            assert (this._dispatchCount > 0);
            this._dispatchCount -= invokeNum;
            assert (this._dispatchCount >= 0);
            if (this._dispatchCount == 0) {
                if (this._state == 7) {
                    this.reap();
                }
                this.notifyAll();
            }
        }
    }

    public EndpointI endpoint() {
        return this._endpoint;
    }

    public Connector connector() {
        return this._connector;
    }

    @Override
    public synchronized void setAdapter(ObjectAdapter adapter) {
        if (this._state <= 1 || this._state >= 4) {
            return;
        }
        this._adapter = adapter;
        if (this._adapter != null) {
            this._servantManager = ((ObjectAdapterI)this._adapter).getServantManager();
            if (this._servantManager == null) {
                this._adapter = null;
            }
        } else {
            this._servantManager = null;
        }
    }

    @Override
    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    @Override
    public Endpoint getEndpoint() {
        return this._endpoint;
    }

    @Override
    public ObjectPrx createProxy(Identity ident) {
        return this._instance.proxyFactory().referenceToProxy(this._instance.referenceFactory().create(ident, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(ThreadPoolCurrent current) {
        StartCallback startCB = null;
        LinkedList<OutgoingMessage> sentCBs = null;
        MessageInfo info = null;
        int dispatchCount = 0;
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            if (this._state >= 6) {
                return;
            }
            if (!current.ioReady()) {
                return;
            }
            int readyOp = current.operation;
            try {
                Buffer buf;
                this.unscheduleTimeout(current.operation);
                int writeOp = 0;
                int readOp = 0;
                if ((readyOp & 4) != 0) {
                    buf = this._writeStream.getBuffer();
                    if (this._observer != null) {
                        this.observerStartWrite(buf);
                    }
                    writeOp = this.write(buf);
                    if (this._observer != null && (writeOp & 4) == 0) {
                        this.observerFinishWrite(buf);
                    }
                }
                while ((readyOp & 1) != 0) {
                    buf = this._readStream.getBuffer();
                    if (this._observer != null && !this._readHeader) {
                        this.observerStartRead(buf);
                    }
                    if (((readOp = this.read(buf)) & 1) != 0) break;
                    if (this._observer != null && !this._readHeader) {
                        assert (!buf.b.hasRemaining());
                        this.observerFinishRead(buf);
                    }
                    if (this._readHeader) {
                        int pos;
                        this._readHeader = false;
                        if (this._observer != null) {
                            this._observer.receivedBytes(14);
                        }
                        if ((pos = this._readStream.pos()) < 14) {
                            throw new IllegalMessageSizeException();
                        }
                        this._readStream.pos(0);
                        byte[] m = new byte[]{this._readStream.readByte(), this._readStream.readByte(), this._readStream.readByte(), this._readStream.readByte()};
                        if (m[0] != Protocol.magic[0] || m[1] != Protocol.magic[1] || m[2] != Protocol.magic[2] || m[3] != Protocol.magic[3]) {
                            BadMagicException ex = new BadMagicException();
                            ex.badMagic = m;
                            throw ex;
                        }
                        this._readProtocol.ice_readMembers(this._readStream);
                        Protocol.checkSupportedProtocol(this._readProtocol);
                        this._readProtocolEncoding.ice_readMembers(this._readStream);
                        Protocol.checkSupportedProtocolEncoding(this._readProtocolEncoding);
                        this._readStream.readByte();
                        this._readStream.readByte();
                        int size = this._readStream.readInt();
                        if (size < 14) {
                            throw new IllegalMessageSizeException();
                        }
                        if (size > this._messageSizeMax) {
                            Ex.throwMemoryLimitException(size, this._messageSizeMax);
                        }
                        if (size > this._readStream.size()) {
                            this._readStream.resize(size);
                        }
                        this._readStream.pos(pos);
                    }
                    if (this._readStream.pos() == this._readStream.size()) break;
                    if (!this._endpoint.datagram()) continue;
                    throw new DatagramLimitException();
                }
                int newOp = readOp | writeOp;
                assert ((readyOp &= ~newOp) != 0 || newOp != 0);
                if (this._state <= 1) {
                    if (newOp != 0) {
                        this.scheduleTimeout(newOp);
                        this._threadPool.update(this, current.operation, newOp);
                        return;
                    }
                    if (this._state == 0 && !this.initialize(current.operation)) {
                        return;
                    }
                    if (this._state <= 1 && !this.validate(current.operation)) {
                        return;
                    }
                    this._threadPool.unregister(this, current.operation);
                    this.setState(3);
                    if (this._startCallback != null) {
                        startCB = this._startCallback;
                        this._startCallback = null;
                        if (startCB != null) {
                            ++dispatchCount;
                        }
                    }
                } else {
                    assert (this._state <= 5);
                    if ((readyOp & 1) != 0) {
                        info = new MessageInfo(current.stream);
                        newOp |= this.parseMessage(info);
                        dispatchCount += info.messageDispatchCount;
                    }
                    if ((readyOp & 4) != 0) {
                        sentCBs = new LinkedList<OutgoingMessage>();
                        newOp |= this.sendNextMessage(sentCBs);
                        if (!sentCBs.isEmpty()) {
                            ++dispatchCount;
                        } else {
                            sentCBs = null;
                        }
                    }
                    if (this._state < 6) {
                        this.scheduleTimeout(newOp);
                        this._threadPool.update(this, current.operation, newOp);
                    }
                }
                if (this._acmLastActivity > 0L) {
                    this._acmLastActivity = Time.currentMonotonicTimeMillis();
                }
                if (dispatchCount == 0) {
                    return;
                }
                this._dispatchCount += dispatchCount;
                current.ioCompleted();
            }
            catch (DatagramLimitException ex) {
                if (this._warnUdp) {
                    this._logger.warning("maximum datagram size of " + this._readStream.pos() + " exceeded");
                }
                this._readStream.resize(14);
                this._readStream.pos(0);
                this._readHeader = true;
                return;
            }
            catch (SocketException ex) {
                this.setState(6, ex);
                return;
            }
            catch (LocalException ex) {
                if (this._endpoint.datagram()) {
                    if (this._warn) {
                        String s = "datagram connection exception:\n" + ex + '\n' + this._desc;
                        this._logger.warning(s);
                    }
                    this._readStream.resize(14);
                    this._readStream.pos(0);
                    this._readHeader = true;
                } else {
                    this.setState(6, ex);
                }
                return;
            }
        }
        if (!this._dispatcher) {
            this.dispatch(startCB, sentCBs, info);
        } else {
            if (info != null && info.heartbeatCallback == null) {
                assert (info.stream == current.stream);
                InputStream stream = info.stream;
                info.stream = new InputStream(this._instance, Protocol.currentProtocolEncoding);
                info.stream.swap(stream);
            }
            final StartCallback finalStartCB = startCB;
            final LinkedList<OutgoingMessage> finalSentCBs = sentCBs;
            final MessageInfo finalInfo = info;
            this._threadPool.dispatchFromThisThread(new DispatchWorkItem(this){

                @Override
                public void run() {
                    ConnectionI.this.dispatch(finalStartCB, finalSentCBs, finalInfo);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(StartCallback startCB, List<OutgoingMessage> sentCBs, MessageInfo info) {
        int dispatchedCount = 0;
        if (startCB != null) {
            startCB.connectionStartCompleted(this);
            ++dispatchedCount;
        }
        if (sentCBs != null) {
            for (OutgoingMessage msg : sentCBs) {
                msg.outAsync.invokeSent();
            }
            ++dispatchedCount;
        }
        if (info != null) {
            if (info.outAsync != null) {
                info.outAsync.invokeCompleted();
                ++dispatchedCount;
            }
            if (info.heartbeatCallback != null) {
                try {
                    info.heartbeatCallback.heartbeat(this);
                }
                catch (Exception ex) {
                    this._logger.error("connection callback exception:\n" + ex + '\n' + this._desc);
                }
                ++dispatchedCount;
            }
            if (info.invokeNum > 0) {
                this.invokeAll(info.stream, info.invokeNum, info.requestId, info.compress, info.servantManager, info.adapter);
            }
        }
        if (dispatchedCount > 0) {
            boolean shutdown = false;
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                this._dispatchCount -= dispatchedCount;
                if (this._dispatchCount == 0) {
                    if (this._state == 4) {
                        if (this._instance.queueRequests()) {
                            shutdown = true;
                        } else {
                            try {
                                this.initiateShutdown();
                            }
                            catch (LocalException ex) {
                                this.setState(6, ex);
                            }
                        }
                    } else if (this._state == 7) {
                        this.reap();
                    }
                    if (!shutdown) {
                        this.notifyAll();
                    }
                }
            }
            if (shutdown) {
                this.queueShutdown(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(ThreadPoolCurrent current, final boolean close) {
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            assert (this._state == 6);
            this.unscheduleTimeout(5);
        }
        if (this._startCallback == null && this._sendStreams.isEmpty() && this._asyncRequests.isEmpty() && this._closeCallback == null && this._heartbeatCallback == null) {
            this.finish(close);
            return;
        }
        current.ioCompleted();
        if (!this._dispatcher) {
            this.finish(close);
        } else {
            this._threadPool.dispatchFromThisThread(new DispatchWorkItem(this){

                @Override
                public void run() {
                    ConnectionI.this.finish(close);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(boolean close) {
        StringBuffer s;
        if (!this._initialized) {
            if (this._instance.traceLevels().network >= 2) {
                s = new StringBuffer("failed to ");
                s.append(this._connector != null ? "establish" : "accept");
                s.append(" ");
                s.append(this._endpoint.protocol());
                s.append(" connection\n");
                s.append(this.toString());
                s.append("\n");
                s.append(this._exception);
                this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
            }
        } else if (this._instance.traceLevels().network >= 1) {
            s = new StringBuffer("closed ");
            s.append(this._endpoint.protocol());
            s.append(" connection\n");
            s.append(this.toString());
            if (!(this._exception instanceof CloseConnectionException || this._exception instanceof ConnectionManuallyClosedException || this._exception instanceof ConnectionTimeoutException || this._exception instanceof CommunicatorDestroyedException || this._exception instanceof ObjectAdapterDeactivatedException)) {
                s.append("\n");
                s.append(this._exception);
            }
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
        }
        if (close) {
            try {
                this._transceiver.close();
            }
            catch (LocalException ex) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter pw = new PrintWriter(stringWriter);
                ex.printStackTrace(pw);
                pw.flush();
                String s2 = "unexpected connection exception:\n " + this._desc + "\n" + stringWriter.toString();
                this._instance.initializationData().logger.error(s2);
            }
        }
        if (this._startCallback != null) {
            if (this._instance.queueRequests()) {
                this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ConnectionI.this._startCallback.connectionStartFailed(ConnectionI.this, ConnectionI.this._exception);
                        return null;
                    }
                });
            } else {
                this._startCallback.connectionStartFailed(this, this._exception);
            }
            this._startCallback = null;
        }
        if (!this._sendStreams.isEmpty()) {
            if (!this._writeStream.isEmpty()) {
                OutgoingMessage message = this._sendStreams.getFirst();
                this._writeStream.swap(message.stream);
            }
            for (OutgoingMessage outgoingMessage : this._sendStreams) {
                outgoingMessage.completed(this._exception);
                if (outgoingMessage.requestId <= 0) continue;
                this._asyncRequests.remove(outgoingMessage.requestId);
            }
            this._sendStreams.clear();
        }
        for (OutgoingAsyncBase outgoingAsyncBase : this._asyncRequests.values()) {
            if (!outgoingAsyncBase.completed(this._exception)) continue;
            outgoingAsyncBase.invokeCompleted();
        }
        this._asyncRequests.clear();
        this._writeStream.clear();
        this._writeStream.getBuffer().clear();
        this._readStream.clear();
        this._readStream.getBuffer().clear();
        if (this._closeCallback != null) {
            try {
                this._closeCallback.closed(this);
            }
            catch (Exception ex) {
                this._logger.error("connection callback exception:\n" + ex + '\n' + this._desc);
            }
            this._closeCallback = null;
        }
        this._heartbeatCallback = null;
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            this.setState(7);
            if (this._dispatchCount == 0) {
                this.reap();
            }
        }
    }

    @Override
    public String toString() {
        return this._toString();
    }

    @Override
    public SelectableChannel fd() {
        return this._transceiver.fd();
    }

    @Override
    public void setReadyCallback(ReadyCallback callback) {
        this._transceiver.setReadyCallback(callback);
    }

    public synchronized void timedOut() {
        if (this._state <= 1) {
            this.setState(6, new ConnectTimeoutException());
        } else if (this._state < 4) {
            this.setState(6, new TimeoutException());
        } else if (this._state < 6) {
            this.setState(6, new CloseTimeoutException());
        }
    }

    @Override
    public String type() {
        return this._type;
    }

    @Override
    public int timeout() {
        return this._endpoint.timeout();
    }

    @Override
    public synchronized ConnectionInfo getInfo() {
        if (this._state >= 6) {
            throw (LocalException)this._exception.fillInStackTrace();
        }
        return this.initConnectionInfo();
    }

    @Override
    public synchronized void setBufferSize(int rcvSize, int sndSize) {
        if (this._state >= 6) {
            throw (LocalException)this._exception.fillInStackTrace();
        }
        this._transceiver.setBufferSize(rcvSize, sndSize);
        this._info = null;
    }

    @Override
    public String _toString() {
        return this._desc;
    }

    public synchronized void exception(LocalException ex) {
        this.setState(6, ex);
    }

    public ConnectionI(Communicator communicator, Instance instance, ACMMonitor monitor, Transceiver transceiver, Connector connector, EndpointI endpoint, ObjectAdapterI adapter) {
        this._communicator = communicator;
        this._instance = instance;
        this._monitor = monitor;
        this._transceiver = transceiver;
        this._desc = transceiver.toString();
        this._type = transceiver.protocol();
        this._connector = connector;
        this._endpoint = endpoint;
        this._adapter = adapter;
        InitializationData initData = instance.initializationData();
        this._dispatcher = initData.dispatcher != null;
        this._logger = initData.logger;
        this._traceLevels = instance.traceLevels();
        this._timer = instance.timer();
        this._writeTimeout = new TimeoutCallback();
        this._writeTimeoutFuture = null;
        this._readTimeout = new TimeoutCallback();
        this._readTimeoutFuture = null;
        this._warn = initData.properties.getPropertyAsInt("Ice.Warn.Connections") > 0;
        this._warnUdp = instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Datagrams") > 0;
        this._cacheBuffers = instance.cacheMessageBuffers();
        this._acmLastActivity = this._monitor != null && this._monitor.getACM().timeout > 0 ? Time.currentMonotonicTimeMillis() : -1L;
        this._nextRequestId = 1;
        this._messageSizeMax = adapter != null ? adapter.messageSizeMax() : instance.messageSizeMax();
        this._batchRequestQueue = new BatchRequestQueue(instance, this._endpoint.datagram());
        this._readStream = new InputStream(instance, Protocol.currentProtocolEncoding);
        this._readHeader = false;
        this._readStreamPos = -1;
        this._writeStream = new OutputStream(instance, Protocol.currentProtocolEncoding);
        this._writeStreamPos = -1;
        this._dispatchCount = 0;
        this._state = 0;
        int compressionLevel = initData.properties.getPropertyAsIntWithDefault("Ice.Compression.Level", 1);
        if (compressionLevel < 1) {
            compressionLevel = 1;
        } else if (compressionLevel > 9) {
            compressionLevel = 9;
        }
        this._compressionLevel = compressionLevel;
        this._servantManager = adapter != null ? adapter.getServantManager() : null;
        try {
            this._threadPool = adapter != null ? adapter.getThreadPool() : this._instance.clientThreadPool();
            this._threadPool.initialize(this);
        }
        catch (LocalException ex) {
            throw ex;
        }
        catch (java.lang.Exception ex) {
            throw new SyscallException(ex);
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._startCallback == null);
            Assert.FinalizerAssert(this._state == 7);
            Assert.FinalizerAssert(this._dispatchCount == 0);
            Assert.FinalizerAssert(this._sendStreams.isEmpty());
            Assert.FinalizerAssert(this._asyncRequests.isEmpty());
        }
        catch (java.lang.Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private void setState(int state, LocalException ex) {
        assert (state >= 4);
        if (this._state == state) {
            return;
        }
        if (this._exception == null) {
            assert (this._state != 6);
            this._exception = ex;
            if (!(!this._warn || !this._validated || this._exception instanceof CloseConnectionException || this._exception instanceof ConnectionManuallyClosedException || this._exception instanceof ConnectionTimeoutException || this._exception instanceof CommunicatorDestroyedException || this._exception instanceof ObjectAdapterDeactivatedException || this._exception instanceof ConnectionLostException && this._state >= 4)) {
                this.warning("connection exception", this._exception);
            }
        }
        this.setState(state);
    }

    private void setState(int state) {
        if (this._endpoint.datagram() && state == 4) {
            state = 6;
        }
        if (this._state <= 1 && state == 4) {
            state = 6;
        }
        if (this._state == state) {
            return;
        }
        try {
            switch (state) {
                case 0: {
                    assert (false);
                    break;
                }
                case 1: {
                    if (this._state == 0) break;
                    assert (this._state == 6);
                    return;
                }
                case 2: {
                    if (this._state != 3 && this._state != 1) {
                        return;
                    }
                    this._threadPool.register(this, 1);
                    break;
                }
                case 3: {
                    if (this._state != 2 && this._state != 1) {
                        return;
                    }
                    if (this._state != 2) break;
                    this._threadPool.unregister(this, 1);
                    break;
                }
                case 4: 
                case 5: {
                    if (this._state < 5) break;
                    return;
                }
                case 6: {
                    if (this._state == 7) {
                        return;
                    }
                    this._batchRequestQueue.destroy(this._exception);
                    if (!this._threadPool.finish(this, false)) break;
                    this._transceiver.close();
                    break;
                }
                case 7: {
                    assert (this._state == 6);
                    this._communicator = null;
                }
            }
        }
        catch (LocalException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            String s = "unexpected connection exception:\n " + this._desc + "\n" + sw.toString();
            this._instance.initializationData().logger.error(s);
        }
        if (this._monitor != null) {
            if (state == 2) {
                if (this._acmLastActivity > 0L) {
                    this._acmLastActivity = Time.currentMonotonicTimeMillis();
                }
                this._monitor.add(this);
            } else if (this._state == 2) {
                this._monitor.remove(this);
            }
        }
        if (this._instance.initializationData().observer != null) {
            ConnectionState newState;
            ConnectionState oldState = this.toConnectionState(this._state);
            if (oldState != (newState = this.toConnectionState(state))) {
                this._observer = this._instance.initializationData().observer.getConnectionObserver(this.initConnectionInfo(), this._endpoint, newState, this._observer);
                if (this._observer != null) {
                    this._observer.attach();
                } else {
                    this._writeStreamPos = -1;
                    this._readStreamPos = -1;
                }
            }
            if (!(this._observer == null || state != 6 || this._exception == null || this._exception instanceof CloseConnectionException || this._exception instanceof ConnectionManuallyClosedException || this._exception instanceof ConnectionTimeoutException || this._exception instanceof CommunicatorDestroyedException || this._exception instanceof ObjectAdapterDeactivatedException || this._exception instanceof ConnectionLostException && this._state >= 4)) {
                this._observer.failed(this._exception.ice_id());
            }
        }
        this._state = state;
        this.notifyAll();
        if (this._state == 4 && this._dispatchCount == 0) {
            try {
                this.initiateShutdown();
            }
            catch (LocalException ex) {
                this.setState(6, ex);
            }
        }
    }

    private void initiateShutdown() {
        assert (this._state == 4 && this._dispatchCount == 0);
        if (this._shutdownInitiated) {
            return;
        }
        this._shutdownInitiated = true;
        if (!this._endpoint.datagram()) {
            OutputStream os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
            os.writeBlob(Protocol.magic);
            Protocol.currentProtocol.ice_writeMembers(os);
            Protocol.currentProtocolEncoding.ice_writeMembers(os);
            os.writeByte((byte)4);
            os.writeByte((byte)0);
            os.writeInt(14);
            if ((this.sendMessage(new OutgoingMessage(os, false, false)) & 1) > 0) {
                this.setState(5);
                int op = this._transceiver.closing(true, this._exception);
                if (op != 0) {
                    this.scheduleTimeout(op);
                    this._threadPool.register(this, op);
                }
            }
        }
    }

    private void queueShutdown(final boolean notify) {
        this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                ConnectionI connectionI = ConnectionI.this;
                synchronized (connectionI) {
                    try {
                        ConnectionI.this.initiateShutdown();
                    }
                    catch (LocalException ex) {
                        ConnectionI.this.setState(6, ex);
                    }
                    if (notify) {
                        ConnectionI.this.notifyAll();
                    }
                }
                return null;
            }
        });
    }

    private void sendHeartbeatNow() {
        block4: {
            assert (this._state == 2);
            if (!this._endpoint.datagram()) {
                OutputStream os = new OutputStream(this._instance, Protocol.currentProtocolEncoding);
                os.writeBlob(Protocol.magic);
                Protocol.currentProtocol.ice_writeMembers(os);
                Protocol.currentProtocolEncoding.ice_writeMembers(os);
                os.writeByte((byte)3);
                os.writeByte((byte)0);
                os.writeInt(14);
                try {
                    OutgoingMessage message = new OutgoingMessage(os, false, false);
                    this.sendMessage(message);
                }
                catch (LocalException ex) {
                    this.setState(6, ex);
                    if ($assertionsDisabled || this._exception != null) break block4;
                    throw new AssertionError();
                }
            }
        }
    }

    private boolean initialize(int operation) {
        int s = this._transceiver.initialize(this._readStream.getBuffer(), this._writeStream.getBuffer());
        if (s != 0) {
            this.scheduleTimeout(s);
            this._threadPool.update(this, operation, s);
            return false;
        }
        this._desc = this._transceiver.toString();
        this._initialized = true;
        this.setState(1);
        return true;
    }

    private boolean validate(int operation) {
        if (!this._endpoint.datagram()) {
            if (this._adapter != null) {
                int op;
                if (this._writeStream.isEmpty()) {
                    this._writeStream.writeBlob(Protocol.magic);
                    Protocol.currentProtocol.ice_writeMembers(this._writeStream);
                    Protocol.currentProtocolEncoding.ice_writeMembers(this._writeStream);
                    this._writeStream.writeByte((byte)3);
                    this._writeStream.writeByte((byte)0);
                    this._writeStream.writeInt(14);
                    TraceUtil.traceSend(this._writeStream, this._logger, this._traceLevels);
                    this._writeStream.prepareWrite();
                }
                if (this._observer != null) {
                    this.observerStartWrite(this._writeStream.getBuffer());
                }
                if (this._writeStream.pos() != this._writeStream.size() && (op = this.write(this._writeStream.getBuffer())) != 0) {
                    this.scheduleTimeout(op);
                    this._threadPool.update(this, operation, op);
                    return false;
                }
                if (this._observer != null) {
                    this.observerFinishWrite(this._writeStream.getBuffer());
                }
            } else {
                int op;
                if (this._readStream.isEmpty()) {
                    this._readStream.resize(14);
                    this._readStream.pos(0);
                }
                if (this._observer != null) {
                    this.observerStartRead(this._readStream.getBuffer());
                }
                if (this._readStream.pos() != this._readStream.size() && (op = this.read(this._readStream.getBuffer())) != 0) {
                    this.scheduleTimeout(op);
                    this._threadPool.update(this, operation, op);
                    return false;
                }
                if (this._observer != null) {
                    this.observerFinishRead(this._readStream.getBuffer());
                }
                assert (this._readStream.pos() == 14);
                this._readStream.pos(0);
                byte[] m = this._readStream.readBlob(4);
                if (m[0] != Protocol.magic[0] || m[1] != Protocol.magic[1] || m[2] != Protocol.magic[2] || m[3] != Protocol.magic[3]) {
                    BadMagicException ex = new BadMagicException();
                    ex.badMagic = m;
                    throw ex;
                }
                this._readProtocol.ice_readMembers(this._readStream);
                Protocol.checkSupportedProtocol(this._readProtocol);
                this._readProtocolEncoding.ice_readMembers(this._readStream);
                Protocol.checkSupportedProtocolEncoding(this._readProtocolEncoding);
                byte messageType = this._readStream.readByte();
                if (messageType != 3) {
                    throw new ConnectionNotValidatedException();
                }
                this._readStream.readByte();
                int size = this._readStream.readInt();
                if (size != 14) {
                    throw new IllegalMessageSizeException();
                }
                TraceUtil.traceRecv(this._readStream, this._logger, this._traceLevels);
                this._validated = true;
            }
        }
        this._writeStream.resize(0);
        this._writeStream.pos(0);
        this._readStream.resize(14);
        this._readStream.pos(0);
        this._readHeader = true;
        if (this._instance.traceLevels().network >= 1) {
            StringBuffer s = new StringBuffer();
            if (this._endpoint.datagram()) {
                s.append("starting to ");
                s.append(this._connector != null ? "send" : "receive");
                s.append(" ");
                s.append(this._endpoint.protocol());
                s.append(" messages\n");
                s.append(this._transceiver.toDetailedString());
            } else {
                s.append(this._connector != null ? "established" : "accepted");
                s.append(" ");
                s.append(this._endpoint.protocol());
                s.append(" connection\n");
                s.append(this.toString());
            }
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
        }
        return true;
    }

    private int sendNextMessage(List<OutgoingMessage> callbacks) {
        if (this._sendStreams.isEmpty()) {
            return 0;
        }
        if (this._state == 5 && this._writeStream.pos() == 0) {
            OutgoingMessage message = this._sendStreams.getFirst();
            this._writeStream.swap(message.stream);
            return 0;
        }
        assert (!this._writeStream.isEmpty() && this._writeStream.pos() == this._writeStream.size());
        try {
            while (true) {
                int op;
                OutgoingMessage message = this._sendStreams.getFirst();
                this._writeStream.swap(message.stream);
                if (message.sent()) {
                    callbacks.add(message);
                }
                this._sendStreams.removeFirst();
                if (this._sendStreams.isEmpty()) break;
                if (this._state >= 5) {
                    return 0;
                }
                message = this._sendStreams.getFirst();
                assert (!message.prepared);
                OutputStream stream = message.stream;
                message.stream = this.doCompress(stream, message.compress);
                message.stream.prepareWrite();
                message.prepared = true;
                TraceUtil.traceSend(stream, this._logger, this._traceLevels);
                this._writeStream.swap(message.stream);
                if (this._observer != null) {
                    this.observerStartWrite(this._writeStream.getBuffer());
                }
                if (this._writeStream.pos() != this._writeStream.size() && (op = this.write(this._writeStream.getBuffer())) != 0) {
                    return op;
                }
                if (this._observer == null) continue;
                this.observerFinishWrite(this._writeStream.getBuffer());
            }
            if (this._state == 4 && this._shutdownInitiated) {
                this.setState(5);
                int op = this._transceiver.closing(true, this._exception);
                if (op != 0) {
                    return op;
                }
            }
        }
        catch (LocalException ex) {
            this.setState(6, ex);
        }
        return 0;
    }

    private int sendMessage(OutgoingMessage message) {
        int op;
        assert (this._state < 6);
        if (!this._sendStreams.isEmpty()) {
            message.adopt();
            this._sendStreams.addLast(message);
            return 0;
        }
        assert (!message.prepared);
        OutputStream stream = message.stream;
        message.stream = this.doCompress(stream, message.compress);
        message.stream.prepareWrite();
        message.prepared = true;
        TraceUtil.traceSend(stream, this._logger, this._traceLevels);
        if (this._observer != null) {
            this.observerStartWrite(message.stream.getBuffer());
        }
        if ((op = this.write(message.stream.getBuffer())) == 0) {
            if (this._observer != null) {
                this.observerFinishWrite(message.stream.getBuffer());
            }
            int status = 1;
            if (message.sent()) {
                status |= 2;
            }
            if (this._acmLastActivity > 0L) {
                this._acmLastActivity = Time.currentMonotonicTimeMillis();
            }
            return status;
        }
        message.adopt();
        this._writeStream.swap(message.stream);
        this._sendStreams.addLast(message);
        this.scheduleTimeout(op);
        this._threadPool.register(this, op);
        return 0;
    }

    private OutputStream doCompress(OutputStream uncompressed, boolean compress) {
        Buffer cbuf;
        boolean compressionSupported = false;
        if (compress) {
            compressionSupported = BZip2.supported();
        }
        if (compressionSupported && uncompressed.size() >= 100 && (cbuf = BZip2.compress(uncompressed.getBuffer(), 14, this._compressionLevel)) != null) {
            OutputStream cstream = new OutputStream(uncompressed.instance(), uncompressed.getEncoding(), cbuf, true);
            cstream.pos(9);
            cstream.writeByte((byte)2);
            cstream.pos(10);
            cstream.writeInt(cstream.size());
            uncompressed.pos(9);
            uncompressed.writeByte((byte)2);
            uncompressed.writeInt(cstream.size());
            return cstream;
        }
        uncompressed.pos(9);
        uncompressed.writeByte((byte)(compressionSupported ? 1 : 0));
        uncompressed.pos(10);
        uncompressed.writeInt(uncompressed.size());
        return uncompressed;
    }

    private int parseMessage(MessageInfo info) {
        assert (this._state > 1 && this._state < 6);
        this._readStream.swap(info.stream);
        this._readStream.resize(14);
        this._readStream.pos(0);
        this._readHeader = true;
        assert (info.stream.pos() == info.stream.size());
        this._validated = true;
        try {
            info.stream.pos(8);
            byte messageType = info.stream.readByte();
            info.compress = info.stream.readByte();
            if (info.compress == 2) {
                if (BZip2.supported()) {
                    Buffer ubuf = BZip2.uncompress(info.stream.getBuffer(), 14, this._messageSizeMax);
                    info.stream = new InputStream(info.stream.instance(), info.stream.getEncoding(), ubuf, true);
                } else {
                    FeatureNotSupportedException ex = new FeatureNotSupportedException();
                    ex.unsupportedFeature = "Cannot uncompress compressed message: org.apache.tools.bzip2.CBZip2OutputStream was not found";
                    throw ex;
                }
            }
            info.stream.pos(14);
            switch (messageType) {
                case 4: {
                    TraceUtil.traceRecv(info.stream, this._logger, this._traceLevels);
                    if (this._endpoint.datagram()) {
                        if (this._warn) {
                            this._logger.warning("ignoring close connection message for datagram connection:\n" + this._desc);
                        }
                        break;
                    }
                    this.setState(5, new CloseConnectionException());
                    int op = this._transceiver.closing(false, this._exception);
                    if (op != 0) {
                        return op;
                    }
                    this.setState(6);
                    break;
                }
                case 0: {
                    if (this._state >= 4) {
                        TraceUtil.trace("received request during closing\n(ignored by server, client will retry)", info.stream, this._logger, this._traceLevels);
                        break;
                    }
                    TraceUtil.traceRecv(info.stream, this._logger, this._traceLevels);
                    info.requestId = info.stream.readInt();
                    info.invokeNum = 1;
                    info.servantManager = this._servantManager;
                    info.adapter = this._adapter;
                    ++info.messageDispatchCount;
                    break;
                }
                case 1: {
                    if (this._state >= 4) {
                        TraceUtil.trace("received batch request during closing\n(ignored by server, client will retry)", info.stream, this._logger, this._traceLevels);
                        break;
                    }
                    TraceUtil.traceRecv(info.stream, this._logger, this._traceLevels);
                    info.invokeNum = info.stream.readInt();
                    if (info.invokeNum < 0) {
                        info.invokeNum = 0;
                        throw new UnmarshalOutOfBoundsException();
                    }
                    info.servantManager = this._servantManager;
                    info.adapter = this._adapter;
                    info.messageDispatchCount += info.invokeNum;
                    break;
                }
                case 2: {
                    TraceUtil.traceRecv(info.stream, this._logger, this._traceLevels);
                    info.requestId = info.stream.readInt();
                    OutgoingAsyncBase outAsync = this._asyncRequests.remove(info.requestId);
                    if (outAsync != null && outAsync.completed(info.stream)) {
                        info.outAsync = outAsync;
                        ++info.messageDispatchCount;
                    }
                    this.notifyAll();
                    break;
                }
                case 3: {
                    TraceUtil.traceRecv(info.stream, this._logger, this._traceLevels);
                    if (this._heartbeatCallback != null) {
                        info.heartbeatCallback = this._heartbeatCallback;
                        ++info.messageDispatchCount;
                    }
                    break;
                }
                default: {
                    TraceUtil.trace("received unknown message\n(invalid, closing connection)", info.stream, this._logger, this._traceLevels);
                    throw new UnknownMessageException();
                }
            }
        }
        catch (LocalException ex) {
            if (this._endpoint.datagram()) {
                if (this._warn) {
                    this._logger.warning("datagram connection exception:\n" + ex + '\n' + this._desc);
                }
            }
            this.setState(6, ex);
        }
        return this._state == 3 ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeAll(InputStream stream, int invokeNum, int requestId, byte compress, ServantManager servantManager, ObjectAdapter adapter) {
        Incoming in = null;
        try {
            while (invokeNum > 0) {
                boolean response = !this._endpoint.datagram() && requestId != 0;
                in = this.getIncoming(adapter, response, compress, requestId);
                in.invoke(servantManager, stream);
                --invokeNum;
                this.reclaimIncoming(in);
                in = null;
            }
            stream.clear();
            if (in == null) return;
        }
        catch (LocalException ex) {
            this.invokeException(requestId, ex, invokeNum, false);
            return;
            catch (ServantError ex2) {
                Throwable t = ex2.getCause();
                if (!(t instanceof AssertionError || t instanceof OutOfMemoryError || t instanceof StackOverflowError)) {
                    throw (Error)t;
                }
                if (in == null) return;
                this.reclaimIncoming(in);
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (Error ex3) {
                    UnknownException uex = new UnknownException(ex3);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex3.printStackTrace(pw);
                    pw.flush();
                    uex.unknown = sw.toString();
                    this._logger.error(uex.unknown);
                    this.invokeException(requestId, uex, invokeNum, false);
                    if (!(ex3 instanceof AssertionError || ex3 instanceof OutOfMemoryError || ex3 instanceof StackOverflowError)) {
                        throw ex3;
                    }
                    if (in == null) return;
                    this.reclaimIncoming(in);
                    return;
                }
            }
            finally {
                if (in != null) {
                    this.reclaimIncoming(in);
                }
            }
        }
        this.reclaimIncoming(in);
        return;
    }

    private void scheduleTimeout(int status) {
        block12: {
            int timeout;
            if (this._state < 2) {
                DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
                timeout = defaultsAndOverrides.overrideConnectTimeout ? defaultsAndOverrides.overrideConnectTimeoutValue : this._endpoint.timeout();
            } else if (this._state < 5) {
                if (this._readHeader) {
                    status &= 0xFFFFFFFE;
                }
                timeout = this._endpoint.timeout();
            } else {
                DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
                timeout = defaultsAndOverrides.overrideCloseTimeout ? defaultsAndOverrides.overrideCloseTimeoutValue : this._endpoint.timeout();
            }
            if (timeout < 0) {
                return;
            }
            try {
                if ((status & 1) != 0) {
                    if (this._readTimeoutFuture != null) {
                        this._readTimeoutFuture.cancel(false);
                    }
                    this._readTimeoutFuture = this._timer.schedule(this._readTimeout, (long)timeout, TimeUnit.MILLISECONDS);
                }
                if ((status & 0xC) != 0) {
                    if (this._writeTimeoutFuture != null) {
                        this._writeTimeoutFuture.cancel(false);
                    }
                    this._writeTimeoutFuture = this._timer.schedule(this._writeTimeout, (long)timeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable ex) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError();
            }
        }
    }

    private void unscheduleTimeout(int status) {
        if ((status & 1) != 0 && this._readTimeoutFuture != null) {
            this._readTimeoutFuture.cancel(false);
            this._readTimeoutFuture = null;
        }
        if ((status & 0xC) != 0 && this._writeTimeoutFuture != null) {
            this._writeTimeoutFuture.cancel(false);
            this._writeTimeoutFuture = null;
        }
    }

    private ConnectionInfo initConnectionInfo() {
        if (this._state > 0 && this._info != null) {
            return this._info;
        }
        try {
            this._info = this._transceiver.getInfo();
        }
        catch (LocalException ex) {
            this._info = new ConnectionInfo();
        }
        ConnectionInfo info = this._info;
        while (info != null) {
            info.connectionId = this._endpoint.connectionId();
            info.adapterName = this._adapter != null ? this._adapter.getName() : "";
            info.incoming = this._connector == null;
            info = info.underlying;
        }
        return this._info;
    }

    private ConnectionState toConnectionState(int state) {
        return connectionStateMap[state];
    }

    private void warning(String msg, java.lang.Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = msg + ":\n" + this._desc + "\n" + sw.toString();
        this._logger.warning(s);
    }

    private void observerStartRead(Buffer buf) {
        if (this._readStreamPos >= 0) {
            assert (!buf.empty());
            this._observer.receivedBytes(buf.b.position() - this._readStreamPos);
        }
        this._readStreamPos = buf.empty() ? -1 : buf.b.position();
    }

    private void observerFinishRead(Buffer buf) {
        if (this._readStreamPos == -1) {
            return;
        }
        assert (buf.b.position() >= this._readStreamPos);
        this._observer.receivedBytes(buf.b.position() - this._readStreamPos);
        this._readStreamPos = -1;
    }

    private void observerStartWrite(Buffer buf) {
        if (this._writeStreamPos >= 0) {
            assert (!buf.empty());
            this._observer.sentBytes(buf.b.position() - this._writeStreamPos);
        }
        this._writeStreamPos = buf.empty() ? -1 : buf.b.position();
    }

    private void observerFinishWrite(Buffer buf) {
        if (this._writeStreamPos == -1) {
            return;
        }
        if (buf.b.position() > this._writeStreamPos) {
            this._observer.sentBytes(buf.b.position() - this._writeStreamPos);
        }
        this._writeStreamPos = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Incoming getIncoming(ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        Incoming in = null;
        if (this._cacheBuffers > 0) {
            Object object = this._incomingCacheMutex;
            synchronized (object) {
                if (this._incomingCache == null) {
                    in = new Incoming(this._instance, this, this, adapter, response, compress, requestId);
                } else {
                    in = this._incomingCache;
                    this._incomingCache = this._incomingCache.next;
                    in.reset(this._instance, this, this, adapter, response, compress, requestId);
                    in.next = null;
                }
            }
        } else {
            in = new Incoming(this._instance, this, this, adapter, response, compress, requestId);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reclaimIncoming(Incoming in) {
        if (this._cacheBuffers > 0) {
            Object object = this._incomingCacheMutex;
            synchronized (object) {
                in.next = this._incomingCache;
                this._incomingCache = in;
                this._incomingCache.reclaim();
            }
        }
    }

    private void reap() {
        if (this._monitor != null) {
            this._monitor.reap(this);
        }
        if (this._observer != null) {
            this._observer.detach();
        }
    }

    private int read(Buffer buf) {
        int start = buf.b.position();
        int op = this._transceiver.read(buf);
        if (this._instance.traceLevels().network >= 3 && buf.b.position() != start) {
            StringBuffer s = new StringBuffer("received ");
            if (this._endpoint.datagram()) {
                s.append(buf.b.limit());
            } else {
                s.append(buf.b.position() - start);
                s.append(" of ");
                s.append(buf.b.limit() - start);
            }
            s.append(" bytes via ");
            s.append(this._endpoint.protocol());
            s.append("\n");
            s.append(this.toString());
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
        }
        return op;
    }

    private int write(Buffer buf) {
        int start = buf.b.position();
        int op = this._transceiver.write(buf);
        if (this._instance.traceLevels().network >= 3 && buf.b.position() != start) {
            StringBuffer s = new StringBuffer("sent ");
            s.append(buf.b.position() - start);
            if (!this._endpoint.datagram()) {
                s.append(" of ");
                s.append(buf.b.limit() - start);
            }
            s.append(" bytes via ");
            s.append(this._endpoint.protocol());
            s.append("\n");
            s.append(this.toString());
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
        }
        return op;
    }

    private static class OutgoingMessage {
        public OutputStream stream;
        public OutgoingAsyncBase outAsync;
        public boolean compress;
        public int requestId;
        boolean adopt;
        boolean prepared;

        OutgoingMessage(OutputStream stream, boolean compress, boolean adopt) {
            this.stream = stream;
            this.compress = compress;
            this.adopt = adopt;
            this.requestId = 0;
        }

        OutgoingMessage(OutgoingAsyncBase out, OutputStream stream, boolean compress, int requestId) {
            this.stream = stream;
            this.compress = compress;
            this.outAsync = out;
            this.requestId = requestId;
        }

        public void canceled() {
            assert (this.outAsync != null);
            this.outAsync = null;
        }

        public void adopt() {
            if (this.adopt) {
                OutputStream stream = new OutputStream(this.stream.instance(), Protocol.currentProtocolEncoding);
                stream.swap(this.stream);
                this.stream = stream;
                this.adopt = false;
            }
        }

        public boolean sent() {
            if (this.outAsync != null) {
                return this.outAsync.sent();
            }
            return false;
        }

        public void completed(LocalException ex) {
            if (this.outAsync != null && this.outAsync.completed(ex)) {
                this.outAsync.invokeCompleted();
            }
        }
    }

    private static class MessageInfo {
        InputStream stream;
        int invokeNum;
        int requestId;
        byte compress;
        ServantManager servantManager;
        ObjectAdapter adapter;
        OutgoingAsyncBase outAsync;
        HeartbeatCallback heartbeatCallback;
        int messageDispatchCount;

        MessageInfo(InputStream stream) {
            this.stream = stream;
        }
    }

    static class HeartbeatAsync
    extends OutgoingAsyncBase {
        private ConnectionI _connection;

        public static HeartbeatAsync check(AsyncResult r, Connection con, String operation) {
            HeartbeatAsync.check(r, operation);
            if (!(r instanceof HeartbeatAsync)) {
                throw new IllegalArgumentException("Incorrect AsyncResult object for end_" + operation + " method");
            }
            if (r.getConnection() != con) {
                throw new IllegalArgumentException("Connection for call to end_" + operation + " does not match connection that was used to call corresponding begin_" + operation + " method");
            }
            return (HeartbeatAsync)r;
        }

        public HeartbeatAsync(ConnectionI con, Communicator communicator, Instance instance, String operation, CallbackBase callback) {
            super(communicator, instance, operation, callback);
            this._connection = con;
        }

        @Override
        public Connection getConnection() {
            return this._connection;
        }

        public void invoke() {
            block6: {
                try {
                    this._os.writeBlob(Protocol.magic);
                    ProtocolVersion.ice_write(this._os, Protocol.currentProtocol);
                    EncodingVersion.ice_write(this._os, Protocol.currentProtocolEncoding);
                    this._os.writeByte((byte)3);
                    this._os.writeByte((byte)0);
                    this._os.writeInt(14);
                    int status = this._instance.queueRequests() ? this._instance.getQueueExecutor().execute(new Callable<Integer>(){

                        @Override
                        public Integer call() throws RetryException {
                            return HeartbeatAsync.this._connection.sendAsyncRequest(HeartbeatAsync.this, false, false, 0);
                        }
                    }).intValue() : this._connection.sendAsyncRequest(this, false, false, 0);
                    if ((status & 1) > 0) {
                        this._sentSynchronously = true;
                        if ((status & 2) > 0) {
                            this.invokeSent();
                        }
                    }
                }
                catch (RetryException ex) {
                    if (this.completed(ex.get())) {
                        this.invokeCompletedAsync();
                    }
                }
                catch (Exception ex) {
                    if (!this.completed(ex)) break block6;
                    this.invokeCompletedAsync();
                }
            }
        }
    }

    private class TimeoutCallback
    implements Runnable {
        private TimeoutCallback() {
        }

        @Override
        public void run() {
            ConnectionI.this.timedOut();
        }
    }

    public static interface StartCallback {
        public void connectionStartCompleted(ConnectionI var1);

        public void connectionStartFailed(ConnectionI var1, LocalException var2);
    }
}

