/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.preferences;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.model.Filter;
import net.sourceforge.glsof.common.preferences.AbstractCommandDialog;
import net.sourceforge.glsof.common.preferences.LsofParameterType;
import net.sourceforge.glsof.common.utils.GBC;

class PathCommandDialog
extends AbstractCommandDialog {
    protected JTextField _directory;

    public PathCommandDialog(LsofParameterType type) {
        super(type);
    }

    @Override
    protected void createDialogArea(JPanel parent) {
        parent.add((Component)this.createLabel(), new GBC().gridx(0).gridy(0).anchor(17).insets(new Insets(5, 5, 5, 5)).get());
        this._directory = new JTextField(20);
        parent.add((Component)this._directory, new GBC().gridx(1).gridy(0).weightx(1.0).anchor(17).fill(2).gridwidth(3).insets(new Insets(5, 5, 5, 5)).get());
        final JButton button = new JButton(Messages.NLS("Browse"));
        parent.add((Component)button, new GBC().gridx(4).gridy(0).anchor(21).insets(new Insets(5, 5, 5, 5)).get());
        final JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == button && fc.showOpenDialog(PathCommandDialog.this) == 0) {
                    PathCommandDialog.this._directory.setText(fc.getSelectedFile().getAbsolutePath());
                }
            }
        });
    }

    @Override
    protected boolean inputIsCorrect() {
        return this.inputIsCorrect(this._directory.getText(), Messages.NLS("You_cannot_entry_an_empty_directory_value"));
    }

    @Override
    public void copyValuesInTheMask(Filter filter) {
        this._directory.setText(filter.getValues().get(0));
    }

    @Override
    protected List<String> getModelFilterValuesFromTheMask() {
        return Arrays.asList(this._directory.getText().trim());
    }
}

