/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.Cast;
import org.gradle.vcs.VcsMapping;
import org.gradle.vcs.VcsMappings;
import org.gradle.vcs.internal.VcsMappingsStore;

public class DefaultVcsMappings
implements VcsMappings {
    private final VcsMappingsStore vcsMappings;
    private final Gradle gradle;

    public DefaultVcsMappings(VcsMappingsStore vcsMappings, Gradle gradle) {
        this.vcsMappings = vcsMappings;
        this.gradle = gradle;
    }

    public VcsMappings all(Action<? super VcsMapping> rule) {
        this.vcsMappings.addRule(rule, this.gradle);
        return this;
    }

    public VcsMappings withModule(String module, Action<? super VcsMapping> rule) {
        this.vcsMappings.addRule((Action)new GavFilteredRule(module, rule), this.gradle);
        return this;
    }

    private static class GavFilteredRule
    implements Action<VcsMapping> {
        private final String groupName;
        private final Action<? super VcsMapping> delegate;

        private GavFilteredRule(String groupName, Action<? super VcsMapping> delegate) {
            this.groupName = groupName;
            this.delegate = delegate;
        }

        public void execute(VcsMapping mapping) {
            ModuleComponentSelector moduleComponentSelector;
            if (mapping.getRequested() instanceof ModuleComponentSelector && this.groupName.equals((moduleComponentSelector = (ModuleComponentSelector)Cast.uncheckedCast((Object)mapping.getRequested())).getGroup() + ":" + moduleComponentSelector.getModule())) {
                this.delegate.execute((Object)mapping);
            }
        }
    }
}

