/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.uisupport;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.lib.profiler.ui.UIUtils;

public class HTMLLabel
extends JEditorPane
implements HyperlinkListener {
    private int halign = 10;
    private String txt;

    public HTMLLabel() {
        this((String)null);
    }

    public HTMLLabel(String text) {
        this.setEditorKit(new HTMLEditorKit());
        this.setEditable(false);
        this.setOpaque(false);
        this.setNavigationFilter(new NavigationFilter(){

            public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                super.moveDot(fb, 0, bias);
            }

            public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
                super.setDot(fb, 0, bias);
            }

            public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
                return 0;
            }
        });
        this.setFont(UIManager.getFont("Label.font"));
        this.addHyperlinkListener(this);
        if (text != null) {
            this.setText(text);
        }
    }

    public void setOpaque(boolean o) {
        super.setOpaque(o);
        if (UIUtils.isNimbusLookAndFeel() && !o) {
            this.setBackground(new Color(0, 0, 0, 0));
        }
        if (this.txt != null) {
            this.setText(this.txt);
        }
    }

    public void setText(String value) {
        this.txt = value;
        Font font = this.getFont();
        Color fgColor = this.getForeground();
        Color bgColor = this.getBackground();
        value = value.replaceAll("\\n\\r|\\r\\n|\\n|\\r", "<br>");
        value = value.replace("<code>", "<code style=\"font-size: " + font.getSize() + "pt;\">");
        String fgText = "rgb(" + fgColor.getRed() + "," + fgColor.getGreen() + "," + fgColor.getBlue() + ")";
        String bgText = this.isOpaque() ? "rgb(" + bgColor.getRed() + "," + bgColor.getGreen() + "," + bgColor.getBlue() + ")" : null;
        String alignText = null;
        switch (this.halign) {
            case 0: {
                alignText = "center";
                break;
            }
            case 4: 
            case 11: {
                alignText = "right";
            }
        }
        String bodyFlags = "text=\"" + fgText + "\"";
        if (bgText != null) {
            bodyFlags = bodyFlags + " bgcolor=\"" + bgText + "\"";
        }
        if (alignText != null) {
            bodyFlags = bodyFlags + " align=\"" + alignText + "\"";
        }
        super.setText("<html><body " + bodyFlags + " style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + value + "</body></html>");
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.txt != null) {
            this.setText(this.txt);
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.txt != null) {
            this.setText(this.txt);
        }
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment == this.halign) {
            return;
        }
        this.halign = alignment;
        if (this.txt != null) {
            this.setText(this.txt);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.showURL(e.getURL());
        } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void showURL(URL url) {
    }
}

