/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.WinClassicEditorTabCellRenderer;

public final class WinClassicEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final Rectangle scratch5 = new Rectangle();
    private static Map<Integer, String[]> buttonIconPaths;
    private static boolean isGenericUI;

    public WinClassicEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinClassicEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    public Rectangle getTabRect(int n, Rectangle rectangle) {
        Rectangle rectangle2 = super.getTabRect(n, rectangle);
        rectangle2.y = 0;
        rectangle2.height = this.displayer.getHeight();
        return rectangle2;
    }

    @Override
    public void install() {
        super.install();
        if (!isGenericUI) {
            this.displayer.setBackground(UIManager.getColor("tab_unsel_fill"));
            this.displayer.setOpaque(true);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 28;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + (isGenericUI ? 5 : 6);
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    private void genericPaintAfterTabs(Graphics graphics) {
        graphics.setColor(UIManager.getColor("controlShadow"));
        Insets insets = this.displayer.getInsets();
        Rectangle rectangle = new Rectangle();
        this.getTabsVisibleArea(rectangle);
        rectangle.width = this.displayer.getWidth();
        boolean bl = false;
        int n = this.getLastVisibleTab();
        if (n > -1) {
            this.getTabRect(n, scratch5);
            graphics.drawLine(WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width, this.displayer.getHeight() - 1, this.displayer.getWidth() - (insets.left + insets.right) - 4, this.displayer.getHeight() - 1);
            graphics.drawLine(0, this.displayer.getHeight() - 2, 2, this.displayer.getHeight() - 2);
            if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
                boolean bl2 = n == this.displayer.getSelectionModel().getSelectedIndex();
                int n2 = WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width;
                graphics.setColor(bl2 ? UIManager.getColor("controlShadow") : ColorUtil.adjustTowards(graphics.getColor(), 20, UIManager.getColor("control")));
                graphics.drawLine(n2, WinClassicEditorTabDisplayerUI.scratch5.y + 5, n2, WinClassicEditorTabDisplayerUI.scratch5.y + WinClassicEditorTabDisplayerUI.scratch5.height - 2);
                graphics.setColor(ColorUtil.adjustTowards(graphics.getColor(), 20, UIManager.getColor("control")));
                graphics.drawLine(n2 + 1, WinClassicEditorTabDisplayerUI.scratch5.y + 6, n2 + 1, WinClassicEditorTabDisplayerUI.scratch5.y + WinClassicEditorTabDisplayerUI.scratch5.height - 2);
            }
            if ((this.tabState.getState(this.getFirstVisibleTab()) & 2) != 0 && this.getFirstVisibleTab() != this.displayer.getSelectionModel().getSelectedIndex()) {
                GradientPaint gradientPaint = ColorUtil.getGradientPaint(0.0f, this.displayer.getHeight() / 2, UIManager.getColor("control"), 0.0f, this.displayer.getHeight(), UIManager.getColor("controlShadow"));
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.drawLine(0, this.displayer.getHeight() / 2, 0, this.displayer.getHeight());
            } else {
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(0, this.displayer.getHeight(), 0, this.displayer.getHeight() - 2);
            }
            if ((this.tabState.getState(this.getLastVisibleTab()) & 1) != 0 && this.getLastVisibleTab() != this.displayer.getSelectionModel().getSelectedIndex()) {
                GradientPaint gradientPaint = ColorUtil.getGradientPaint(0.0f, this.displayer.getHeight() / 2, UIManager.getColor("control"), 0.0f, this.displayer.getHeight(), UIManager.getColor("controlShadow"));
                ((Graphics2D)graphics).setPaint(gradientPaint);
                this.getTabRect(this.getLastVisibleTab(), scratch5);
                graphics.drawLine(WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width, this.displayer.getHeight() / 2, WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width, this.displayer.getHeight());
            }
        } else {
            graphics.drawLine(rectangle.x, this.displayer.getHeight() - insets.bottom, rectangle.x + rectangle.width - 4, this.displayer.getHeight() - insets.bottom);
        }
    }

    @Override
    protected void paintAfterTabs(Graphics graphics) {
        if (isGenericUI) {
            this.genericPaintAfterTabs(graphics);
            return;
        }
        Rectangle rectangle = new Rectangle();
        this.getTabsVisibleArea(rectangle);
        rectangle.width = this.displayer.getWidth();
        graphics.setColor(this.displayer.isActive() ? this.defaultRenderer.getSelectedActivatedBackground() : this.defaultRenderer.getSelectedBackground());
        Insets insets = this.getTabAreaInsets();
        ++insets.bottom;
        graphics.fillRect(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, this.displayer.getHeight() - (rectangle.y + rectangle.height));
        graphics.setColor(UIManager.getColor("controlLtHighlight"));
        int n = 0;
        int n2 = this.selectionModel.getSelectedIndex();
        if (n2 != -1) {
            this.getTabRect(n2, scratch5);
            if (WinClassicEditorTabDisplayerUI.scratch5.width != 0) {
                if (rectangle.x < WinClassicEditorTabDisplayerUI.scratch5.x) {
                    graphics.drawLine(rectangle.x, this.displayer.getHeight() - insets.bottom, WinClassicEditorTabDisplayerUI.scratch5.x - 1, this.displayer.getHeight() - insets.bottom);
                }
                if (WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width < rectangle.x + rectangle.width) {
                    n = WinClassicEditorTabDisplayerUI.scratch5.x + WinClassicEditorTabDisplayerUI.scratch5.width;
                    if (!this.scroll().isLastTabClipped()) {
                        --n;
                    }
                    graphics.drawLine(n, this.displayer.getHeight() - insets.bottom, rectangle.x + rectangle.width, this.displayer.getHeight() - insets.bottom);
                }
            }
            return;
        }
        graphics.drawLine(rectangle.x, this.displayer.getHeight() - insets.bottom, rectangle.x + rectangle.width, this.displayer.getHeight() - insets.bottom);
    }

    @Override
    protected TabCellRenderer createDefaultRenderer() {
        return new WinClassicEditorTabCellRenderer();
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/win_scrollleft_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/win_scrollleft_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/win_scrollleft_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/win_scrollleft_pressed.png";
            buttonIconPaths.put(9, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/win_scrollright_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/win_scrollright_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/win_scrollright_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/win_scrollright_pressed.png";
            buttonIconPaths.put(10, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/win_popup_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/win_popup_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/win_popup_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/win_popup_pressed.png";
            buttonIconPaths.put(8, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/win_maximize_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/win_maximize_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/win_maximize_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/win_maximize_pressed.png";
            buttonIconPaths.put(3, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/win_restore_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/win_restore_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/win_restore_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/win_restore_pressed.png";
            buttonIconPaths.put(4, stringArray);
        }
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        WinClassicEditorTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    @Override
    protected Rectangle getControlButtonsRectangle(Container container) {
        Component component = this.getControlButtons();
        return new Rectangle(container.getWidth() - component.getWidth() - 4, 4, component.getWidth(), component.getHeight());
    }

    @Override
    public Insets getTabAreaInsets() {
        Insets insets = super.getTabAreaInsets();
        insets.right += 4;
        return insets;
    }

    static {
        isGenericUI = !"Windows".equals(UIManager.getLookAndFeel().getID());
    }
}

