/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultViewPanel;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.ui.UiUtils;
import org.netbeans.spi.search.provider.SearchComposition;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="search-results", persistenceType=0, iconBase="org/netbeans/modules/search/res/find.gif")
public final class ResultView
extends TopComponent {
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private static final String CARD_NAME_EMPTY = "empty";
    private static final String CARD_NAME_TABS = "tabs";
    private static final String CARD_NAME_SINGLE = "single";
    static final String ID = "search-results";
    private JPopupMenu pop;
    private PopupListener popL;
    private CloseListener closeL;
    private JPanel emptyPanel;
    private JPanel singlePanel;
    private JTabbedPane tabs;
    private WeakReference<ResultViewPanel> tabToReuse;
    private CurrentLookupProvider lookupProvider = new CurrentLookupProvider();
    private final CardLayout contentCards;
    private Map<SearchTask, ResultViewPanel> searchToViewMap = new HashMap<SearchTask, ResultViewPanel>();
    private Map<ResultViewPanel, SearchTask> viewToSearchMap = new HashMap<ResultViewPanel, SearchTask>();
    private Map<ReplaceTask, SearchTask> replaceToSearchMap = new HashMap<ReplaceTask, SearchTask>();
    private Map<SearchTask, ReplaceTask> searchToReplaceMap = new HashMap<SearchTask, ReplaceTask>();

    public static synchronized ResultView getInstance() {
        ResultView resultView = (ResultView)WindowManager.getDefault().findTopComponent(ID);
        if (resultView == null) {
            resultView = new ResultView();
        }
        return resultView;
    }

    public ResultView() {
        this.contentCards = new CardLayout();
        this.setLayout(this.contentCards);
        this.setName("Search Results");
        this.setDisplayName(NbBundle.getMessage(ResultView.class, (String)"TITLE_SEARCH_RESULTS"));
        this.initAccessibility();
        this.pop = new JPopupMenu();
        this.pop.add(new Close());
        this.pop.add(new CloseAll());
        this.pop.add(new CloseAllButCurrent());
        this.popL = new PopupListener();
        this.closeL = new CloseListener();
        this.emptyPanel = new JPanel();
        this.singlePanel = new JPanel();
        this.singlePanel.setLayout(new BoxLayout(this.singlePanel, 3));
        this.emptyPanel.setOpaque(true);
        this.tabs = TabbedPaneFactory.createCloseButtonTabbedPane();
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ResultView.this.updateLookup();
            }
        });
        this.tabs.setMinimumSize(new Dimension(0, 0));
        this.tabs.addMouseListener((MouseListener)((Object)this.popL));
        this.tabs.addPropertyChangeListener(this.closeL);
        this.add(this.emptyPanel, CARD_NAME_EMPTY);
        this.add(this.tabs, CARD_NAME_TABS);
        this.add(this.singlePanel, CARD_NAME_SINGLE);
        if (isMacLaf) {
            this.emptyPanel.setBackground(macBackground);
            this.tabs.setBackground(macBackground);
            this.tabs.setOpaque(true);
            this.setBackground(macBackground);
            this.setOpaque(true);
        } else {
            this.emptyPanel.setBackground(UIManager.getColor("Tree.background"));
        }
        this.contentCards.show((Container)((Object)this), CARD_NAME_EMPTY);
        this.associateLookup(Lookups.proxy((Lookup.Provider)this.lookupProvider));
    }

    private void initAccessibility() {
        ResourceBundle resourceBundle = NbBundle.getBundle(ResultView.class);
        this.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ResultViewTopComponent"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ResultViewTopComponent"));
    }

    void closeResults() {
        this.close();
    }

    protected void componentOpened() {
        assert (EventQueue.isDispatchThread());
        Manager.getInstance().searchWindowOpened();
        ResultViewPanel resultViewPanel = this.getCurrentResultViewPanel();
        if (resultViewPanel != null) {
            resultViewPanel.componentOpened();
        }
        this.setToolTipText(NbBundle.getMessage(ResultView.class, (String)"TOOLTIP_SEARCH_RESULTS"));
    }

    public void requestFocus() {
        ResultViewPanel resultViewPanel = this.getCurrentResultViewPanel();
        if (resultViewPanel != null) {
            resultViewPanel.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        ResultViewPanel resultViewPanel = this.getCurrentResultViewPanel();
        if (resultViewPanel != null) {
            return resultViewPanel.requestFocusInWindow();
        }
        return false;
    }

    private ResultViewPanel getCurrentResultViewPanel() {
        if (this.singlePanel.getComponents().length == 1) {
            Component component = this.singlePanel.getComponents()[0];
            if (component instanceof ResultViewPanel) {
                return (ResultViewPanel)component;
            }
            return null;
        }
        if (this.tabs.getTabCount() > 0) {
            Component component = this.tabs.getSelectedComponent();
            if (component instanceof ResultViewPanel) {
                return (ResultViewPanel)component;
            }
            return null;
        }
        return null;
    }

    private String getTabTitle(Component component) {
        return NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_RESULTS_FOR_X", (Object)String.valueOf(component.getName()));
    }

    private void updateTabTitle(JPanel jPanel) {
        if (this.getComponentCount() != 0 && this.tabs.getTabCount() > 0) {
            int n = this.tabs.indexOfComponent(jPanel);
            this.tabs.setTitleAt(n, this.getTabTitle(jPanel));
            this.tabs.setToolTipTextAt(n, jPanel.getToolTipText());
        }
    }

    private void removePanel(ResultViewPanel resultViewPanel) {
        Object object;
        Object object2;
        if (this.tabs.getTabCount() > 0) {
            if (resultViewPanel == null) {
                resultViewPanel = (ResultViewPanel)this.tabs.getSelectedComponent();
            }
            if (resultViewPanel.isSearchInProgress()) {
                resultViewPanel.getSearchComposition().terminate();
            }
            this.tabs.remove(resultViewPanel);
            resultViewPanel.getSearchComposition().getSearchResultsDisplayer().closed();
            if (this.tabs.getTabCount() == 0) {
                this.contentCards.show((Container)((Object)this), CARD_NAME_EMPTY);
                this.updateLookup();
            } else if (this.tabs.getTabCount() == 1) {
                object2 = this.tabs.getComponentAt(0);
                this.singlePanel.add((Component)object2);
                this.contentCards.show((Container)((Object)this), CARD_NAME_SINGLE);
                this.updateLookup();
            }
            this.repaint();
        } else if (this.singlePanel.getComponents().length == 1) {
            object2 = this.singlePanel.getComponents()[0];
            object = (ResultViewPanel)object2;
            if (((ResultViewPanel)object).isSearchInProgress()) {
                Manager.getInstance().stopSearching(this.viewToSearchMap.get(object));
            }
            this.singlePanel.remove((Component)object2);
            this.contentCards.show((Container)((Object)this), CARD_NAME_EMPTY);
            ((ResultViewPanel)object).getSearchComposition().getSearchResultsDisplayer().closed();
            this.repaint();
        } else {
            this.close();
        }
        object2 = this.viewToSearchMap.remove(resultViewPanel);
        this.searchToViewMap.remove(object2);
        object = this.searchToReplaceMap.remove(object2);
        this.replaceToSearchMap.remove(object);
        this.validate();
        this.updateTooltip();
    }

    protected void componentClosed() {
        assert (EventQueue.isDispatchThread());
        Manager.getInstance().searchWindowClosed();
        this.closeAll(false);
    }

    void notifySearchPending(SearchTask searchTask, int n) {
        assert (EventQueue.isDispatchThread());
        ResultViewPanel resultViewPanel = this.searchToViewMap.get(searchTask);
        if (resultViewPanel != null) {
            String string = null;
            switch (n) {
                case 8: {
                    string = "TEXT_FINISHING_REPLACE";
                    break;
                }
                case 1: {
                    string = "TEXT_FINISHING_PREV_SEARCH";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            resultViewPanel.showInfo(NbBundle.getMessage(ResultView.class, (String)string));
            resultViewPanel.setBtnStopEnabled(true);
        }
    }

    void searchTaskStateChanged(SearchTask searchTask, int n) {
        assert (EventQueue.isDispatchThread());
        ResultViewPanel resultViewPanel = this.searchToViewMap.get(searchTask);
        if (resultViewPanel == null) {
            return;
        }
        switch (n) {
            case 1: {
                this.updateTabTitle(resultViewPanel);
                resultViewPanel.searchStarted();
                break;
            }
            case 2: {
                resultViewPanel.searchFinished();
                break;
            }
            case 3: {
                resultViewPanel.searchInterrupted();
                break;
            }
            case 4: {
                resultViewPanel.searchCancelled();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    void showAllDetailsFinished() {
        assert (EventQueue.isDispatchThread());
    }

    void addSearchPair(ResultViewPanel resultViewPanel, SearchTask searchTask) {
        if (searchTask != null && resultViewPanel != null) {
            SearchTask searchTask2 = this.viewToSearchMap.get(resultViewPanel);
            if (searchTask2 != null) {
                this.searchToViewMap.remove(searchTask2);
            }
            this.searchToViewMap.put(searchTask, resultViewPanel);
            this.viewToSearchMap.put(resultViewPanel, searchTask);
        }
    }

    private void closeAll(boolean bl) {
        Component component;
        if (this.tabs.getTabCount() > 0) {
            Component component2 = this.tabs.getSelectedComponent();
            Component[] componentArray = this.tabs.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (bl && componentArray[i] == component2 || !(componentArray[i] instanceof ResultViewPanel)) continue;
                this.removePanel((ResultViewPanel)componentArray[i]);
            }
        } else if (this.singlePanel.getComponents().length > 0 && (component = this.singlePanel.getComponents()[0]) instanceof ResultViewPanel) {
            this.removePanel((ResultViewPanel)component);
        }
    }

    ResultViewPanel addTab(SearchTask searchTask) {
        int n = this.tryReuse();
        ResultViewPanel resultViewPanel = new ResultViewPanel(searchTask);
        SearchComposition<?> searchComposition = searchTask.getComposition();
        String string = searchComposition.getSearchResultsDisplayer().getTitle();
        if (this.singlePanel.getComponents().length == 0 && this.tabs.getTabCount() == 0) {
            this.singlePanel.add(resultViewPanel);
            this.contentCards.show((Container)((Object)this), CARD_NAME_SINGLE);
            this.updateLookup();
        } else if (this.singlePanel.getComponents().length == 1) {
            ResultViewPanel resultViewPanel2 = (ResultViewPanel)this.singlePanel.getComponents()[0];
            this.tabs.insertTab(resultViewPanel2.getName(), null, resultViewPanel2, resultViewPanel2.getToolTipText(), 0);
            this.tabs.setToolTipTextAt(0, resultViewPanel2.getToolTipText());
            int n2 = n > -1 ? n : 1;
            this.tabs.insertTab(string, null, resultViewPanel, resultViewPanel.getToolTipText(), n2);
            this.tabs.setToolTipTextAt(n2, resultViewPanel.getToolTipText());
            this.tabs.setSelectedIndex(n > -1 ? n : 1);
            this.contentCards.show((Container)((Object)this), CARD_NAME_TABS);
        } else {
            this.tabs.insertTab(string, null, resultViewPanel, resultViewPanel.getToolTipText(), n > -1 ? n : this.tabs.getTabCount());
            this.tabs.setToolTipTextAt(n > -1 ? n : this.tabs.getTabCount() - 1, resultViewPanel.getToolTipText());
            this.tabs.setSelectedComponent(resultViewPanel);
            this.tabs.validate();
        }
        this.validate();
        this.requestActive();
        this.updateTooltip();
        return resultViewPanel;
    }

    private int tryReuse() {
        int n;
        ResultViewPanel resultViewPanel = this.getTabToReuse();
        if (resultViewPanel == null) {
            return -1;
        }
        if (this.singlePanel.getComponents().length == 1 && this.singlePanel.getComponent(0) == resultViewPanel) {
            this.removePanel(resultViewPanel);
            this.clearReusableTab();
            return 0;
        }
        if (this.tabs.getTabCount() > 0 && (n = this.tabs.indexOfComponent(resultViewPanel)) >= 0) {
            this.removePanel(resultViewPanel);
            this.clearReusableTab();
            return n;
        }
        return this.tabs.getTabCount();
    }

    public boolean isFocused() {
        ResultViewPanel resultViewPanel = this.getCurrentResultViewPanel();
        if (resultViewPanel != null) {
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            return component != null && SwingUtilities.isDescendingFrom(component, resultViewPanel);
        }
        return false;
    }

    private synchronized void setTabToReuse(ResultViewPanel resultViewPanel) {
        this.tabToReuse = resultViewPanel == null ? null : new WeakReference<ResultViewPanel>(resultViewPanel);
    }

    private synchronized ResultViewPanel getTabToReuse() {
        return this.tabToReuse == null || this.tabToReuse.get() == null ? null : (ResultViewPanel)this.tabToReuse.get();
    }

    public synchronized void markCurrentTabAsReusable() {
        this.setTabToReuse(this.getCurrentResultViewPanel());
    }

    public synchronized void clearReusableTab() {
        this.setTabToReuse(null);
    }

    private void updateLookup() {
        ResultViewPanel resultViewPanel = this.getCurrentResultViewPanel();
        this.lookupProvider.setLookup(resultViewPanel == null ? Lookup.EMPTY : resultViewPanel.getLookup());
        this.getLookup().lookup(Object.class);
    }

    private void updateTooltip() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><b>");
        stringBuilder.append(NbBundle.getMessage(ResultView.class, (String)"TOOLTIP_SEARCH_RESULTS"));
        stringBuilder.append("</b>");
        if (this.singlePanel.getComponents().length == 1) {
            this.appendTabToToolTip(this.singlePanel.getComponent(0), stringBuilder);
        } else if (this.tabs.getComponents().length > 0) {
            Component[] componentArray = this.tabs.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.appendTabToToolTip(componentArray[i], stringBuilder);
            }
        }
        stringBuilder.append("</html>");
        this.setToolTipText(stringBuilder.toString());
    }

    private void appendTabToToolTip(Component component, StringBuilder stringBuilder) {
        ResultViewPanel resultViewPanel;
        if (component instanceof ResultViewPanel && (resultViewPanel = (ResultViewPanel)component).getToolTipText() != null) {
            stringBuilder.append("<br>&nbsp;&nbsp;");
            stringBuilder.append(UiUtils.escapeHtml(resultViewPanel.getToolTipText()));
            stringBuilder.append("&nbsp;");
        }
    }

    private static class CurrentLookupProvider
    implements Lookup.Provider {
        private Lookup currentLookup = Lookup.EMPTY;

        private CurrentLookupProvider() {
        }

        public void setLookup(Lookup lookup) {
            this.currentLookup = lookup;
        }

        public Lookup getLookup() {
            return this.currentLookup;
        }
    }

    private class CloseAllButCurrent
    extends AbstractAction {
        public CloseAllButCurrent() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseAllButCurrent"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResultView.this.closeAll(true);
        }
    }

    private final class CloseAll
    extends AbstractAction {
        public CloseAll() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseAll"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResultView.this.closeAll(false);
        }
    }

    private class Close
    extends AbstractAction {
        public Close() {
            super(NbBundle.getMessage(ResultView.class, (String)"LBL_CloseWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResultView.this.removePanel(null);
        }
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        private PopupListener() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            ResultView.this.pop.show((Component)((Object)ResultView.this), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class CloseListener
    implements PropertyChangeListener {
        private CloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("close".equals(propertyChangeEvent.getPropertyName())) {
                ResultView.this.removePanel((ResultViewPanel)propertyChangeEvent.getNewValue());
            }
        }
    }

    @Deprecated
    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7398708142639457544L;

        public Object readResolve() {
            return null;
        }
    }
}

