/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum ChangeType {
    ADD("add"),
    DELETE("delete"),
    MODIFY("modify"),
    MODIFY_DN("moddn");

    private final String name;

    private ChangeType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static ChangeType forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        if (lowerName.equals("add")) {
            return ADD;
        }
        if (lowerName.equals("delete")) {
            return DELETE;
        }
        if (lowerName.equals("modify")) {
            return MODIFY;
        }
        if (lowerName.equals("moddn") || lowerName.equals("modrdn")) {
            return MODIFY_DN;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

