/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.experimental;

import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00Entry;
import com.unboundid.ldap.sdk.experimental.ExperimentalMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DraftChuLDAPLogSchema00SearchEntry
extends DraftChuLDAPLogSchema00Entry {
    public static final String ATTR_DEREFERENCE_POLICY = "reqDerefAliases";
    public static final String ATTR_ENTRIES_RETURNED = "reqEntries";
    public static final String ATTR_FILTER = "reqFilter";
    public static final String ATTR_REQUESTED_ATTRIBUTE = "reqAttr";
    public static final String ATTR_SCOPE = "reqScope";
    public static final String ATTR_SIZE_LIMIT = "reqSizeLimit";
    public static final String ATTR_TIME_LIMIT_SECONDS = "reqTimeLimit";
    public static final String ATTR_TYPES_ONLY = "reqAttrsOnly";
    private static final long serialVersionUID = 948178493925578134L;
    private final boolean typesOnly;
    private final DereferencePolicy dereferencePolicy;
    private final Filter filter;
    private final Integer entriesReturned;
    private final Integer requestedSizeLimit;
    private final Integer requestedTimeLimitSeconds;
    private final List<String> requestedAttributes;
    private final SearchScope scope;

    public DraftChuLDAPLogSchema00SearchEntry(Entry entry) throws LDAPException {
        super(entry, OperationType.SEARCH);
        String scopeStr = entry.getAttributeValue(ATTR_SCOPE);
        if (scopeStr == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_SCOPE));
        }
        String lowerScope = StaticUtils.toLowerCase(scopeStr);
        if (lowerScope.equals("base")) {
            this.scope = SearchScope.BASE;
        } else if (lowerScope.equals("one")) {
            this.scope = SearchScope.ONE;
        } else if (lowerScope.equals("sub")) {
            this.scope = SearchScope.SUB;
        } else if (lowerScope.equals("subord")) {
            this.scope = SearchScope.SUBORDINATE_SUBTREE;
        } else {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_SEARCH_SCOPE_ERROR.get(entry.getDN(), ATTR_SCOPE, scopeStr));
        }
        String derefStr = entry.getAttributeValue(ATTR_DEREFERENCE_POLICY);
        if (derefStr == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_DEREFERENCE_POLICY));
        }
        String lowerDeref = StaticUtils.toLowerCase(derefStr);
        if (lowerDeref.equals("never")) {
            this.dereferencePolicy = DereferencePolicy.NEVER;
        } else if (lowerDeref.equals("searching")) {
            this.dereferencePolicy = DereferencePolicy.SEARCHING;
        } else if (lowerDeref.equals("finding")) {
            this.dereferencePolicy = DereferencePolicy.FINDING;
        } else if (lowerDeref.equals("always")) {
            this.dereferencePolicy = DereferencePolicy.ALWAYS;
        } else {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_SEARCH_DEREF_ERROR.get(entry.getDN(), ATTR_DEREFERENCE_POLICY, derefStr));
        }
        String typesOnlyStr = entry.getAttributeValue(ATTR_TYPES_ONLY);
        if (typesOnlyStr == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_TYPES_ONLY));
        }
        String lowerTypesOnly = StaticUtils.toLowerCase(typesOnlyStr);
        if (lowerTypesOnly.equals("true")) {
            this.typesOnly = true;
        } else if (lowerTypesOnly.equals("false")) {
            this.typesOnly = false;
        } else {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_SEARCH_TYPES_ONLY_ERROR.get(entry.getDN(), ATTR_TYPES_ONLY, typesOnlyStr));
        }
        String filterStr = entry.getAttributeValue(ATTR_FILTER);
        if (filterStr == null) {
            this.filter = null;
        } else {
            try {
                this.filter = Filter.create(filterStr);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_SEARCH_FILTER_ERROR.get(entry.getDN(), ATTR_FILTER, filterStr), e);
            }
        }
        String[] requestedAttrArray = entry.getAttributeValues(ATTR_REQUESTED_ATTRIBUTE);
        this.requestedAttributes = requestedAttrArray == null || requestedAttrArray.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(StaticUtils.toList(requestedAttrArray));
        String sizeLimitStr = entry.getAttributeValue(ATTR_SIZE_LIMIT);
        if (sizeLimitStr == null) {
            this.requestedSizeLimit = null;
        } else {
            try {
                this.requestedSizeLimit = Integer.parseInt(sizeLimitStr);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_SEARCH_INT_ERROR.get(entry.getDN(), ATTR_SIZE_LIMIT, sizeLimitStr), e);
            }
        }
        String timeLimitStr = entry.getAttributeValue(ATTR_TIME_LIMIT_SECONDS);
        if (timeLimitStr == null) {
            this.requestedTimeLimitSeconds = null;
        } else {
            try {
                this.requestedTimeLimitSeconds = Integer.parseInt(timeLimitStr);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_SEARCH_INT_ERROR.get(entry.getDN(), ATTR_TIME_LIMIT_SECONDS, timeLimitStr), e);
            }
        }
        String entriesReturnedStr = entry.getAttributeValue(ATTR_ENTRIES_RETURNED);
        if (entriesReturnedStr == null) {
            this.entriesReturned = null;
        } else {
            try {
                this.entriesReturned = Integer.parseInt(entriesReturnedStr);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_SEARCH_INT_ERROR.get(entry.getDN(), ATTR_ENTRIES_RETURNED, entriesReturnedStr), e);
            }
        }
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public DereferencePolicy getDereferencePolicy() {
        return this.dereferencePolicy;
    }

    public boolean typesOnly() {
        return this.typesOnly;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Integer getRequestedSizeLimit() {
        return this.requestedSizeLimit;
    }

    public Integer getRequestedTimeLimitSeconds() {
        return this.requestedTimeLimitSeconds;
    }

    public List<String> getRequestedAttributes() {
        return this.requestedAttributes;
    }

    public Integer getEntriesReturned() {
        return this.entriesReturned;
    }

    public SearchRequest toSearchRequest() {
        int sizeLimit = this.requestedSizeLimit == null ? 0 : this.requestedSizeLimit;
        int timeLimit = this.requestedTimeLimitSeconds == null ? 0 : this.requestedTimeLimitSeconds;
        Filter f = this.filter == null ? Filter.createPresenceFilter("objectClass") : this.filter;
        String[] attrArray = this.requestedAttributes.toArray(StaticUtils.NO_STRINGS);
        SearchRequest searchRequest = new SearchRequest(this.getTargetEntryDN(), this.scope, this.dereferencePolicy, sizeLimit, timeLimit, this.typesOnly, f, attrArray);
        searchRequest.setControls(this.getRequestControlArray());
        return searchRequest;
    }
}

