/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class WrapperKeyManager
extends X509ExtendedKeyManager {
    private final String certificateAlias;
    private final X509KeyManager[] keyManagers;

    protected WrapperKeyManager(KeyManager[] keyManagers, String certificateAlias) {
        this.certificateAlias = certificateAlias;
        this.keyManagers = new X509KeyManager[keyManagers.length];
        for (int i = 0; i < keyManagers.length; ++i) {
            this.keyManagers[i] = (X509KeyManager)keyManagers[i];
        }
    }

    protected WrapperKeyManager(X509KeyManager[] keyManagers, String certificateAlias) {
        this.keyManagers = keyManagers;
        this.certificateAlias = certificateAlias;
    }

    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public final synchronized String[] getClientAliases(String keyType, Principal[] issuers) {
        LinkedHashSet<String> clientAliases = new LinkedHashSet<String>();
        for (X509KeyManager m : this.keyManagers) {
            String[] aliases = m.getClientAliases(keyType, issuers);
            if (aliases == null) continue;
            clientAliases.addAll(Arrays.asList(aliases));
        }
        if (clientAliases.isEmpty()) {
            return null;
        }
        String[] aliases = new String[clientAliases.size()];
        return clientAliases.toArray(aliases);
    }

    public final synchronized String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m : this.keyManagers) {
                String alias = m.chooseClientAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (String s : keyType) {
            for (X509KeyManager m : this.keyManagers) {
                String[] aliases = m.getClientAliases(s, issuers);
                if (aliases == null) continue;
                for (String alias : aliases) {
                    if (!alias.equals(this.certificateAlias)) continue;
                    return this.certificateAlias;
                }
            }
        }
        return null;
    }

    public final synchronized String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m : this.keyManagers) {
                if (m instanceof X509ExtendedKeyManager) {
                    X509ExtendedKeyManager em = (X509ExtendedKeyManager)m;
                    String alias = em.chooseEngineClientAlias(keyType, issuers, engine);
                    if (alias == null) continue;
                    return alias;
                }
                String alias = m.chooseClientAlias(keyType, issuers, null);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (String s : keyType) {
            for (X509KeyManager m : this.keyManagers) {
                String[] aliases = m.getClientAliases(s, issuers);
                if (aliases == null) continue;
                for (String alias : aliases) {
                    if (!alias.equals(this.certificateAlias)) continue;
                    return this.certificateAlias;
                }
            }
        }
        return null;
    }

    public final synchronized String[] getServerAliases(String keyType, Principal[] issuers) {
        LinkedHashSet<String> serverAliases = new LinkedHashSet<String>();
        for (X509KeyManager m : this.keyManagers) {
            String[] aliases = m.getServerAliases(keyType, issuers);
            if (aliases == null) continue;
            serverAliases.addAll(Arrays.asList(aliases));
        }
        if (serverAliases.isEmpty()) {
            return null;
        }
        String[] aliases = new String[serverAliases.size()];
        return serverAliases.toArray(aliases);
    }

    public final synchronized String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m : this.keyManagers) {
                String alias = m.chooseServerAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (X509KeyManager m : this.keyManagers) {
            String[] aliases = m.getServerAliases(keyType, issuers);
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (!alias.equals(this.certificateAlias)) continue;
                return this.certificateAlias;
            }
        }
        return null;
    }

    public final synchronized String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m : this.keyManagers) {
                if (m instanceof X509ExtendedKeyManager) {
                    X509ExtendedKeyManager em = (X509ExtendedKeyManager)m;
                    String alias = em.chooseEngineServerAlias(keyType, issuers, engine);
                    if (alias == null) continue;
                    return alias;
                }
                String alias = m.chooseServerAlias(keyType, issuers, null);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (X509KeyManager m : this.keyManagers) {
            String[] aliases = m.getServerAliases(keyType, issuers);
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (!alias.equals(this.certificateAlias)) continue;
                return this.certificateAlias;
            }
        }
        return null;
    }

    public final synchronized X509Certificate[] getCertificateChain(String alias) {
        for (X509KeyManager m : this.keyManagers) {
            X509Certificate[] chain = m.getCertificateChain(alias);
            if (chain == null) continue;
            return chain;
        }
        return null;
    }

    public final synchronized PrivateKey getPrivateKey(String alias) {
        for (X509KeyManager m : this.keyManagers) {
            PrivateKey key = m.getPrivateKey(alias);
            if (key == null) continue;
            return key;
        }
        return null;
    }
}

