/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import com.carrotsearch.hppc.ObjectIntHashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;

public final class CombinedDeletionPolicy
extends IndexDeletionPolicy {
    private final Logger logger;
    private final TranslogDeletionPolicy translogDeletionPolicy;
    private final LongSupplier globalCheckpointSupplier;
    private final ObjectIntHashMap<IndexCommit> snapshottedCommits;
    private volatile IndexCommit safeCommit;
    private volatile IndexCommit lastCommit;

    CombinedDeletionPolicy(Logger logger, TranslogDeletionPolicy translogDeletionPolicy, LongSupplier globalCheckpointSupplier) {
        this.logger = logger;
        this.translogDeletionPolicy = translogDeletionPolicy;
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.snapshottedCommits = new ObjectIntHashMap();
    }

    @Override
    public synchronized void onInit(List<? extends IndexCommit> commits) throws IOException {
        assert (!commits.isEmpty()) : "index is opened, but we have no commits";
        this.onCommit(commits);
        if (this.safeCommit != commits.get(commits.size() - 1)) {
            throw new IllegalStateException("Engine is opened, but the last commit isn't safe. Global checkpoint [" + this.globalCheckpointSupplier.getAsLong() + "], seqNo is last commit [" + SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.lastCommit.getUserData().entrySet()) + "], seqNos in safe commit [" + SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.safeCommit.getUserData().entrySet()) + "]");
        }
    }

    @Override
    public synchronized void onCommit(List<? extends IndexCommit> commits) throws IOException {
        int keptPosition = CombinedDeletionPolicy.indexOfKeptCommits(commits, this.globalCheckpointSupplier.getAsLong());
        this.lastCommit = commits.get(commits.size() - 1);
        this.safeCommit = commits.get(keptPosition);
        for (int i = 0; i < keptPosition; ++i) {
            if (this.snapshottedCommits.containsKey((Object)commits.get(i))) continue;
            this.deleteCommit(commits.get(i));
        }
        this.updateTranslogDeletionPolicy();
    }

    private void deleteCommit(IndexCommit commit) throws IOException {
        assert (!commit.isDeleted()) : "Index commit [" + CombinedDeletionPolicy.commitDescription(commit) + "] is deleted twice";
        this.logger.debug("Delete index commit [{}]", (Object)CombinedDeletionPolicy.commitDescription(commit));
        commit.delete();
        assert (commit.isDeleted()) : "Deletion commit [" + CombinedDeletionPolicy.commitDescription(commit) + "] was suppressed";
    }

    private void updateTranslogDeletionPolicy() throws IOException {
        assert (Thread.holdsLock(this));
        this.logger.debug("Safe commit [{}], last commit [{}]", (Object)CombinedDeletionPolicy.commitDescription(this.safeCommit), (Object)CombinedDeletionPolicy.commitDescription(this.lastCommit));
        assert (!this.safeCommit.isDeleted()) : "The safe commit must not be deleted";
        long minRequiredGen = Long.parseLong(this.safeCommit.getUserData().get("translog_generation"));
        assert (!this.lastCommit.isDeleted()) : "The last commit must not be deleted";
        long lastGen = Long.parseLong(this.lastCommit.getUserData().get("translog_generation"));
        assert (minRequiredGen <= lastGen) : "minRequiredGen must not be greater than lastGen";
        this.translogDeletionPolicy.setTranslogGenerationOfLastCommit(lastGen);
        this.translogDeletionPolicy.setMinTranslogGenerationForRecovery(minRequiredGen);
    }

    synchronized IndexCommit acquireIndexCommit(boolean acquiringSafeCommit) {
        assert (this.safeCommit != null) : "Safe commit is not initialized yet";
        assert (this.lastCommit != null) : "Last commit is not initialized yet";
        IndexCommit snapshotting = acquiringSafeCommit ? this.safeCommit : this.lastCommit;
        this.snapshottedCommits.addTo((Object)snapshotting, 1);
        return new SnapshotIndexCommit(snapshotting);
    }

    synchronized boolean releaseCommit(IndexCommit snapshotCommit) {
        IndexCommit releasingCommit = ((SnapshotIndexCommit)snapshotCommit).delegate;
        assert (this.snapshottedCommits.containsKey((Object)releasingCommit)) : "Release non-snapshotted commit;snapshotted commits [" + this.snapshottedCommits + "], releasing commit [" + releasingCommit + "]";
        int refCount = this.snapshottedCommits.addTo((Object)releasingCommit, -1);
        assert (refCount >= 0) : "Number of snapshots can not be negative [" + refCount + "]";
        if (refCount == 0) {
            this.snapshottedCommits.remove((Object)releasingCommit);
        }
        return refCount == 0 && !releasingCommit.equals(this.safeCommit) && !releasingCommit.equals(this.lastCommit);
    }

    public static IndexCommit findSafeCommitPoint(List<IndexCommit> commits, long globalCheckpoint) throws IOException {
        if (commits.isEmpty()) {
            throw new IllegalArgumentException("Commit list must not empty");
        }
        int keptPosition = CombinedDeletionPolicy.indexOfKeptCommits(commits, globalCheckpoint);
        return commits.get(keptPosition);
    }

    private static int indexOfKeptCommits(List<? extends IndexCommit> commits, long globalCheckpoint) throws IOException {
        String expectedTranslogUUID = commits.get(commits.size() - 1).getUserData().get("translog_uuid");
        for (int i = commits.size() - 1; i >= 0; --i) {
            Map<String, String> commitUserData = commits.get(i).getUserData();
            if (!expectedTranslogUUID.equals(commitUserData.get("translog_uuid"))) {
                return i + 1;
            }
            if (!commitUserData.containsKey("max_seq_no")) {
                return Math.min(commits.size() - 1, i + 1);
            }
            long maxSeqNoFromCommit = Long.parseLong(commitUserData.get("max_seq_no"));
            if (maxSeqNoFromCommit == -1L) {
                return i;
            }
            if (maxSeqNoFromCommit > globalCheckpoint) continue;
            return i;
        }
        return 0;
    }

    boolean hasUnreferencedCommits() throws IOException {
        IndexCommit lastCommit = this.lastCommit;
        if (this.safeCommit != lastCommit && lastCommit.getUserData().containsKey("max_seq_no")) {
            long maxSeqNoFromLastCommit = Long.parseLong(lastCommit.getUserData().get("max_seq_no"));
            return this.globalCheckpointSupplier.getAsLong() >= maxSeqNoFromLastCommit;
        }
        return false;
    }

    public static String commitDescription(IndexCommit commit) throws IOException {
        return String.format(Locale.ROOT, "CommitPoint{segment[%s], userData[%s]}", commit.getSegmentsFileName(), commit.getUserData());
    }

    private static class SnapshotIndexCommit
    extends IndexCommit {
        private final IndexCommit delegate;

        SnapshotIndexCommit(IndexCommit delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getSegmentsFileName() {
            return this.delegate.getSegmentsFileName();
        }

        @Override
        public Collection<String> getFileNames() throws IOException {
            return this.delegate.getFileNames();
        }

        @Override
        public Directory getDirectory() {
            return this.delegate.getDirectory();
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("A snapshot commit does not support deletion");
        }

        @Override
        public boolean isDeleted() {
            return this.delegate.isDeleted();
        }

        @Override
        public int getSegmentCount() {
            return this.delegate.getSegmentCount();
        }

        @Override
        public long getGeneration() {
            return this.delegate.getGeneration();
        }

        @Override
        public Map<String, String> getUserData() throws IOException {
            return this.delegate.getUserData();
        }

        public String toString() {
            return "SnapshotIndexCommit{" + this.delegate + "}";
        }
    }
}

