/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;

public abstract class AbstractRestChannel
implements RestChannel {
    private static final Predicate<String> INCLUDE_FILTER = f -> f.charAt(0) != '-';
    private static final Predicate<String> EXCLUDE_FILTER = INCLUDE_FILTER.negate();
    protected final RestRequest request;
    protected final boolean detailedErrorsEnabled;
    private final String format;
    private final String filterPath;
    private final boolean pretty;
    private final boolean human;
    private BytesStreamOutput bytesOut;

    protected AbstractRestChannel(RestRequest request, boolean detailedErrorsEnabled) {
        this.request = request;
        this.detailedErrorsEnabled = detailedErrorsEnabled;
        this.format = request.param("format", request.header("Accept"));
        this.filterPath = request.param("filter_path", null);
        this.pretty = request.paramAsBoolean("pretty", false);
        this.human = request.paramAsBoolean("human", false);
    }

    @Override
    public XContentBuilder newBuilder() throws IOException {
        return this.newBuilder(this.request.getXContentType(), true);
    }

    @Override
    public XContentBuilder newErrorBuilder() throws IOException {
        return this.newBuilder(this.request.getXContentType(), false);
    }

    @Override
    public XContentBuilder newBuilder(@Nullable XContentType requestContentType, boolean useFiltering) throws IOException {
        XContentType responseContentType = XContentType.fromMediaTypeOrFormat(this.format);
        if (responseContentType == null) {
            responseContentType = requestContentType != null ? requestContentType : XContentType.JSON;
        }
        Set<String> includes = Collections.emptySet();
        Set<String> excludes = Collections.emptySet();
        if (useFiltering) {
            Set<String> filters = Strings.tokenizeByCommaToSet(this.filterPath);
            includes = filters.stream().filter(INCLUDE_FILTER).collect(Collectors.toSet());
            excludes = filters.stream().filter(EXCLUDE_FILTER).map(f -> f.substring(1)).collect(Collectors.toSet());
        }
        BytesStream unclosableOutputStream = Streams.flushOnCloseStream(this.bytesOutput());
        XContentBuilder builder = new XContentBuilder(XContentFactory.xContent(responseContentType), unclosableOutputStream, includes, excludes);
        if (this.pretty) {
            builder.prettyPrint().lfAtEnd();
        }
        builder.humanReadable(this.human);
        return builder;
    }

    @Override
    public final BytesStreamOutput bytesOutput() {
        if (this.bytesOut == null) {
            this.bytesOut = this.newBytesOutput();
        } else {
            this.bytesOut.reset();
        }
        return this.bytesOut;
    }

    protected final BytesStreamOutput bytesOutputOrNull() {
        return this.bytesOut;
    }

    protected BytesStreamOutput newBytesOutput() {
        return new BytesStreamOutput();
    }

    @Override
    public RestRequest request() {
        return this.request;
    }

    @Override
    public boolean detailedErrorsEnabled() {
        return this.detailedErrorsEnabled;
    }
}

