/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;

public final class TransportCreateTokenAction
extends HandledTransportAction<CreateTokenRequest, CreateTokenResponse> {
    private static final String DEFAULT_SCOPE = "full";
    private final TokenService tokenService;
    private final AuthenticationService authenticationService;

    @Inject
    public TransportCreateTokenAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TokenService tokenService, AuthenticationService authenticationService) {
        super(settings, "cluster:admin/xpack/security/token/create", threadPool, transportService, actionFilters, indexNameExpressionResolver, CreateTokenRequest::new);
        this.tokenService = tokenService;
        this.authenticationService = authenticationService;
    }

    protected void doExecute(CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        Authentication originatingAuthentication = Authentication.getAuthentication((ThreadContext)this.threadPool.getThreadContext());
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            UsernamePasswordToken authToken = new UsernamePasswordToken(request.getUsername(), request.getPassword());
            this.authenticationService.authenticate("cluster:admin/xpack/security/token/create", (TransportMessage)request, (AuthenticationToken)authToken, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                request.getPassword().close();
                this.tokenService.createUserToken((Authentication)authentication, originatingAuthentication, (ActionListener<Tuple<UserToken, String>>)ActionListener.wrap(tuple -> {
                    String tokenStr = this.tokenService.getUserTokenString((UserToken)tuple.v1());
                    String scope = TransportCreateTokenAction.getResponseScopeValue(request.getScope());
                    CreateTokenResponse response = new CreateTokenResponse(tokenStr, this.tokenService.getExpirationDelay(), scope, (String)tuple.v2());
                    listener.onResponse((Object)response);
                }, e -> {
                    request.getPassword().close();
                    listener.onFailure(e);
                }), Collections.emptyMap());
            }, e -> {
                request.getPassword().close();
                listener.onFailure(e);
            }));
        }
    }

    static String getResponseScopeValue(String requestScope) {
        String scope = requestScope != null ? DEFAULT_SCOPE : null;
        return scope;
    }
}

