/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;

public class SamlNameId {
    final String format;
    final String value;
    final String idpNameQualifier;
    final String spNameQualifier;
    final String spProvidedId;

    public SamlNameId(String format, String value, String idpNameQualifier, String spNameQualifier, String spProvidedId) {
        this.format = format;
        this.value = value;
        this.idpNameQualifier = idpNameQualifier;
        this.spNameQualifier = spNameQualifier;
        this.spProvidedId = spProvidedId;
    }

    public String toString() {
        return "NameId(" + this.format + ")=" + this.value;
    }

    public NameID asXml() {
        NameID nameId = SamlUtils.buildObject(NameID.class, NameID.DEFAULT_ELEMENT_NAME);
        nameId.setFormat(this.format);
        nameId.setValue(this.value);
        nameId.setNameQualifier(this.idpNameQualifier);
        nameId.setSPNameQualifier(this.spNameQualifier);
        nameId.setSPProvidedID(this.spProvidedId);
        return nameId;
    }

    static SamlNameId fromXml(NameID name) {
        if (name == null) {
            return null;
        }
        return new SamlNameId(name.getFormat(), name.getValue(), name.getNameQualifier(), name.getSPNameQualifier(), name.getSPProvidedID());
    }

    static SamlNameId forSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        NameID name = subject.getNameID();
        return SamlNameId.fromXml(name);
    }
}

