/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class IndexLifecycleManager
extends AbstractComponent {
    public static final String INTERNAL_SECURITY_INDEX = ".security-6";
    public static final int INTERNAL_INDEX_FORMAT = 6;
    public static final String SECURITY_VERSION_STRING = "security-version";
    public static final String TEMPLATE_VERSION_PATTERN = Pattern.quote("${security.template.version}");
    private final String indexName;
    private final Client client;
    private final List<BiConsumer<ClusterIndexHealth, ClusterIndexHealth>> indexHealthChangeListeners = new CopyOnWriteArrayList<BiConsumer<ClusterIndexHealth, ClusterIndexHealth>>();
    private final List<BiConsumer<Boolean, Boolean>> indexOutOfDateListeners = new CopyOnWriteArrayList<BiConsumer<Boolean, Boolean>>();
    private volatile State indexState = new State(false, false, false, false, null);

    public IndexLifecycleManager(Settings settings, Client client, String indexName) {
        super(settings);
        this.client = client;
        this.indexName = indexName;
    }

    public boolean checkMappingVersion(Predicate<Version> requiredVersion) {
        State currentIndexState = this.indexState;
        return currentIndexState.mappingVersion == null || requiredVersion.test(currentIndexState.mappingVersion);
    }

    public boolean indexExists() {
        return this.indexState.indexExists;
    }

    public boolean isIndexUpToDate() {
        return this.indexState.isIndexUpToDate;
    }

    public boolean isAvailable() {
        return this.indexState.indexAvailable;
    }

    public boolean isMappingUpToDate() {
        return this.indexState.mappingUpToDate;
    }

    public void addIndexHealthChangeListener(BiConsumer<ClusterIndexHealth, ClusterIndexHealth> listener) {
        this.indexHealthChangeListeners.add(listener);
    }

    public void addIndexOutOfDateListener(BiConsumer<Boolean, Boolean> listener) {
        this.indexOutOfDateListeners.add(listener);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean previousUpToDate = this.indexState.isIndexUpToDate;
        this.processClusterState(event.state());
        this.checkIndexHealthChange(event);
        if (previousUpToDate != this.indexState.isIndexUpToDate) {
            this.notifyIndexOutOfDateListeners(previousUpToDate, this.indexState.isIndexUpToDate);
        }
    }

    private void processClusterState(ClusterState clusterState) {
        assert (clusterState != null);
        IndexMetaData securityIndex = IndexLifecycleManager.resolveConcreteIndex(this.indexName, clusterState.metaData());
        boolean indexExists = securityIndex != null;
        boolean isIndexUpToDate = !indexExists || (Integer)IndexMetaData.INDEX_FORMAT_SETTING.get(securityIndex.getSettings()) == 6;
        boolean indexAvailable = this.checkIndexAvailable(clusterState);
        boolean mappingIsUpToDate = !indexExists || this.checkIndexMappingUpToDate(clusterState);
        Version mappingVersion = this.oldestIndexMappingVersion(clusterState);
        this.indexState = new State(indexExists, isIndexUpToDate, indexAvailable, mappingIsUpToDate, mappingVersion);
    }

    private void checkIndexHealthChange(ClusterChangedEvent event) {
        ClusterState state = event.state();
        ClusterState previousState = event.previousState();
        IndexMetaData indexMetaData = IndexLifecycleManager.resolveConcreteIndex(this.indexName, state.metaData());
        IndexMetaData previousIndexMetaData = IndexLifecycleManager.resolveConcreteIndex(this.indexName, previousState.metaData());
        if (indexMetaData != null) {
            ClusterIndexHealth previousHealth;
            ClusterIndexHealth currentHealth = new ClusterIndexHealth(indexMetaData, state.getRoutingTable().index(indexMetaData.getIndex()));
            ClusterIndexHealth clusterIndexHealth = previousHealth = previousIndexMetaData != null ? new ClusterIndexHealth(previousIndexMetaData, previousState.getRoutingTable().index(previousIndexMetaData.getIndex())) : null;
            if (previousHealth == null || previousHealth.getStatus() != currentHealth.getStatus()) {
                this.notifyIndexHealthChangeListeners(previousHealth, currentHealth);
            }
        } else if (previousIndexMetaData != null) {
            ClusterIndexHealth previousHealth = new ClusterIndexHealth(previousIndexMetaData, previousState.getRoutingTable().index(previousIndexMetaData.getIndex()));
            this.notifyIndexHealthChangeListeners(previousHealth, null);
        }
    }

    private void notifyIndexHealthChangeListeners(ClusterIndexHealth previousHealth, ClusterIndexHealth currentHealth) {
        for (BiConsumer<ClusterIndexHealth, ClusterIndexHealth> consumer : this.indexHealthChangeListeners) {
            try {
                consumer.accept(previousHealth, currentHealth);
            }
            catch (Exception e) {
                this.logger.warn((Message)new ParameterizedMessage("failed to notify listener [{}] of index health change", consumer), (Throwable)e);
            }
        }
    }

    private void notifyIndexOutOfDateListeners(boolean previous, boolean current) {
        for (BiConsumer<Boolean, Boolean> consumer : this.indexOutOfDateListeners) {
            try {
                consumer.accept(previous, current);
            }
            catch (Exception e) {
                this.logger.warn((Message)new ParameterizedMessage("failed to notify listener [{}] of index out of date change", consumer), (Throwable)e);
            }
        }
    }

    private boolean checkIndexAvailable(ClusterState state) {
        IndexRoutingTable routingTable = this.getIndexRoutingTable(state);
        if (routingTable != null && routingTable.allPrimaryShardsActive()) {
            return true;
        }
        this.logger.debug("Security index [{}] is not yet active", (Object)this.indexName);
        return false;
    }

    private IndexRoutingTable getIndexRoutingTable(ClusterState clusterState) {
        IndexMetaData metaData = IndexLifecycleManager.resolveConcreteIndex(this.indexName, clusterState.metaData());
        if (metaData == null) {
            return null;
        }
        return clusterState.routingTable().index(metaData.getIndex());
    }

    public static boolean checkTemplateExistsAndVersionMatches(String templateName, ClusterState state, Logger logger, Predicate<Version> predicate) {
        return TemplateUtils.checkTemplateExistsAndVersionMatches((String)templateName, (String)SECURITY_VERSION_STRING, (ClusterState)state, (Logger)logger, predicate);
    }

    private boolean checkIndexMappingUpToDate(ClusterState clusterState) {
        return this.checkIndexMappingVersionMatches(clusterState, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    private boolean checkIndexMappingVersionMatches(ClusterState clusterState, Predicate<Version> predicate) {
        return IndexLifecycleManager.checkIndexMappingVersionMatches(this.indexName, clusterState, this.logger, predicate);
    }

    public static boolean checkIndexMappingVersionMatches(String indexName, ClusterState clusterState, Logger logger, Predicate<Version> predicate) {
        return IndexLifecycleManager.loadIndexMappingVersions(indexName, clusterState, logger).stream().allMatch(predicate);
    }

    private Version oldestIndexMappingVersion(ClusterState clusterState) {
        Set<Version> versions = IndexLifecycleManager.loadIndexMappingVersions(this.indexName, clusterState, this.logger);
        return versions.stream().min(Version::compareTo).orElse(null);
    }

    private static Set<Version> loadIndexMappingVersions(String indexName, ClusterState clusterState, Logger logger) {
        HashSet<Version> versions = new HashSet<Version>();
        IndexMetaData indexMetaData = IndexLifecycleManager.resolveConcreteIndex(indexName, clusterState.metaData());
        if (indexMetaData != null) {
            for (Object object : indexMetaData.getMappings().values().toArray()) {
                MappingMetaData mappingMetaData = (MappingMetaData)object;
                if (mappingMetaData.type().equals("_default_")) continue;
                versions.add(IndexLifecycleManager.readMappingVersion(indexName, mappingMetaData, logger));
            }
        }
        return versions;
    }

    private static IndexMetaData resolveConcreteIndex(String indexOrAliasName, MetaData metaData) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(indexOrAliasName);
        if (aliasOrIndex != null) {
            List indices = aliasOrIndex.getIndices();
            if (aliasOrIndex.isAlias() && indices.size() > 1) {
                throw new IllegalStateException("Alias [" + indexOrAliasName + "] points to more than one index: " + indices.stream().map(imd -> imd.getIndex().getName()).collect(Collectors.toList()));
            }
            return (IndexMetaData)indices.get(0);
        }
        return null;
    }

    private static Version readMappingVersion(String indexName, MappingMetaData mappingMetaData, Logger logger) {
        try {
            Map meta = (Map)mappingMetaData.sourceAsMap().get("_meta");
            if (meta == null) {
                logger.info("Missing _meta field in mapping [{}] of index [{}]", (Object)mappingMetaData.type(), (Object)indexName);
                throw new IllegalStateException("Cannot read security-version string in index " + indexName);
            }
            return Version.fromString((String)((String)meta.get(SECURITY_VERSION_STRING)));
        }
        catch (ElasticsearchParseException e) {
            logger.error((Message)new ParameterizedMessage("Cannot parse the mapping for index [{}]", (Object)indexName), (Throwable)e);
            throw new ElasticsearchException("Cannot parse the mapping for index [{}]", (Throwable)e, new Object[]{indexName});
        }
    }

    public void prepareIndexIfNeededThenExecute(final Consumer<Exception> consumer, final Runnable andThen) {
        State indexState = this.indexState;
        if (indexState.indexExists && !indexState.isIndexUpToDate) {
            consumer.accept(new IllegalStateException("Security index is not on the current version. Security features relying on the index will not be available until the upgrade API is run on the security index"));
        } else if (!indexState.indexExists) {
            Tuple<String, Settings> mappingAndSettings = this.loadMappingAndSettingsSourceFromTemplate();
            CreateIndexRequest request = new CreateIndexRequest(INTERNAL_SECURITY_INDEX).alias(new Alias(".security")).mapping("doc", (String)mappingAndSettings.v1(), XContentType.JSON).waitForActiveShards(ActiveShardCount.ALL).settings((Settings)mappingAndSettings.v2());
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse createIndexResponse) {
                    if (createIndexResponse.isAcknowledged()) {
                        andThen.run();
                    } else {
                        consumer.accept(new ElasticsearchException("Failed to create security index", new Object[0]));
                    }
                }

                public void onFailure(Exception e) {
                    Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (cause instanceof ResourceAlreadyExistsException) {
                        andThen.run();
                    } else {
                        consumer.accept(e);
                    }
                }
            }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).create(arg_0, arg_1));
        } else if (!indexState.mappingUpToDate) {
            PutMappingRequest request = new PutMappingRequest(new String[]{INTERNAL_SECURITY_INDEX}).source((String)this.loadMappingAndSettingsSourceFromTemplate().v1(), XContentType.JSON).type("doc");
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)ActionListener.wrap(putMappingResponse -> {
                if (putMappingResponse.isAcknowledged()) {
                    andThen.run();
                } else {
                    consumer.accept(new IllegalStateException("put mapping request was not acknowledged"));
                }
            }, consumer), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putMapping(arg_0, arg_1));
        } else {
            andThen.run();
        }
    }

    private Tuple<String, Settings> loadMappingAndSettingsSourceFromTemplate() {
        byte[] template = TemplateUtils.loadTemplate((String)"/security-index-template.json", (String)Version.CURRENT.toString(), (String)TEMPLATE_VERSION_PATTERN).getBytes(StandardCharsets.UTF_8);
        PutIndexTemplateRequest request = new PutIndexTemplateRequest("security-index-template").source(template, XContentType.JSON);
        return new Tuple((Object)((String)request.mappings().get("doc")), (Object)request.settings());
    }

    private static class State {
        private final boolean indexExists;
        private final boolean isIndexUpToDate;
        private final boolean indexAvailable;
        private final boolean mappingUpToDate;
        private final Version mappingVersion;

        private State(boolean indexExists, boolean isIndexUpToDate, boolean indexAvailable, boolean mappingUpToDate, Version mappingVersion) {
            this.indexExists = indexExists;
            this.isIndexUpToDate = isIndexUpToDate;
            this.indexAvailable = indexAvailable;
            this.mappingUpToDate = mappingUpToDate;
            this.mappingVersion = mappingVersion;
        }
    }
}

