/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskStatus;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.notifications.Auditor;

public class TransportCloseJobAction
extends TransportTasksAction<TransportOpenJobAction.JobTask, CloseJobAction.Request, CloseJobAction.Response, CloseJobAction.Response> {
    private final Client client;
    private final ClusterService clusterService;
    private final Auditor auditor;
    private final PersistentTasksService persistentTasksService;

    @Inject
    public TransportCloseJobAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, Client client, Auditor auditor, PersistentTasksService persistentTasksService) {
        super(settings, "cluster:admin/xpack/ml/job/close", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, CloseJobAction.Request::new, CloseJobAction.Response::new, "same");
        this.client = client;
        this.clusterService = clusterService;
        this.auditor = auditor;
        this.persistentTasksService = persistentTasksService;
    }

    static void resolveAndValidateJobId(CloseJobAction.Request request, ClusterState state, List<String> openJobIds, List<String> closingJobIds) {
        PersistentTasksCustomMetaData tasksMetaData = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)state);
        ArrayList failedJobs = new ArrayList();
        Consumer<String> jobIdProcessor = id -> {
            TransportCloseJobAction.validateJobAndTaskState(id, mlMetadata, tasksMetaData);
            Job job = (Job)mlMetadata.getJobs().get(id);
            if (job.isDeleted()) {
                return;
            }
            TransportCloseJobAction.addJobAccordingToState(id, tasksMetaData, openJobIds, closingJobIds, failedJobs);
        };
        Set expandedJobIds = mlMetadata.expandJobIds(request.getJobId(), request.allowNoJobs());
        expandedJobIds.forEach(jobIdProcessor::accept);
        if (!request.isForce() && failedJobs.size() > 0) {
            if (expandedJobIds.size() == 1) {
                throw org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"cannot close job [{}] because it failed, use force close", (Object[])new Object[]{expandedJobIds.iterator().next()});
            }
            throw org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"one or more jobs have state failed, use force close", (Object[])new Object[0]);
        }
        openJobIds.addAll(failedJobs);
    }

    private static void addJobAccordingToState(String jobId, PersistentTasksCustomMetaData tasksMetaData, List<String> openJobs, List<String> closingJobs, List<String> failedJobs) {
        JobState jobState = MlMetadata.getJobState((String)jobId, (PersistentTasksCustomMetaData)tasksMetaData);
        switch (jobState) {
            case CLOSING: {
                closingJobs.add(jobId);
                break;
            }
            case FAILED: {
                failedJobs.add(jobId);
                break;
            }
            case OPENING: 
            case OPENED: {
                openJobs.add(jobId);
                break;
            }
        }
    }

    static WaitForCloseRequest buildWaitForCloseRequest(List<String> openJobIds, List<String> closingJobIds, PersistentTasksCustomMetaData tasks, Auditor auditor) {
        PersistentTasksCustomMetaData.PersistentTask jobTask;
        WaitForCloseRequest waitForCloseRequest = new WaitForCloseRequest();
        for (String jobId : openJobIds) {
            jobTask = MlMetadata.getJobTask((String)jobId, (PersistentTasksCustomMetaData)tasks);
            if (jobTask == null) continue;
            auditor.info(jobId, "Job is closing");
            waitForCloseRequest.persistentTaskIds.add(jobTask.getId());
            waitForCloseRequest.jobsToFinalize.add(jobId);
        }
        for (String jobId : closingJobIds) {
            jobTask = MlMetadata.getJobTask((String)jobId, (PersistentTasksCustomMetaData)tasks);
            if (jobTask == null) continue;
            waitForCloseRequest.persistentTaskIds.add(jobTask.getId());
        }
        return waitForCloseRequest;
    }

    static void validateJobAndTaskState(String jobId, MlMetadata mlMetadata, PersistentTasksCustomMetaData tasks) {
        DatafeedState datafeedState;
        Job job = (Job)mlMetadata.getJobs().get(jobId);
        if (job == null) {
            throw new ResourceNotFoundException("cannot close job, because job [" + jobId + "] does not exist", new Object[0]);
        }
        Optional datafeed = mlMetadata.getDatafeedByJobId(jobId);
        if (datafeed.isPresent() && (datafeedState = MlMetadata.getDatafeedState((String)((DatafeedConfig)datafeed.get()).getId(), (PersistentTasksCustomMetaData)tasks)) != DatafeedState.STOPPED) {
            throw org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"cannot close job [{}], datafeed hasn't been stopped", (Object[])new Object[]{jobId});
        }
    }

    protected void doExecute(Task task, CloseJobAction.Request request, ActionListener<CloseJobAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!request.isLocal() && !nodes.isLocalNodeElectedMaster()) {
            if (nodes.getMasterNode() == null) {
                listener.onFailure((Exception)new MasterNotDiscoveredException("no known master node"));
            } else {
                this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, CloseJobAction.Response::new));
            }
        } else {
            ArrayList<String> openJobIds = new ArrayList<String>();
            ArrayList<String> closingJobIds = new ArrayList<String>();
            TransportCloseJobAction.resolveAndValidateJobId(request, state, openJobIds, closingJobIds);
            request.setOpenJobIds(openJobIds.toArray(new String[0]));
            if (openJobIds.isEmpty() && closingJobIds.isEmpty()) {
                listener.onResponse((Object)new CloseJobAction.Response(true));
                return;
            }
            if (!request.isForce()) {
                HashSet<String> executorNodes = new HashSet<String>();
                PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.metaData().custom("persistent_tasks");
                for (String resolvedJobId : request.getOpenJobIds()) {
                    PersistentTasksCustomMetaData.PersistentTask jobTask = MlMetadata.getJobTask((String)resolvedJobId, (PersistentTasksCustomMetaData)tasks);
                    if (jobTask == null || !jobTask.isAssigned()) {
                        String message = "Cannot close job [" + resolvedJobId + "] because the job does not have an assigned node. Use force close to close the job";
                        listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0]));
                        return;
                    }
                    executorNodes.add(jobTask.getExecutorNode());
                }
                request.setNodes(executorNodes.toArray(new String[executorNodes.size()]));
            }
            if (request.isForce()) {
                ArrayList<String> jobIdsToForceClose = new ArrayList<String>(openJobIds);
                jobIdsToForceClose.addAll(closingJobIds);
                this.forceCloseJob(state, request, jobIdsToForceClose, listener);
            } else {
                this.normalCloseJob(state, task, request, openJobIds, closingJobIds, listener);
            }
        }
    }

    protected void taskOperation(CloseJobAction.Request request, final TransportOpenJobAction.JobTask jobTask, final ActionListener<CloseJobAction.Response> listener) {
        JobTaskStatus taskStatus = new JobTaskStatus(JobState.CLOSING, jobTask.getAllocationId());
        jobTask.updatePersistentStatus((Task.Status)taskStatus, ActionListener.wrap(task -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            protected void doRun() throws Exception {
                jobTask.closeJob("close job (api)");
                listener.onResponse((Object)new CloseJobAction.Response(true));
            }
        }), arg_0 -> listener.onFailure(arg_0)));
    }

    protected CloseJobAction.Response newResponse(CloseJobAction.Request request, List<CloseJobAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (request.getOpenJobIds().length != tasks.size()) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
            }
            return new CloseJobAction.Response(true);
        }
        return new CloseJobAction.Response(tasks.stream().allMatch(CloseJobAction.Response::isClosed));
    }

    protected CloseJobAction.Response readTaskResponse(StreamInput in) throws IOException {
        return new CloseJobAction.Response(in);
    }

    private void forceCloseJob(ClusterState currentState, final CloseJobAction.Request request, List<String> jobIdsToForceClose, final ActionListener<CloseJobAction.Response> listener) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
        final int numberOfJobs = jobIdsToForceClose.size();
        final AtomicInteger counter = new AtomicInteger();
        final AtomicArray failures = new AtomicArray(numberOfJobs);
        for (String jobId : jobIdsToForceClose) {
            PersistentTasksCustomMetaData.PersistentTask jobTask = MlMetadata.getJobTask((String)jobId, (PersistentTasksCustomMetaData)tasks);
            if (jobTask == null) continue;
            this.auditor.info(jobId, "Job is closing (forced)");
            this.persistentTasksService.cancelPersistentTask(jobTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                    if (counter.incrementAndGet() == numberOfJobs) {
                        this.sendResponseOrFailure(request.getJobId(), (ActionListener<CloseJobAction.Response>)listener, (AtomicArray<Exception>)failures);
                    }
                }

                public void onFailure(Exception e) {
                    int slot = counter.incrementAndGet();
                    failures.set(slot - 1, (Object)e);
                    if (slot == numberOfJobs) {
                        this.sendResponseOrFailure(request.getJobId(), (ActionListener<CloseJobAction.Response>)listener, (AtomicArray<Exception>)failures);
                    }
                }

                private void sendResponseOrFailure(String jobId, ActionListener<CloseJobAction.Response> listener2, AtomicArray<Exception> failures2) {
                    List catchedExceptions = failures2.asList();
                    if (catchedExceptions.size() == 0) {
                        listener2.onResponse((Object)new CloseJobAction.Response(true));
                        return;
                    }
                    String msg = "Failed to force close job [" + jobId + "] with [" + catchedExceptions.size() + "] failures, rethrowing last, all Exceptions: [" + catchedExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", ")) + "]";
                    ElasticsearchException e = new ElasticsearchException(msg, (Throwable)catchedExceptions.get(0), new Object[0]);
                    listener2.onFailure((Exception)e);
                }
            });
        }
    }

    private void normalCloseJob(ClusterState currentState, Task task, CloseJobAction.Request request, List<String> openJobIds, List<String> closingJobIds, ActionListener<CloseJobAction.Response> listener) {
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
        WaitForCloseRequest waitForCloseRequest = TransportCloseJobAction.buildWaitForCloseRequest(openJobIds, closingJobIds, tasks, this.auditor);
        if (!waitForCloseRequest.hasJobsToWaitFor()) {
            listener.onResponse((Object)new CloseJobAction.Response(true));
            return;
        }
        boolean noOpenJobsToClose = openJobIds.isEmpty();
        if (noOpenJobsToClose) {
            this.waitForJobClosed(request, waitForCloseRequest, new CloseJobAction.Response(true), listener);
            return;
        }
        ActionListener finalListener = ActionListener.wrap(r -> this.waitForJobClosed(request, waitForCloseRequest, (CloseJobAction.Response)r, listener), arg_0 -> listener.onFailure(arg_0));
        super.doExecute(task, (BaseTasksRequest)request, finalListener);
    }

    void waitForJobClosed(CloseJobAction.Request request, final WaitForCloseRequest waitForCloseRequest, final CloseJobAction.Response response, final ActionListener<CloseJobAction.Response> listener) {
        this.persistentTasksService.waitForPersistentTasksStatus(persistentTasksCustomMetaData -> {
            for (String persistentTaskId : waitForCloseRequest.persistentTaskIds) {
                if (persistentTasksCustomMetaData.getTask(persistentTaskId) == null) continue;
                return false;
            }
            return true;
        }, request.getCloseTimeout(), (ActionListener)new ActionListener<Boolean>(){

            public void onResponse(Boolean result) {
                FinalizeJobExecutionAction.Request finalizeRequest = new FinalizeJobExecutionAction.Request(waitForCloseRequest.jobsToFinalize.toArray(new String[0]));
                ClientHelper.executeAsyncWithOrigin((Client)TransportCloseJobAction.this.client, (String)"ml", (Action)FinalizeJobExecutionAction.INSTANCE, (ActionRequest)finalizeRequest, (ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)response), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static class WaitForCloseRequest {
        List<String> persistentTaskIds = new ArrayList<String>();
        List<String> jobsToFinalize = new ArrayList<String>();

        WaitForCloseRequest() {
        }

        public boolean hasJobsToWaitFor() {
            return !this.persistentTaskIds.isEmpty();
        }
    }
}

