/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;

public class MlFilterWriter {
    private static final String FILTER_PREFIX = "filter.";
    private final Collection<MlFilter> filters;
    private final StringBuilder buffer;

    public MlFilterWriter(Collection<MlFilter> filters, StringBuilder buffer) {
        this.filters = Objects.requireNonNull(filters);
        this.buffer = Objects.requireNonNull(buffer);
    }

    public void write() throws IOException {
        for (MlFilter filter : this.filters) {
            StringBuilder filterAsJson = new StringBuilder();
            filterAsJson.append('[');
            boolean first = true;
            for (String item : filter.getItems()) {
                if (first) {
                    first = false;
                } else {
                    filterAsJson.append(',');
                }
                filterAsJson.append('\"');
                filterAsJson.append(item);
                filterAsJson.append('\"');
            }
            filterAsJson.append(']');
            this.buffer.append(FILTER_PREFIX).append(filter.getId()).append(" = ").append((CharSequence)filterAsJson).append('\n');
        }
    }
}

