/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.runtime.BinaryProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.runtime.Processor;

public abstract class BinaryNumericProcessor<O extends Enum<?>>
extends BinaryProcessor {
    private final O operation;

    protected BinaryNumericProcessor(Processor left, Processor right, O operation) {
        super(left, right);
        this.operation = operation;
    }

    protected BinaryNumericProcessor(StreamInput in, Writeable.Reader<O> reader) throws IOException {
        super(in);
        this.operation = (Enum)reader.read(in);
    }

    protected O operation() {
        return this.operation;
    }

    @Override
    protected Object doProcess(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (!(left instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received {}", left);
        }
        if (!(right instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received {}", right);
        }
        return ((BiFunction)this.operation).apply((Number)left, (Number)right);
    }

    public int hashCode() {
        return Objects.hash(this.operation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryNumericProcessor other = (BinaryNumericProcessor)obj;
        return Objects.equals(this.operation, other.operation) && Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }

    public String toString() {
        return String.format(Locale.ROOT, "(%s %s %s)", this.left(), this.operation, this.right());
    }
}

