/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.regex;

import java.util.regex.Pattern;
import org.elasticsearch.xpack.sql.expression.BinaryExpression;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class RLike
extends BinaryExpression {
    public RLike(Location location, Expression left, Literal right) {
        super(location, left, right);
    }

    @Override
    protected NodeInfo<RLike> info() {
        return NodeInfo.create(this, RLike::new, this.left(), this.right());
    }

    @Override
    protected BinaryExpression replaceChildren(Expression newLeft, Expression newRight) {
        return new RLike(this.location(), newLeft, (Literal)newRight);
    }

    @Override
    public Literal right() {
        return (Literal)super.right();
    }

    @Override
    public Object fold() {
        Pattern p = Pattern.compile(this.right().fold().toString());
        return p.matcher(this.left().fold().toString()).matches();
    }

    @Override
    public RLike swapLeftAndRight() {
        return this;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public String symbol() {
        return "RLIKE";
    }
}

