/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.sql.execution.search.Querier;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.plan.physical.LeafExec;
import org.elasticsearch.xpack.sql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class EsQueryExec
extends LeafExec {
    private final String index;
    private final List<Attribute> output;
    private final QueryContainer queryContainer;

    public EsQueryExec(Location location, String index, List<Attribute> output, QueryContainer queryContainer) {
        super(location);
        this.index = index;
        this.output = output;
        this.queryContainer = queryContainer;
    }

    @Override
    protected NodeInfo<EsQueryExec> info() {
        return NodeInfo.create(this, EsQueryExec::new, this.index, this.output, this.queryContainer);
    }

    public EsQueryExec with(QueryContainer queryContainer) {
        return new EsQueryExec(this.location(), this.index, this.output, queryContainer);
    }

    public String index() {
        return this.index;
    }

    public QueryContainer queryContainer() {
        return this.queryContainer;
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    @Override
    public void execute(SqlSession session, ActionListener<SchemaRowSet> listener) {
        Querier scroller = new Querier(session.client(), session.settings());
        scroller.query(Rows.schema(this.output), this.queryContainer, this.index, listener);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.queryContainer, this.output);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsQueryExec other = (EsQueryExec)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.queryContainer, other.queryContainer) && Objects.equals(this.output, other.output);
    }

    @Override
    public String nodeString() {
        return this.nodeName() + "[" + this.index + "," + this.queryContainer + "]";
    }
}

