/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.plugin.SqlLicenseChecker;
import org.elasticsearch.xpack.sql.plugin.SqlTranslateRequest;
import org.elasticsearch.xpack.sql.plugin.SqlTranslateResponse;
import org.elasticsearch.xpack.sql.session.Configuration;

public class TransportSqlTranslateAction
extends HandledTransportAction<SqlTranslateRequest, SqlTranslateResponse> {
    private final PlanExecutor planExecutor;
    private final SqlLicenseChecker sqlLicenseChecker;

    @Inject
    public TransportSqlTranslateAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, PlanExecutor planExecutor, SqlLicenseChecker sqlLicenseChecker) {
        super(settings, "indices:data/read/sql/translate", threadPool, transportService, actionFilters, SqlTranslateRequest::new, indexNameExpressionResolver);
        this.planExecutor = planExecutor;
        this.sqlLicenseChecker = sqlLicenseChecker;
    }

    protected void doExecute(SqlTranslateRequest request, ActionListener<SqlTranslateResponse> listener) {
        this.sqlLicenseChecker.checkIfSqlAllowed(request.mode());
        Configuration cfg = new Configuration(request.timeZone(), request.fetchSize(), request.requestTimeout(), request.pageTimeout(), request.filter());
        this.planExecutor.searchSource(cfg, request.query(), request.params(), (ActionListener<SearchSourceBuilder>)ActionListener.wrap(searchSourceBuilder -> listener.onResponse((Object)new SqlTranslateResponse(searchSourceBuilder)), arg_0 -> listener.onFailure(arg_0)));
    }
}

