/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import org.owasp.html.CssTokens;
import org.owasp.html.Strings;

final class CssGrammar {
    CssGrammar() {
    }

    private static void errorRecoveryUntilSemiOrCloseBracket(CssTokens.TokenIterator it) {
        int bracketDepth = 0;
        while (it.hasNext()) {
            switch (it.type()) {
                case SEMICOLON: {
                    it.advance();
                    return;
                }
                case LEFT_CURLY: 
                case LEFT_PAREN: 
                case LEFT_SQUARE: {
                    ++bracketDepth;
                    break;
                }
                case RIGHT_CURLY: 
                case RIGHT_PAREN: 
                case RIGHT_SQUARE: {
                    if (--bracketDepth > 0) break;
                    if (bracketDepth != 0) {
                        it.advance();
                    }
                    return;
                }
            }
            it.advance();
        }
    }

    static void parsePropertyGroup(String css, PropertyHandler handler) {
        CssTokens tokens = CssTokens.lex(css);
        CssTokens.TokenIterator it = tokens.iterator();
        while (it.hasTokenAfterSpace()) {
            if (it.type() != CssTokens.TokenType.IDENT) {
                CssGrammar.errorRecoveryUntilSemiOrCloseBracket(it);
                continue;
            }
            String name = it.next();
            if (!it.hasTokenAfterSpace() || !":".equals(it.token())) {
                CssGrammar.errorRecoveryUntilSemiOrCloseBracket(it);
                continue;
            }
            it.advance();
            handler.startProperty(Strings.toLowerCase(name));
            CssGrammar.parsePropertyValue(it, handler);
            handler.endProperty();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parsePropertyValue(CssTokens.TokenIterator it, PropertyHandler handler) {
        block11: while (it.hasNext()) {
            CssTokens.TokenType type = it.type();
            String token = it.token();
            switch (type) {
                case SEMICOLON: {
                    it.advance();
                    return;
                }
                case FUNCTION: {
                    CssTokens.TokenIterator actuals = it.spliceToEnd();
                    handler.startFunction(token);
                    CssGrammar.parsePropertyValue(actuals, handler);
                    handler.endFunction(token);
                    continue block11;
                }
                case IDENT: {
                    handler.identifier(token);
                    break;
                }
                case HASH_UNRESTRICTED: {
                    if (token.length() != 4 && token.length() != 7) break;
                    handler.hash(token);
                    break;
                }
                case STRING: {
                    handler.quotedString(token);
                    break;
                }
                case URL: {
                    handler.url(token);
                    break;
                }
                case DIMENSION: 
                case NUMBER: 
                case PERCENTAGE: {
                    handler.quantity(token);
                    break;
                }
                case AT: 
                case BAD_DIMENSION: 
                case COLUMN: 
                case DOT_IDENT: 
                case HASH_ID: 
                case MATCH: 
                case UNICODE_RANGE: 
                case WHITESPACE: {
                    break;
                }
                case LEFT_CURLY: 
                case LEFT_PAREN: 
                case LEFT_SQUARE: 
                case RIGHT_CURLY: 
                case RIGHT_PAREN: 
                case RIGHT_SQUARE: 
                case COMMA: 
                case COLON: 
                case DELIM: {
                    handler.punctuation(token);
                }
            }
            it.advance();
        }
    }

    static String cssContent(String token) {
        int esc;
        char ch0;
        int n = token.length();
        int pos = 0;
        StringBuilder sb = null;
        if (n >= 2 && ((ch0 = token.charAt(0)) == '\"' || ch0 == '\'') && ch0 == token.charAt(n - 1)) {
            pos = 1;
            sb = new StringBuilder(--n);
        }
        while ((esc = token.indexOf(92, pos)) >= 0) {
            int end = esc + 2;
            if (esc > n) break;
            if (sb == null) {
                sb = new StringBuilder(n);
            }
            sb.append(token, pos, esc);
            int codepoint = token.charAt(end - 1);
            if (CssGrammar.isHex(codepoint)) {
                char ch;
                while (end < n && CssGrammar.isHex(token.charAt(end))) {
                    ++end;
                }
                try {
                    codepoint = Integer.parseInt(token.substring(esc + 1, end), 16);
                }
                catch (RuntimeException ex) {
                    codepoint = 65533;
                }
                if (end >= n || (ch = token.charAt(end)) == ' ' || ch == '\t') {
                    // empty if block
                }
            }
            sb.appendCodePoint(codepoint);
            pos = ++end;
        }
        if (sb == null) {
            return token;
        }
        return sb.append(token, pos, n).toString();
    }

    private static boolean isHex(int codepoint) {
        return 48 <= codepoint && codepoint <= 57 || 65 <= codepoint && codepoint <= 70 || 97 <= codepoint && codepoint <= 102;
    }

    static interface PropertyHandler {
        public void startProperty(String var1);

        public void quantity(String var1);

        public void identifier(String var1);

        public void hash(String var1);

        public void quotedString(String var1);

        public void url(String var1);

        public void punctuation(String var1);

        public void startFunction(String var1);

        public void endFunction(String var1);

        public void endProperty();
    }
}

