/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.http.auth.basic;

import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.elasticsearch.xpack.core.watcher.crypto.CryptoService;
import org.elasticsearch.xpack.watcher.common.http.auth.ApplicableHttpAuth;
import org.elasticsearch.xpack.watcher.common.http.auth.basic.BasicAuth;

public class ApplicableBasicAuth
extends ApplicableHttpAuth<BasicAuth> {
    private final String basicAuth;
    private final CryptoService cryptoService;

    public ApplicableBasicAuth(BasicAuth auth, CryptoService service) {
        super(auth);
        this.basicAuth = ApplicableBasicAuth.headerValue(auth.username, auth.password.text(service));
        this.cryptoService = service;
    }

    public static String headerValue(String username, char[] password) {
        return "Basic " + Base64.getEncoder().encodeToString((username + ":" + new String(password)).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void apply(HttpURLConnection connection) {
        connection.setRequestProperty("Authorization", this.basicAuth);
    }

    @Override
    public void apply(CredentialsProvider credsProvider, AuthScope authScope) {
        credsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(((BasicAuth)this.auth).username, new String(((BasicAuth)this.auth).password.text(this.cryptoService))));
    }
}

