/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.ModelPlotConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class JobUpdate
implements Writeable,
ToXContentObject {
    public static final ParseField DETECTORS = new ParseField("detectors", new String[0]);
    static final ConstructingObjectParser<Builder, Void> INTERNAL_PARSER = new ConstructingObjectParser("job_update", args -> new Builder((String)args[0]));
    public static final ConstructingObjectParser<Builder, Void> EXTERNAL_PARSER = new ConstructingObjectParser("job_update", args -> new Builder((String)args[0]));
    private final String jobId;
    private final List<String> groups;
    private final String description;
    private final List<DetectorUpdate> detectorUpdates;
    private final ModelPlotConfig modelPlotConfig;
    private final AnalysisLimits analysisLimits;
    private final Long renormalizationWindowDays;
    private final TimeValue backgroundPersistInterval;
    private final Long modelSnapshotRetentionDays;
    private final Long resultsRetentionDays;
    private final List<String> categorizationFilters;
    private final Map<String, Object> customSettings;
    private final String modelSnapshotId;
    private final Long establishedModelMemory;
    private final Version jobVersion;

    private JobUpdate(String jobId, @Nullable List<String> groups, @Nullable String description, @Nullable List<DetectorUpdate> detectorUpdates, @Nullable ModelPlotConfig modelPlotConfig, @Nullable AnalysisLimits analysisLimits, @Nullable TimeValue backgroundPersistInterval, @Nullable Long renormalizationWindowDays, @Nullable Long resultsRetentionDays, @Nullable Long modelSnapshotRetentionDays, @Nullable List<String> categorisationFilters, @Nullable Map<String, Object> customSettings, @Nullable String modelSnapshotId, @Nullable Long establishedModelMemory, @Nullable Version jobVersion) {
        this.jobId = jobId;
        this.groups = groups;
        this.description = description;
        this.detectorUpdates = detectorUpdates;
        this.modelPlotConfig = modelPlotConfig;
        this.analysisLimits = analysisLimits;
        this.renormalizationWindowDays = renormalizationWindowDays;
        this.backgroundPersistInterval = backgroundPersistInterval;
        this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
        this.resultsRetentionDays = resultsRetentionDays;
        this.categorizationFilters = categorisationFilters;
        this.customSettings = customSettings;
        this.modelSnapshotId = modelSnapshotId;
        this.establishedModelMemory = establishedModelMemory;
        this.jobVersion = jobVersion;
    }

    public JobUpdate(StreamInput in) throws IOException {
        String[] groupsArray;
        this.jobId = in.readString();
        this.groups = in.getVersion().onOrAfter(Version.V_6_1_0) ? ((groupsArray = in.readOptionalStringArray()) == null ? null : Arrays.asList(groupsArray)) : null;
        this.description = in.readOptionalString();
        this.detectorUpdates = in.readBoolean() ? in.readList(DetectorUpdate::new) : null;
        this.modelPlotConfig = (ModelPlotConfig)in.readOptionalWriteable(ModelPlotConfig::new);
        this.analysisLimits = (AnalysisLimits)in.readOptionalWriteable(AnalysisLimits::new);
        this.renormalizationWindowDays = in.readOptionalLong();
        this.backgroundPersistInterval = in.readOptionalTimeValue();
        this.modelSnapshotRetentionDays = in.readOptionalLong();
        this.resultsRetentionDays = in.readOptionalLong();
        this.categorizationFilters = in.readBoolean() ? in.readList(StreamInput::readString) : null;
        this.customSettings = in.readMap();
        this.modelSnapshotId = in.readOptionalString();
        this.establishedModelMemory = in.getVersion().onOrAfter(Version.V_6_1_0) ? in.readOptionalLong() : null;
        this.jobVersion = in.getVersion().onOrAfter(Version.V_6_3_0) && in.readBoolean() ? Version.readVersion((StreamInput)in) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            String[] groupsArray = this.groups == null ? null : this.groups.toArray(new String[this.groups.size()]);
            out.writeOptionalStringArray(groupsArray);
        }
        out.writeOptionalString(this.description);
        out.writeBoolean(this.detectorUpdates != null);
        if (this.detectorUpdates != null) {
            out.writeList(this.detectorUpdates);
        }
        out.writeOptionalWriteable((Writeable)this.modelPlotConfig);
        out.writeOptionalWriteable((Writeable)this.analysisLimits);
        out.writeOptionalLong(this.renormalizationWindowDays);
        out.writeOptionalTimeValue(this.backgroundPersistInterval);
        out.writeOptionalLong(this.modelSnapshotRetentionDays);
        out.writeOptionalLong(this.resultsRetentionDays);
        out.writeBoolean(this.categorizationFilters != null);
        if (this.categorizationFilters != null) {
            out.writeStringList(this.categorizationFilters);
        }
        out.writeMap(this.customSettings);
        out.writeOptionalString(this.modelSnapshotId);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeOptionalLong(this.establishedModelMemory);
        }
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            if (this.jobVersion != null) {
                out.writeBoolean(true);
                Version.writeVersion((Version)this.jobVersion, (StreamOutput)out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getDescription() {
        return this.description;
    }

    public List<DetectorUpdate> getDetectorUpdates() {
        return this.detectorUpdates;
    }

    public ModelPlotConfig getModelPlotConfig() {
        return this.modelPlotConfig;
    }

    public AnalysisLimits getAnalysisLimits() {
        return this.analysisLimits;
    }

    public Long getRenormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    public TimeValue getBackgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    public Long getModelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    public Long getResultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    public List<String> getCategorizationFilters() {
        return this.categorizationFilters;
    }

    public Map<String, Object> getCustomSettings() {
        return this.customSettings;
    }

    public String getModelSnapshotId() {
        return this.modelSnapshotId;
    }

    public Long getEstablishedModelMemory() {
        return this.establishedModelMemory;
    }

    public Version getJobVersion() {
        return this.jobVersion;
    }

    public boolean isAutodetectProcessUpdate() {
        return this.modelPlotConfig != null || this.detectorUpdates != null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.groups != null) {
            builder.field(Job.GROUPS.getPreferredName(), this.groups);
        }
        if (this.description != null) {
            builder.field(Job.DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.detectorUpdates != null) {
            builder.field(DETECTORS.getPreferredName(), this.detectorUpdates);
        }
        if (this.modelPlotConfig != null) {
            builder.field(Job.MODEL_PLOT_CONFIG.getPreferredName(), (ToXContent)this.modelPlotConfig);
        }
        if (this.analysisLimits != null) {
            builder.field(Job.ANALYSIS_LIMITS.getPreferredName(), (ToXContent)this.analysisLimits);
        }
        if (this.renormalizationWindowDays != null) {
            builder.field(Job.RENORMALIZATION_WINDOW_DAYS.getPreferredName(), this.renormalizationWindowDays);
        }
        if (this.backgroundPersistInterval != null) {
            builder.field(Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName(), (Object)this.backgroundPersistInterval);
        }
        if (this.modelSnapshotRetentionDays != null) {
            builder.field(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), this.modelSnapshotRetentionDays);
        }
        if (this.resultsRetentionDays != null) {
            builder.field(Job.RESULTS_RETENTION_DAYS.getPreferredName(), this.resultsRetentionDays);
        }
        if (this.categorizationFilters != null) {
            builder.field(AnalysisConfig.CATEGORIZATION_FILTERS.getPreferredName(), this.categorizationFilters);
        }
        if (this.customSettings != null) {
            builder.field(Job.CUSTOM_SETTINGS.getPreferredName(), this.customSettings);
        }
        if (this.modelSnapshotId != null) {
            builder.field(Job.MODEL_SNAPSHOT_ID.getPreferredName(), this.modelSnapshotId);
        }
        if (this.establishedModelMemory != null) {
            builder.field(Job.ESTABLISHED_MODEL_MEMORY.getPreferredName(), this.establishedModelMemory);
        }
        if (this.jobVersion != null) {
            builder.field(Job.JOB_VERSION.getPreferredName(), (ToXContent)this.jobVersion);
        }
        builder.endObject();
        return builder;
    }

    public Set<String> getUpdateFields() {
        TreeSet<String> updateFields = new TreeSet<String>();
        if (this.groups != null) {
            updateFields.add(Job.GROUPS.getPreferredName());
        }
        if (this.description != null) {
            updateFields.add(Job.DESCRIPTION.getPreferredName());
        }
        if (this.detectorUpdates != null) {
            updateFields.add(DETECTORS.getPreferredName());
        }
        if (this.modelPlotConfig != null) {
            updateFields.add(Job.MODEL_PLOT_CONFIG.getPreferredName());
        }
        if (this.analysisLimits != null) {
            updateFields.add(Job.ANALYSIS_LIMITS.getPreferredName());
        }
        if (this.renormalizationWindowDays != null) {
            updateFields.add(Job.RENORMALIZATION_WINDOW_DAYS.getPreferredName());
        }
        if (this.backgroundPersistInterval != null) {
            updateFields.add(Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName());
        }
        if (this.modelSnapshotRetentionDays != null) {
            updateFields.add(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName());
        }
        if (this.resultsRetentionDays != null) {
            updateFields.add(Job.RESULTS_RETENTION_DAYS.getPreferredName());
        }
        if (this.categorizationFilters != null) {
            updateFields.add(AnalysisConfig.CATEGORIZATION_FILTERS.getPreferredName());
        }
        if (this.customSettings != null) {
            updateFields.add(Job.CUSTOM_SETTINGS.getPreferredName());
        }
        if (this.modelSnapshotId != null) {
            updateFields.add(Job.MODEL_SNAPSHOT_ID.getPreferredName());
        }
        if (this.establishedModelMemory != null) {
            updateFields.add(Job.ESTABLISHED_MODEL_MEMORY.getPreferredName());
        }
        if (this.jobVersion != null) {
            updateFields.add(Job.JOB_VERSION.getPreferredName());
        }
        return updateFields;
    }

    public Job mergeWithJob(Job source, ByteSizeValue maxModelMemoryLimit) {
        Job.Builder builder = new Job.Builder(source);
        if (this.groups != null) {
            builder.setGroups(this.groups);
        }
        if (this.description != null) {
            builder.setDescription(this.description);
        }
        if (this.detectorUpdates != null && !this.detectorUpdates.isEmpty()) {
            AnalysisConfig ac = source.getAnalysisConfig();
            int numDetectors = ac.getDetectors().size();
            for (DetectorUpdate dd : this.detectorUpdates) {
                if (dd.getDetectorIndex() >= numDetectors) {
                    throw ExceptionsHelper.badRequestException("Supplied detector_index [{}] is >= the number of detectors [{}]", dd.getDetectorIndex(), numDetectors);
                }
                Detector.Builder detectorbuilder = new Detector.Builder(ac.getDetectors().get(dd.getDetectorIndex()));
                if (dd.getDescription() != null) {
                    detectorbuilder.setDetectorDescription(dd.getDescription());
                }
                if (dd.getRules() != null) {
                    detectorbuilder.setRules(dd.getRules());
                }
                ac.getDetectors().set(dd.getDetectorIndex(), detectorbuilder.build());
            }
            AnalysisConfig.Builder acBuilder = new AnalysisConfig.Builder(ac);
            builder.setAnalysisConfig(acBuilder);
        }
        if (this.modelPlotConfig != null) {
            builder.setModelPlotConfig(this.modelPlotConfig);
        }
        if (this.analysisLimits != null) {
            AnalysisLimits validatedLimits = AnalysisLimits.validateAndSetDefaults(this.analysisLimits, maxModelMemoryLimit, 1024L);
            builder.setAnalysisLimits(validatedLimits);
        }
        if (this.renormalizationWindowDays != null) {
            builder.setRenormalizationWindowDays(this.renormalizationWindowDays);
        }
        if (this.backgroundPersistInterval != null) {
            builder.setBackgroundPersistInterval(this.backgroundPersistInterval);
        }
        if (this.modelSnapshotRetentionDays != null) {
            builder.setModelSnapshotRetentionDays(this.modelSnapshotRetentionDays);
        }
        if (this.resultsRetentionDays != null) {
            builder.setResultsRetentionDays(this.resultsRetentionDays);
        }
        if (this.categorizationFilters != null) {
            AnalysisConfig.Builder analysisConfigBuilder = new AnalysisConfig.Builder(source.getAnalysisConfig());
            analysisConfigBuilder.setCategorizationFilters(this.categorizationFilters);
            builder.setAnalysisConfig(analysisConfigBuilder);
        }
        if (this.customSettings != null) {
            builder.setCustomSettings(this.customSettings);
        }
        if (this.modelSnapshotId != null) {
            builder.setModelSnapshotId(this.modelSnapshotId);
        }
        if (this.establishedModelMemory != null) {
            if (this.establishedModelMemory > 0L) {
                builder.setEstablishedModelMemory(this.establishedModelMemory);
            } else {
                builder.setEstablishedModelMemory(null);
            }
        }
        if (this.jobVersion != null) {
            builder.setJobVersion(this.jobVersion);
        }
        return builder.build();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JobUpdate)) {
            return false;
        }
        JobUpdate that = (JobUpdate)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.groups, that.groups) && Objects.equals(this.description, that.description) && Objects.equals(this.detectorUpdates, that.detectorUpdates) && Objects.equals(this.modelPlotConfig, that.modelPlotConfig) && Objects.equals(this.analysisLimits, that.analysisLimits) && Objects.equals(this.renormalizationWindowDays, that.renormalizationWindowDays) && Objects.equals(this.backgroundPersistInterval, that.backgroundPersistInterval) && Objects.equals(this.modelSnapshotRetentionDays, that.modelSnapshotRetentionDays) && Objects.equals(this.resultsRetentionDays, that.resultsRetentionDays) && Objects.equals(this.categorizationFilters, that.categorizationFilters) && Objects.equals(this.customSettings, that.customSettings) && Objects.equals(this.modelSnapshotId, that.modelSnapshotId) && Objects.equals(this.establishedModelMemory, that.establishedModelMemory) && Objects.equals(this.jobVersion, that.jobVersion);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.groups, this.description, this.detectorUpdates, this.modelPlotConfig, this.analysisLimits, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.resultsRetentionDays, this.categorizationFilters, this.customSettings, this.modelSnapshotId, this.establishedModelMemory, this.jobVersion);
    }

    static {
        for (ConstructingObjectParser parser : Arrays.asList(INTERNAL_PARSER, EXTERNAL_PARSER)) {
            parser.declareString(ConstructingObjectParser.optionalConstructorArg(), Job.ID);
            parser.declareStringArray(Builder::setGroups, Job.GROUPS);
            parser.declareStringOrNull(Builder::setDescription, Job.DESCRIPTION);
            parser.declareObjectArray(Builder::setDetectorUpdates, DetectorUpdate.PARSER, DETECTORS);
            parser.declareObject(Builder::setModelPlotConfig, ModelPlotConfig.CONFIG_PARSER, Job.MODEL_PLOT_CONFIG);
            parser.declareObject(Builder::setAnalysisLimits, AnalysisLimits.CONFIG_PARSER, Job.ANALYSIS_LIMITS);
            parser.declareString((builder, val) -> builder.setBackgroundPersistInterval(TimeValue.parseTimeValue((String)val, (String)Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName())), Job.BACKGROUND_PERSIST_INTERVAL);
            parser.declareLong(Builder::setRenormalizationWindowDays, Job.RENORMALIZATION_WINDOW_DAYS);
            parser.declareLong(Builder::setResultsRetentionDays, Job.RESULTS_RETENTION_DAYS);
            parser.declareLong(Builder::setModelSnapshotRetentionDays, Job.MODEL_SNAPSHOT_RETENTION_DAYS);
            parser.declareStringArray(Builder::setCategorizationFilters, AnalysisConfig.CATEGORIZATION_FILTERS);
            parser.declareField(Builder::setCustomSettings, (p, c) -> p.map(), Job.CUSTOM_SETTINGS, ObjectParser.ValueType.OBJECT);
        }
        INTERNAL_PARSER.declareString(Builder::setModelSnapshotId, Job.MODEL_SNAPSHOT_ID);
        INTERNAL_PARSER.declareLong(Builder::setEstablishedModelMemory, Job.ESTABLISHED_MODEL_MEMORY);
        INTERNAL_PARSER.declareString(Builder::setJobVersion, Job.JOB_VERSION);
    }

    public static class Builder {
        private String jobId;
        private List<String> groups;
        private String description;
        private List<DetectorUpdate> detectorUpdates;
        private ModelPlotConfig modelPlotConfig;
        private AnalysisLimits analysisLimits;
        private Long renormalizationWindowDays;
        private TimeValue backgroundPersistInterval;
        private Long modelSnapshotRetentionDays;
        private Long resultsRetentionDays;
        private List<String> categorizationFilters;
        private Map<String, Object> customSettings;
        private String modelSnapshotId;
        private Long establishedModelMemory;
        private Version jobVersion;

        public Builder(String jobId) {
            this.jobId = jobId;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setGroups(List<String> groups) {
            this.groups = groups;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDetectorUpdates(List<DetectorUpdate> detectorUpdates) {
            this.detectorUpdates = detectorUpdates;
            return this;
        }

        public Builder setModelPlotConfig(ModelPlotConfig modelPlotConfig) {
            this.modelPlotConfig = modelPlotConfig;
            return this;
        }

        public Builder setAnalysisLimits(AnalysisLimits analysisLimits) {
            this.analysisLimits = analysisLimits;
            return this;
        }

        public Builder setRenormalizationWindowDays(Long renormalizationWindowDays) {
            this.renormalizationWindowDays = renormalizationWindowDays;
            return this;
        }

        public Builder setBackgroundPersistInterval(TimeValue backgroundPersistInterval) {
            this.backgroundPersistInterval = backgroundPersistInterval;
            return this;
        }

        public Builder setModelSnapshotRetentionDays(Long modelSnapshotRetentionDays) {
            this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
            return this;
        }

        public Builder setResultsRetentionDays(Long resultsRetentionDays) {
            this.resultsRetentionDays = resultsRetentionDays;
            return this;
        }

        public Builder setCategorizationFilters(List<String> categorizationFilters) {
            this.categorizationFilters = categorizationFilters;
            return this;
        }

        public Builder setCustomSettings(Map<String, Object> customSettings) {
            this.customSettings = customSettings;
            return this;
        }

        public Builder setModelSnapshotId(String modelSnapshotId) {
            this.modelSnapshotId = modelSnapshotId;
            return this;
        }

        public Builder setEstablishedModelMemory(Long establishedModelMemory) {
            this.establishedModelMemory = establishedModelMemory;
            return this;
        }

        public Builder setJobVersion(Version version) {
            this.jobVersion = version;
            return this;
        }

        public Builder setJobVersion(String version) {
            this.jobVersion = Version.fromString((String)version);
            return this;
        }

        public JobUpdate build() {
            return new JobUpdate(this.jobId, this.groups, this.description, this.detectorUpdates, this.modelPlotConfig, this.analysisLimits, this.backgroundPersistInterval, this.renormalizationWindowDays, this.resultsRetentionDays, this.modelSnapshotRetentionDays, this.categorizationFilters, this.customSettings, this.modelSnapshotId, this.establishedModelMemory, this.jobVersion);
        }
    }

    public static class DetectorUpdate
    implements Writeable,
    ToXContentObject {
        public static final ConstructingObjectParser<DetectorUpdate, Void> PARSER = new ConstructingObjectParser("detector_update", a -> new DetectorUpdate((Integer)a[0], (String)a[1], (List)a[2]));
        private int detectorIndex;
        private String description;
        private List<DetectionRule> rules;

        public DetectorUpdate(int detectorIndex, String description, List<DetectionRule> rules) {
            this.detectorIndex = detectorIndex;
            this.description = description;
            this.rules = rules;
        }

        public DetectorUpdate(StreamInput in) throws IOException {
            this.detectorIndex = in.readInt();
            this.description = in.readOptionalString();
            this.rules = in.readBoolean() ? in.readList(DetectionRule::new) : null;
        }

        public int getDetectorIndex() {
            return this.detectorIndex;
        }

        public String getDescription() {
            return this.description;
        }

        public List<DetectionRule> getRules() {
            return this.rules;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.detectorIndex);
            out.writeOptionalString(this.description);
            out.writeBoolean(this.rules != null);
            if (this.rules != null) {
                out.writeList(this.rules);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Detector.DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
            if (this.description != null) {
                builder.field(Job.DESCRIPTION.getPreferredName(), this.description);
            }
            if (this.rules != null) {
                builder.field(Detector.RULES_FIELD.getPreferredName(), this.rules);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.detectorIndex, this.description, this.rules);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DetectorUpdate)) {
                return false;
            }
            DetectorUpdate that = (DetectorUpdate)other;
            return this.detectorIndex == that.detectorIndex && Objects.equals(this.description, that.description) && Objects.equals(this.rules, that.rules);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), Detector.DETECTOR_INDEX);
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Job.DESCRIPTION);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (parser, parseFieldMatcher) -> ((DetectionRule.Builder)DetectionRule.CONFIG_PARSER.apply(parser, parseFieldMatcher)).build(), Detector.RULES_FIELD);
        }
    }
}

