/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlParserType;
import org.elasticsearch.xpack.core.ml.job.config.Condition;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.config.Operator;
import org.elasticsearch.xpack.core.ml.job.config.RuleConditionType;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class RuleCondition
implements ToXContentObject,
Writeable {
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[]{"condition_type"});
    public static final ParseField RULE_CONDITION_FIELD = new ParseField("rule_condition", new String[0]);
    public static final ParseField FIELD_NAME_FIELD = new ParseField("field_name", new String[0]);
    public static final ParseField FIELD_VALUE_FIELD = new ParseField("field_value", new String[0]);
    public static final ParseField FILTER_ID_FIELD = new ParseField(MlFilter.ID.getPreferredName(), new String[]{"value_filter"});
    public static final ConstructingObjectParser<RuleCondition, Void> METADATA_PARSER = new ConstructingObjectParser(RULE_CONDITION_FIELD.getPreferredName(), true, a -> new RuleCondition((RuleConditionType)((Object)((Object)a[0])), (String)a[1], (String)a[2], (Condition)a[3], (String)a[4]));
    public static final ConstructingObjectParser<RuleCondition, Void> CONFIG_PARSER = new ConstructingObjectParser(RULE_CONDITION_FIELD.getPreferredName(), false, a -> new RuleCondition((RuleConditionType)((Object)((Object)a[0])), (String)a[1], (String)a[2], (Condition)a[3], (String)a[4]));
    public static final Map<MlParserType, ConstructingObjectParser<RuleCondition, Void>> PARSERS = new EnumMap<MlParserType, ConstructingObjectParser<RuleCondition, Void>>(MlParserType.class);
    private final RuleConditionType type;
    private final String fieldName;
    private final String fieldValue;
    private final Condition condition;
    private final String filterId;
    static EnumSet<Operator> VALID_CONDITION_OPERATORS;

    public RuleCondition(StreamInput in) throws IOException {
        this.type = RuleConditionType.readFromStream(in);
        this.condition = (Condition)in.readOptionalWriteable(Condition::new);
        this.fieldName = in.readOptionalString();
        this.fieldValue = in.readOptionalString();
        this.filterId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.type.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.condition);
        out.writeOptionalString(this.fieldName);
        out.writeOptionalString(this.fieldValue);
        out.writeOptionalString(this.filterId);
    }

    RuleCondition(RuleConditionType type, String fieldName, String fieldValue, Condition condition, String filterId) {
        this.type = type;
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.condition = condition;
        this.filterId = filterId;
        RuleCondition.verifyFieldsBoundToType(this);
        RuleCondition.verifyFieldValueRequiresFieldName(this);
    }

    public RuleCondition(RuleCondition ruleCondition) {
        this.type = ruleCondition.type;
        this.fieldName = ruleCondition.fieldName;
        this.fieldValue = ruleCondition.fieldValue;
        this.condition = ruleCondition.condition;
        this.filterId = ruleCondition.filterId;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD.getPreferredName(), (Object)this.type);
        if (this.condition != null) {
            builder.field(Condition.CONDITION_FIELD.getPreferredName(), (ToXContent)this.condition);
        }
        if (this.fieldName != null) {
            builder.field(FIELD_NAME_FIELD.getPreferredName(), this.fieldName);
        }
        if (this.fieldValue != null) {
            builder.field(FIELD_VALUE_FIELD.getPreferredName(), this.fieldValue);
        }
        if (this.filterId != null) {
            builder.field(FILTER_ID_FIELD.getPreferredName(), this.filterId);
        }
        builder.endObject();
        return builder;
    }

    public RuleConditionType getType() {
        return this.type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.fieldValue, other.fieldValue) && Objects.equals(this.condition, other.condition) && Objects.equals(this.filterId, other.filterId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.fieldName, this.fieldValue, this.condition, this.filterId});
    }

    public static RuleCondition createCategorical(String fieldName, String filterId) {
        return new RuleCondition(RuleConditionType.CATEGORICAL, fieldName, null, null, filterId);
    }

    public static RuleCondition createNumerical(RuleConditionType conditionType, String fieldName, String fieldValue, Condition condition) {
        if (!conditionType.isNumerical()) {
            throw new IllegalStateException("Rule condition type [" + (Object)((Object)conditionType) + "] not valid for a numerical condition");
        }
        return new RuleCondition(conditionType, fieldName, fieldValue, condition, null);
    }

    public static RuleCondition createTime(Operator operator, long epochSeconds) {
        return new RuleCondition(RuleConditionType.TIME, null, null, new Condition(operator, Long.toString(epochSeconds)), null);
    }

    private static void verifyFieldsBoundToType(RuleCondition ruleCondition) throws ElasticsearchParseException {
        switch (ruleCondition.getType()) {
            case CATEGORICAL: 
            case CATEGORICAL_COMPLEMENT: {
                RuleCondition.verifyCategorical(ruleCondition);
                break;
            }
            case NUMERICAL_ACTUAL: 
            case NUMERICAL_TYPICAL: 
            case NUMERICAL_DIFF_ABS: {
                RuleCondition.verifyNumerical(ruleCondition);
                break;
            }
            case TIME: {
                RuleCondition.verifyTimeRule(ruleCondition);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static void verifyCategorical(RuleCondition ruleCondition) throws ElasticsearchParseException {
        RuleCondition.checkCategoricalHasNoField(Condition.CONDITION_FIELD.getPreferredName(), ruleCondition.getCondition());
        RuleCondition.checkCategoricalHasNoField(FIELD_VALUE_FIELD.getPreferredName(), ruleCondition.getFieldValue());
        RuleCondition.checkCategoricalHasField(FILTER_ID_FIELD.getPreferredName(), ruleCondition.getFilterId());
    }

    private static void checkCategoricalHasNoField(String fieldName, Object fieldValue) throws ElasticsearchParseException {
        if (fieldValue != null) {
            String msg = Messages.getMessage("Invalid detector rule: a categorical rule_condition does not support {0}", fieldName);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
    }

    private static void checkCategoricalHasField(String fieldName, Object fieldValue) throws ElasticsearchParseException {
        if (fieldValue == null) {
            String msg = Messages.getMessage("Invalid detector rule: a categorical rule_condition requires {0} to be set", fieldName);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
    }

    private static void verifyNumerical(RuleCondition ruleCondition) throws ElasticsearchParseException {
        RuleCondition.checkNumericalHasNoField(FILTER_ID_FIELD.getPreferredName(), ruleCondition.getFilterId());
        RuleCondition.checkNumericalHasField(Condition.CONDITION_FIELD.getPreferredName(), ruleCondition.getCondition());
        if (ruleCondition.getFieldName() != null && ruleCondition.getFieldValue() == null) {
            String msg = Messages.getMessage("Invalid detector rule: a numerical rule_condition with field_name requires that field_value is set");
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
        RuleCondition.checkNumericalConditionOparatorsAreValid(ruleCondition);
    }

    private static void checkNumericalHasNoField(String fieldName, Object fieldValue) throws ElasticsearchParseException {
        if (fieldValue != null) {
            String msg = Messages.getMessage("Invalid detector rule: a numerical rule_condition does not support {0}", fieldName);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
    }

    private static void checkNumericalHasField(String fieldName, Object fieldValue) throws ElasticsearchParseException {
        if (fieldValue == null) {
            String msg = Messages.getMessage("Invalid detector rule: a numerical rule_condition requires {0} to be set", fieldName);
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
    }

    private static void verifyFieldValueRequiresFieldName(RuleCondition ruleCondition) throws ElasticsearchParseException {
        if (ruleCondition.getFieldValue() != null && ruleCondition.getFieldName() == null) {
            String msg = Messages.getMessage("Invalid detector rule: missing field_name in rule_condition where field_value ''{0}'' is set", ruleCondition.getFieldValue());
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
    }

    private static void checkNumericalConditionOparatorsAreValid(RuleCondition ruleCondition) throws ElasticsearchParseException {
        Operator operator = ruleCondition.getCondition().getOperator();
        if (!VALID_CONDITION_OPERATORS.contains((Object)operator)) {
            String msg = Messages.getMessage("Invalid detector rule: operator ''{0}'' is not allowed", new Object[]{operator});
            throw ExceptionsHelper.badRequestException(msg, new Object[0]);
        }
    }

    private static void verifyTimeRule(RuleCondition ruleCondition) {
        RuleCondition.checkNumericalConditionOparatorsAreValid(ruleCondition);
    }

    static {
        PARSERS.put(MlParserType.METADATA, METADATA_PARSER);
        PARSERS.put(MlParserType.CONFIG, CONFIG_PARSER);
        for (MlParserType parserType : MlParserType.values()) {
            ConstructingObjectParser<RuleCondition, Void> parser = PARSERS.get((Object)parserType);
            assert (parser != null);
            parser.declareField(ConstructingObjectParser.constructorArg(), p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return RuleConditionType.fromString(p.text());
                }
                throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
            }, TYPE_FIELD, ObjectParser.ValueType.STRING);
            parser.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), FIELD_NAME_FIELD);
            parser.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), FIELD_VALUE_FIELD);
            parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), Condition.PARSER, Condition.CONDITION_FIELD);
            parser.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), FILTER_ID_FIELD);
        }
        VALID_CONDITION_OPERATORS = EnumSet.of(Operator.LT, Operator.LTE, Operator.GT, Operator.GTE);
    }
}

