/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.time.TimeUtils;

public class Forecast
implements ToXContentObject,
Writeable {
    public static final String RESULT_TYPE_VALUE = "model_forecast";
    public static final ParseField RESULTS_FIELD = new ParseField("model_forecast", new String[0]);
    public static final ParseField FORECAST_ID = new ParseField("forecast_id", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME = new ParseField("partition_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_VALUE = new ParseField("partition_field_value", new String[0]);
    public static final ParseField BY_FIELD_NAME = new ParseField("by_field_name", new String[0]);
    public static final ParseField BY_FIELD_VALUE = new ParseField("by_field_value", new String[0]);
    public static final ParseField MODEL_FEATURE = new ParseField("model_feature", new String[0]);
    public static final ParseField FORECAST_LOWER = new ParseField("forecast_lower", new String[0]);
    public static final ParseField FORECAST_UPPER = new ParseField("forecast_upper", new String[0]);
    public static final ParseField FORECAST_PREDICTION = new ParseField("forecast_prediction", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField DETECTOR_INDEX = new ParseField("detector_index", new String[0]);
    public static final ConstructingObjectParser<Forecast, Void> STRICT_PARSER = Forecast.createParser(false);
    private final String jobId;
    private final String forecastId;
    private final Date timestamp;
    private final long bucketSpan;
    private int detectorIndex;
    private String partitionFieldName;
    private String partitionFieldValue;
    private String byFieldName;
    private String byFieldValue;
    private String modelFeature;
    private double forecastLower;
    private double forecastUpper;
    private double forecastPrediction;

    private static ConstructingObjectParser<Forecast, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(RESULT_TYPE_VALUE, ignoreUnknownFields, a -> new Forecast((String)a[0], (String)a[1], (Date)a[2], (Long)a[3], (Integer)a[4]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        parser.declareString(ConstructingObjectParser.constructorArg(), FORECAST_ID);
        parser.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Date(p.longValue());
            }
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Date(TimeUtils.dateStringToEpoch(p.text()));
            }
            throw new IllegalArgumentException("unexpected token [" + p.currentToken() + "] for [" + Result.TIMESTAMP.getPreferredName() + "]");
        }, Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        parser.declareInt(ConstructingObjectParser.constructorArg(), DETECTOR_INDEX);
        parser.declareString((modelForecast, s) -> {}, Result.RESULT_TYPE);
        parser.declareString(Forecast::setPartitionFieldName, PARTITION_FIELD_NAME);
        parser.declareString(Forecast::setPartitionFieldValue, PARTITION_FIELD_VALUE);
        parser.declareString(Forecast::setByFieldName, BY_FIELD_NAME);
        parser.declareString(Forecast::setByFieldValue, BY_FIELD_VALUE);
        parser.declareString(Forecast::setModelFeature, MODEL_FEATURE);
        parser.declareDouble(Forecast::setForecastLower, FORECAST_LOWER);
        parser.declareDouble(Forecast::setForecastUpper, FORECAST_UPPER);
        parser.declareDouble(Forecast::setForecastPrediction, FORECAST_PREDICTION);
        return parser;
    }

    public Forecast(String jobId, String forecastId, Date timestamp, long bucketSpan, int detectorIndex) {
        this.jobId = Objects.requireNonNull(jobId);
        this.forecastId = Objects.requireNonNull(forecastId);
        this.timestamp = timestamp;
        this.bucketSpan = bucketSpan;
        this.detectorIndex = detectorIndex;
    }

    public Forecast(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.forecastId = in.readString();
        this.timestamp = new Date(in.readLong());
        this.partitionFieldName = in.readOptionalString();
        this.partitionFieldValue = in.readOptionalString();
        this.byFieldName = in.readOptionalString();
        this.byFieldValue = in.readOptionalString();
        this.modelFeature = in.readOptionalString();
        this.forecastLower = in.readDouble();
        this.forecastUpper = in.readDouble();
        this.forecastPrediction = in.readDouble();
        this.bucketSpan = in.readLong();
        this.detectorIndex = in.readInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeString(this.forecastId);
        out.writeLong(this.timestamp.getTime());
        out.writeOptionalString(this.partitionFieldName);
        out.writeOptionalString(this.partitionFieldValue);
        out.writeOptionalString(this.byFieldName);
        out.writeOptionalString(this.byFieldValue);
        out.writeOptionalString(this.modelFeature);
        out.writeDouble(this.forecastLower);
        out.writeDouble(this.forecastUpper);
        out.writeDouble(this.forecastPrediction);
        out.writeLong(this.bucketSpan);
        out.writeInt(this.detectorIndex);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(FORECAST_ID.getPreferredName(), this.forecastId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
        if (this.timestamp != null) {
            builder.timeField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        }
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME.getPreferredName(), this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            builder.field(PARTITION_FIELD_VALUE.getPreferredName(), this.partitionFieldValue);
        }
        if (this.byFieldName != null) {
            builder.field(BY_FIELD_NAME.getPreferredName(), this.byFieldName);
        }
        if (this.byFieldValue != null) {
            builder.field(BY_FIELD_VALUE.getPreferredName(), this.byFieldValue);
        }
        if (this.modelFeature != null) {
            builder.field(MODEL_FEATURE.getPreferredName(), this.modelFeature);
        }
        builder.field(FORECAST_LOWER.getPreferredName(), this.forecastLower);
        builder.field(FORECAST_UPPER.getPreferredName(), this.forecastUpper);
        builder.field(FORECAST_PREDICTION.getPreferredName(), this.forecastPrediction);
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getForecastId() {
        return this.forecastId;
    }

    public String getId() {
        int valuesHash = Objects.hash(this.byFieldValue, this.partitionFieldValue);
        int length = (this.byFieldValue == null ? 0 : this.byFieldValue.length()) + (this.partitionFieldValue == null ? 0 : this.partitionFieldValue.length());
        return this.jobId + "_model_forecast_" + this.forecastId + "_" + this.timestamp.getTime() + "_" + this.bucketSpan + "_" + this.detectorIndex + "_" + valuesHash + "_" + length;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getBucketSpan() {
        return this.bucketSpan;
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public void setPartitionFieldName(String partitionFieldName) {
        this.partitionFieldName = partitionFieldName;
    }

    public int getDetectorIndex() {
        return this.detectorIndex;
    }

    public String getPartitionFieldValue() {
        return this.partitionFieldValue;
    }

    public void setPartitionFieldValue(String partitionFieldValue) {
        this.partitionFieldValue = partitionFieldValue;
    }

    public String getByFieldName() {
        return this.byFieldName;
    }

    public void setByFieldName(String byFieldName) {
        this.byFieldName = byFieldName;
    }

    public String getByFieldValue() {
        return this.byFieldValue;
    }

    public void setByFieldValue(String byFieldValue) {
        this.byFieldValue = byFieldValue;
    }

    public String getModelFeature() {
        return this.modelFeature;
    }

    public void setModelFeature(String modelFeature) {
        this.modelFeature = modelFeature;
    }

    public double getForecastLower() {
        return this.forecastLower;
    }

    public void setForecastLower(double forecastLower) {
        this.forecastLower = forecastLower;
    }

    public double getForecastUpper() {
        return this.forecastUpper;
    }

    public void setForecastUpper(double forecastUpper) {
        this.forecastUpper = forecastUpper;
    }

    public double getForecastPrediction() {
        return this.forecastPrediction;
    }

    public void setForecastPrediction(double forecastPrediction) {
        this.forecastPrediction = forecastPrediction;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Forecast)) {
            return false;
        }
        Forecast that = (Forecast)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.forecastId, that.forecastId) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.partitionFieldValue, that.partitionFieldValue) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.byFieldValue, that.byFieldValue) && Objects.equals(this.byFieldName, that.byFieldName) && Objects.equals(this.modelFeature, that.modelFeature) && this.forecastLower == that.forecastLower && this.forecastUpper == that.forecastUpper && this.forecastPrediction == that.forecastPrediction && this.bucketSpan == that.bucketSpan && this.detectorIndex == that.detectorIndex;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.forecastId, this.timestamp, this.partitionFieldName, this.partitionFieldValue, this.byFieldName, this.byFieldValue, this.modelFeature, this.forecastLower, this.forecastUpper, this.forecastPrediction, this.bucketSpan, this.detectorIndex);
    }
}

