/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkDoc;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringIndex;

public class MonitoringBulkRequest
extends ActionRequest {
    private final List<MonitoringBulkDoc> docs = new ArrayList<MonitoringBulkDoc>();

    public Collection<MonitoringBulkDoc> getDocs() {
        return Collections.unmodifiableCollection(new ArrayList<MonitoringBulkDoc>(this.docs));
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.docs.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"no monitoring documents added", validationException);
        }
        for (int i = 0; i < this.docs.size(); ++i) {
            MonitoringBulkDoc doc = this.docs.get(i);
            if (doc.getSource() != null && doc.getSource().length() != 0) continue;
            validationException = ValidateActions.addValidationError((String)("source is missing for monitoring document [" + i + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public MonitoringBulkRequest add(MonitoringBulkDoc doc) {
        this.docs.add(doc);
        return this;
    }

    public MonitoringBulkRequest add(MonitoredSystem system, String defaultType, BytesReference content, XContentType xContentType, long timestamp, long intervalMillis) throws IOException {
        BulkRequest bulkRequest = Requests.bulkRequest().add(content, null, defaultType, xContentType);
        for (DocWriteRequest request : bulkRequest.requests()) {
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                if (MonitoringIndex.from(indexRequest.index()) != MonitoringIndex.TIMESTAMPED) continue;
                BytesReference source = indexRequest.source();
                if (source.length() == 0) {
                    throw new IllegalArgumentException("source is missing for monitoring document [" + indexRequest.index() + "][" + indexRequest.type() + "][" + indexRequest.id() + "]");
                }
                this.add(new MonitoringBulkDoc(system, indexRequest.type(), indexRequest.id(), timestamp, intervalMillis, source, xContentType));
                continue;
            }
            throw new IllegalArgumentException("monitoring bulk requests should only contain index requests");
        }
        return this;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.docs.addAll(in.readList(MonitoringBulkDoc::readFrom));
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.docs);
    }
}

