/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public class RollupField {
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final String TASK_NAME = "xpack/rollup/job";
    public static final String ROLLUP_META = "_rollup";
    public static final String INTERVAL = "interval";
    public static final String COUNT_FIELD = "_count";
    public static final String VERSION_FIELD = "version";
    public static final String VALUE = "value";
    public static final String TIMESTAMP = "timestamp";
    public static final String FILTER = "filter";
    public static final String NAME = "rollup";
    public static final String TYPE_NAME = "_doc";
    public static final String AGG = "agg";
    public static final String ROLLUP_MISSING = "ROLLUP_MISSING_40710B25931745D4B0B8B310F6912A69";
    public static final List<String> SUPPORTED_METRICS = Arrays.asList("max", "min", "sum", "avg", "value_count");

    public static String formatFieldName(ValuesSourceAggregationBuilder source, String extra) {
        return source.field() + "." + source.getType() + "." + extra;
    }

    public static String formatFieldName(String field, String type, String extra) {
        return field + "." + type + "." + extra;
    }

    public static String formatMetaField(String extra) {
        return "_rollup." + extra;
    }

    public static String formatCountAggName(String field) {
        return field + "." + COUNT_FIELD;
    }

    public static String formatValueAggName(String field) {
        return field + "." + VALUE;
    }

    public static String formatComputed(String field, String agg) {
        return field + "." + agg;
    }

    public static String formatIndexerAggName(String field, String agg) {
        return field + "." + agg;
    }
}

