/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.joda.time.DateTimeZone;

public class DateHistoGroupConfig
implements Writeable,
ToXContentFragment {
    private static final String NAME = "date_histo_group_config";
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("date_histo_group_config", Builder::new);
    private static final ParseField INTERVAL = new ParseField("interval", new String[0]);
    private static final ParseField DELAY = new ParseField("delay", new String[0]);
    private static final ParseField FIELD = new ParseField("field", new String[0]);
    public static final ParseField TIME_ZONE = new ParseField("time_zone", new String[0]);
    private final DateHistogramInterval interval;
    private final String field;
    private final DateTimeZone timeZone;
    private final DateHistogramInterval delay;

    private DateHistoGroupConfig(DateHistogramInterval interval, String field, DateHistogramInterval delay, DateTimeZone timeZone) {
        this.interval = interval;
        this.field = field;
        this.delay = delay;
        this.timeZone = Objects.requireNonNull(timeZone);
    }

    DateHistoGroupConfig(StreamInput in) throws IOException {
        this.interval = new DateHistogramInterval(in);
        this.field = in.readString();
        this.delay = (DateHistogramInterval)in.readOptionalWriteable(DateHistogramInterval::new);
        this.timeZone = in.readTimeZone();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.interval.writeTo(out);
        out.writeString(this.field);
        out.writeOptionalWriteable((Writeable)this.delay);
        out.writeTimeZone(this.timeZone);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(INTERVAL.getPreferredName(), this.interval.toString());
        builder.field(FIELD.getPreferredName(), this.field);
        if (this.delay != null) {
            builder.field(DELAY.getPreferredName(), this.delay.toString());
        }
        builder.field(TIME_ZONE.getPreferredName(), this.timeZone.toString());
        return builder;
    }

    public String getField() {
        return this.field;
    }

    public DateHistogramInterval getInterval() {
        return this.interval;
    }

    public DateHistogramInterval getDelay() {
        return this.delay;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public Rounding createRounding() {
        return DateHistoGroupConfig.createRounding(this.interval.toString(), this.timeZone, "");
    }

    public List<CompositeValuesSourceBuilder<?>> toBuilders() {
        DateHistogramValuesSourceBuilder vsBuilder = new DateHistogramValuesSourceBuilder(RollupField.formatIndexerAggName(this.field, "date_histogram"));
        vsBuilder.dateHistogramInterval(this.interval);
        vsBuilder.field(this.field);
        vsBuilder.timeZone(this.timeZone);
        return Collections.singletonList(vsBuilder);
    }

    public Map<String, Object> toAggCap() {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("agg", "date_histogram");
        map.put(INTERVAL.getPreferredName(), this.interval.toString());
        if (this.delay != null) {
            map.put(DELAY.getPreferredName(), this.delay.toString());
        }
        map.put(TIME_ZONE.getPreferredName(), this.timeZone.toString());
        return map;
    }

    public Map<String, Object> getMetadata() {
        return Collections.singletonMap(RollupField.formatMetaField("interval"), this.interval.toString());
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        Map<String, FieldCapabilities> fieldCaps = fieldCapsResponse.get(this.field);
        if (fieldCaps != null && !fieldCaps.isEmpty()) {
            if (fieldCaps.containsKey("date") && fieldCaps.size() == 1) {
                if (fieldCaps.get("date").isAggregatable()) {
                    return;
                }
                validationException.addValidationError("The field [" + this.field + "] must be aggregatable across all indices, but is not.");
            } else {
                validationException.addValidationError("The field referenced by a date_histo group must be a [date] type across all indices in the index pattern.  Found: " + fieldCaps.keySet().toString() + " for field [" + this.field + "]");
            }
        }
        validationException.addValidationError("Could not find a [date] field with name [" + this.field + "] in any of the indices matching the index pattern.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateHistoGroupConfig that = (DateHistoGroupConfig)other;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.field, that.field) && Objects.equals(this.delay, that.delay) && Objects.equals(this.timeZone, that.timeZone);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.field, this.delay, this.timeZone);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    private static Rounding createRounding(String expr, DateTimeZone timeZone, String settingName) {
        DateTimeUnit timeUnit = (DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(expr);
        Rounding.Builder rounding = timeUnit != null ? new Rounding.Builder(timeUnit) : new Rounding.Builder(TimeValue.parseTimeValue((String)expr, (String)settingName));
        rounding.timeZone(timeZone);
        return rounding.build();
    }

    static {
        PARSER.declareField(Builder::setInterval, p -> new DateHistogramInterval(p.text()), INTERVAL, ObjectParser.ValueType.STRING);
        PARSER.declareString(Builder::setField, FIELD);
        PARSER.declareField(Builder::setDelay, p -> new DateHistogramInterval(p.text()), DELAY, ObjectParser.ValueType.LONG);
        PARSER.declareField(Builder::setTimeZone, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return DateTimeZone.forID((String)p.text());
            }
            return DateTimeZone.forOffsetHours((int)p.intValue());
        }, TIME_ZONE, ObjectParser.ValueType.LONG);
    }

    public static class Builder {
        private DateHistogramInterval interval;
        private String field;
        private DateHistogramInterval delay;
        private DateTimeZone timeZone;

        public DateHistogramInterval getInterval() {
            return this.interval;
        }

        public Builder setInterval(DateHistogramInterval interval) {
            this.interval = interval;
            return this;
        }

        public String getField() {
            return this.field;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public DateTimeZone getTimeZone() {
            return this.timeZone;
        }

        public Builder setTimeZone(DateTimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public DateHistogramInterval getDelay() {
            return this.delay;
        }

        public Builder setDelay(DateHistogramInterval delay) {
            this.delay = delay;
            return this;
        }

        public DateHistoGroupConfig build() {
            if (this.field == null || this.field.isEmpty()) {
                throw new IllegalArgumentException("Parameter [" + FIELD.getPreferredName() + "] is mandatory.");
            }
            if (this.timeZone == null) {
                this.timeZone = DateTimeZone.UTC;
            }
            if (this.interval == null) {
                throw new IllegalArgumentException("Parameter [" + INTERVAL.getPreferredName() + "] is mandatory.");
            }
            DateHistoGroupConfig.createRounding(this.interval.toString(), this.timeZone, INTERVAL.getPreferredName());
            if (this.delay != null) {
                TimeValue.parseTimeValue((String)this.delay.toString(), (String)INTERVAL.getPreferredName());
            }
            return new DateHistoGroupConfig(this.interval, this.field, this.delay, this.timeZone);
        }
    }
}

