/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.CertUtils;
import org.elasticsearch.xpack.core.ssl.TrustConfig;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

class PEMTrustConfig
extends TrustConfig {
    private final List<String> caPaths;

    PEMTrustConfig(List<String> caPaths) {
        this.caPaths = Objects.requireNonNull(caPaths, "ca paths must be specified");
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            Certificate[] certificates = CertUtils.readCertificates(this.caPaths, environment);
            return CertUtils.trustManager(certificates);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    Collection<CertificateInfo> certificates(Environment environment) throws CertificateException, IOException {
        ArrayList<CertificateInfo> info = new ArrayList<CertificateInfo>(this.caPaths.size());
        for (String path : this.caPaths) {
            Certificate[] chain;
            for (Certificate cert : chain = CertUtils.readCertificates(Collections.singletonList(path), environment)) {
                if (!(cert instanceof X509Certificate)) continue;
                info.add(new CertificateInfo(path, "PEM", null, false, (X509Certificate)cert));
            }
        }
        return info;
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        ArrayList<Path> paths = new ArrayList<Path>(this.caPaths.size());
        for (String path : this.caPaths) {
            paths.add(CertUtils.resolvePath(path, environment));
        }
        return paths;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PEMTrustConfig that = (PEMTrustConfig)o;
        return this.caPaths != null ? this.caPaths.equals(that.caPaths) : that.caPaths == null;
    }

    @Override
    public int hashCode() {
        return this.caPaths != null ? this.caPaths.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "ca=[" + Strings.collectionToCommaDelimitedString(this.caPaths) + "]";
    }
}

