/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.actions.throttler;

import java.time.Clock;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.watcher.actions.ActionStatus;
import org.elasticsearch.xpack.core.watcher.actions.throttler.Throttler;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;

public class PeriodThrottler
implements Throttler {
    @Nullable
    private final TimeValue period;
    private final Clock clock;

    public PeriodThrottler(Clock clock, TimeValue period) {
        this.period = period;
        this.clock = clock;
    }

    public TimeValue period() {
        return this.period;
    }

    @Override
    public Throttler.Result throttle(String actionId, WatchExecutionContext ctx) {
        ActionStatus status;
        TimeValue period = this.period;
        if (period == null) {
            period = ctx.watch().throttlePeriod();
        }
        if (period == null) {
            period = ctx.defaultThrottlePeriod();
        }
        if ((status = ctx.watch().status().actionStatus(actionId)).lastSuccessfulExecution() == null) {
            return Throttler.Result.NO;
        }
        TimeValue timeElapsed = TimeValue.timeValueMillis((long)(this.clock.millis() - status.lastSuccessfulExecution().timestamp().getMillis()));
        if (timeElapsed.getMillis() <= period.getMillis()) {
            return Throttler.Result.throttle(Throttler.Type.PERIOD, "throttling interval is set to [{}] but time elapsed since last execution is [{}]", period, timeElapsed);
        }
        return Throttler.Result.NO;
    }
}

