/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.support.xcontent;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.common.xcontent.XContentUtils;
import org.elasticsearch.xpack.core.watcher.support.xcontent.ObjectPath;

public class XContentSource
implements ToXContent {
    private final BytesReference bytes;
    private final XContentType contentType;
    private Object data;

    public XContentSource(BytesReference bytes, XContentType xContentType) throws ElasticsearchParseException {
        if (xContentType == null) {
            throw new IllegalArgumentException("xContentType must not be null");
        }
        this.bytes = bytes;
        this.contentType = xContentType;
    }

    public XContentSource(XContentBuilder builder) {
        this(BytesReference.bytes((XContentBuilder)builder), builder.contentType());
    }

    public BytesReference getBytes() {
        return this.bytes;
    }

    public boolean isMap() {
        return this.data() instanceof Map;
    }

    public Map<String, Object> getAsMap() {
        return (Map)this.data();
    }

    public boolean isList() {
        return this.data() instanceof List;
    }

    public List<Object> getAsList() {
        return (List)this.data();
    }

    public <T> T getValue(String path) {
        return ObjectPath.eval(path, this.data());
    }

    /*
     * Exception decompiling
     */
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public XContentParser parser(NamedXContentRegistry xContentRegistry, InputStream stream) throws IOException {
        return this.contentType.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, stream);
    }

    public static XContentSource readFrom(StreamInput in) throws IOException {
        return new XContentSource(in.readBytesReference(), (XContentType)in.readEnum(XContentType.class));
    }

    public static void writeTo(XContentSource source, StreamOutput out) throws IOException {
        out.writeBytesReference(source.bytes);
        out.writeEnum((Enum)source.contentType);
    }

    private Object data() {
        if (this.data == null) {
            try (StreamInput stream = this.bytes.streamInput();
                 XContentParser parser = this.parser(NamedXContentRegistry.EMPTY, (InputStream)stream);){
                this.data = XContentUtils.readValue(parser, parser.nextToken());
            }
            catch (IOException ex) {
                throw new ElasticsearchException("failed to read value", (Throwable)ex, new Object[0]);
            }
        }
        return this.data;
    }
}

