/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.net.URL;
import java.net.URLClassLoader;
import org.codehaus.groovy.tools.LoaderConfiguration;

public class RootLoader
extends URLClassLoader {
    private RootLoader(ClassLoader parent) {
        this(new URL[0], parent);
    }

    public RootLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    private static ClassLoader chooseParent() {
        ClassLoader cl = RootLoader.class.getClassLoader();
        if (cl != null) {
            return cl;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public RootLoader(LoaderConfiguration lc) {
        this(RootLoader.chooseParent());
        Thread.currentThread().setContextClassLoader(this);
        URL[] urls = lc.getClassPathUrls();
        for (int i = 0; i < urls.length; ++i) {
            this.addURL(urls[i]);
        }
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        try {
            c = this.oldFindClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (c == null) {
            c = super.loadClass(name, resolve);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    private Class oldFindClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }
}

