/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.fibs.geotag.Settings;
import org.fibs.geotag.gui.settings.SettingsPanel;

public class FileSettingsPanel
extends SettingsPanel {
    private JTextField textField;

    public FileSettingsPanel(JFrame parent, String title, Settings.SETTING setting, String defaultValue) {
        this(parent, title, null, true, setting, defaultValue);
    }

    public FileSettingsPanel(JFrame parent, String title, Settings.SETTING enablingSetting, boolean defaultEnabled, Settings.SETTING setting, String defaultValue) {
        super(parent, title, enablingSetting, defaultEnabled, setting, defaultValue);
        JPanel filePanel = new JPanel(new BorderLayout());
        this.textField = new JTextField(Settings.get(setting, defaultValue));
        filePanel.add((Component)this.textField, "Center");
        JButton browseButton = new JButton("...");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                if (fileChooser.showOpenDialog(FileSettingsPanel.this) == 0) {
                    String filename = fileChooser.getSelectedFile().getPath();
                    FileSettingsPanel.this.getTextField().setText(filename);
                }
            }
        });
        filePanel.add((Component)browseButton, "East");
        this.addEditor(filePanel);
    }

    @Override
    public String getValue() {
        return this.textField.getText();
    }

    JTextField getTextField() {
        return this.textField;
    }
}

