/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptorKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

public abstract class ClassBodyCodegen
extends MemberCodegen<KtPureClassOrObject> {
    @NotNull
    public final KtPureClassOrObject myClass;
    @NotNull
    public final OwnerKind kind;
    @NotNull
    public final ClassDescriptor descriptor;

    protected ClassBodyCodegen(@NotNull KtPureClassOrObject myClass, @NotNull ClassContext context, @NotNull ClassBuilder v, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen) {
        super(state2, parentCodegen, context, myClass, v);
        this.myClass = myClass;
        this.kind = context.getContextKind();
        this.descriptor = SyntheticClassOrObjectDescriptorKt.findClassDescriptor(myClass, this.bindingContext);
    }

    @Override
    protected void generateBody() {
        ArrayList<KtObjectDeclaration> companions = new ArrayList<KtObjectDeclaration>();
        if (this.kind != OwnerKind.DEFAULT_IMPLS && this.kind != OwnerKind.ERASED_INLINE_CLASS) {
            for (KtDeclaration ktDeclaration : this.myClass.getDeclarations()) {
                if (!ClassBodyCodegen.shouldProcessFirst(ktDeclaration)) continue;
                if (ktDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)ktDeclaration).isCompanion()) {
                    companions.add((KtObjectDeclaration)ktDeclaration);
                    CodegenUtilKt.populateCompanionBackingFieldNamesToOuterContextIfNeeded((KtObjectDeclaration)ktDeclaration, this.context, this.state);
                    continue;
                }
                this.generateDeclaration(ktDeclaration);
            }
        }
        for (KtDeclaration ktDeclaration : this.myClass.getDeclarations()) {
            if (ClassBodyCodegen.shouldProcessFirst(ktDeclaration)) continue;
            this.generateDeclaration(ktDeclaration);
        }
        boolean generateNonClassMembers = this.shouldGenerateNonClassMembers();
        if (generateNonClassMembers) {
            this.generatePrimaryConstructorProperties();
            this.generateConstructors();
            this.generateDefaultImplsIfNeeded();
            this.generateErasedInlineClassIfNeeded();
            this.generateUnboxMethodForInlineClass();
        }
        for (KtObjectDeclaration companion : companions) {
            this.genClassOrObject(companion);
        }
        ClassDescriptor classDescriptor = this.descriptor.getCompanionObjectDescriptor();
        if (classDescriptor instanceof SyntheticClassOrObjectDescriptor) {
            this.genSyntheticClassOrObject((SyntheticClassOrObjectDescriptor)classDescriptor);
        }
        Collection<DeclarationDescriptor> classifiers = this.descriptor.getUnsubstitutedMemberScope().getContributedDescriptors(DescriptorKindFilter.CLASSIFIERS, MemberScope.Companion.getALL_NAME_FILTER());
        for (DeclarationDescriptor memberDescriptor : classifiers) {
            if (!(memberDescriptor instanceof SyntheticClassOrObjectDescriptor)) continue;
            this.genSyntheticClassOrObject((SyntheticClassOrObjectDescriptor)memberDescriptor);
        }
        if (generateNonClassMembers) {
            this.generateBridges();
        }
    }

    private void generateBridges() {
        if (DescriptorUtils.isInterface(this.descriptor)) {
            return;
        }
        for (DeclarationDescriptor memberDescriptor : DescriptorUtils.getAllDescriptors(this.descriptor.getDefaultType().getMemberScope())) {
            PropertySetterDescriptor setter2;
            CallableMemberDescriptor member;
            if (!(memberDescriptor instanceof CallableMemberDescriptor) || (member = (CallableMemberDescriptor)memberDescriptor).getKind().isReal() || ImplKt.findInterfaceImplementation(member) != null) continue;
            if (member instanceof FunctionDescriptor) {
                this.functionCodegen.generateBridges((FunctionDescriptor)member);
                continue;
            }
            if (!(member instanceof PropertyDescriptor)) continue;
            PropertyGetterDescriptor getter2 = ((PropertyDescriptor)member).getGetter();
            if (getter2 != null) {
                this.functionCodegen.generateBridges(getter2);
            }
            if ((setter2 = ((PropertyDescriptor)member).getSetter()) == null) continue;
            this.functionCodegen.generateBridges(setter2);
        }
    }

    private boolean shouldGenerateNonClassMembers() {
        return !(this.myClass instanceof KtClassOrObject) || this.state.getGenerateDeclaredClassFilter().shouldGenerateClassMembers((KtClassOrObject)this.myClass);
    }

    protected void generateConstructors() {
    }

    protected void generateDefaultImplsIfNeeded() {
    }

    protected void generateErasedInlineClassIfNeeded() {
    }

    protected void generateUnboxMethodForInlineClass() {
    }

    private static boolean shouldProcessFirst(KtDeclaration declaration) {
        return !(declaration instanceof KtProperty) && !(declaration instanceof KtNamedFunction);
    }

    protected void generateDeclaration(KtDeclaration declaration) {
        if (declaration instanceof KtProperty || declaration instanceof KtNamedFunction || declaration instanceof KtTypeAlias) {
            if (this.shouldGenerateNonClassMembers()) {
                this.genSimpleMember(declaration);
            }
        } else if (declaration instanceof KtClassOrObject) {
            if (declaration instanceof KtEnumEntry && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (KtEnumEntry)declaration)) {
                return;
            }
            this.genClassOrObject((KtClassOrObject)declaration);
        }
    }

    private void generatePrimaryConstructorProperties() {
        ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)CollectionsKt.firstOrNull(this.descriptor.getConstructors());
        if (constructor == null) {
            return;
        }
        boolean isAnnotation = this.descriptor.getKind() == ClassKind.ANNOTATION_CLASS;
        FunctionDescriptor expectedAnnotationConstructor = isAnnotation && constructor.isActual() ? CodegenUtil.findExpectedFunctionForActual(constructor) : null;
        for (KtParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (!p.hasValOrVar() || (propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            if (isAnnotation) {
                this.propertyCodegen.generateConstructorPropertyAsMethodForAnnotationClass(p, propertyDescriptor, expectedAnnotationConstructor);
                continue;
            }
            this.propertyCodegen.generatePrimaryConstructorProperty(p, propertyDescriptor);
        }
    }

    @NotNull
    public List<KtParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof KtClass) {
            return this.myClass.getPrimaryConstructorParameters();
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return InnerClassConsumer.Companion.classForInnerClassRecord(this.descriptor, false);
    }
}

