/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.jetbrains.kotlin.org.apache.batik.transcoder.TranscoderException;
import org.jetbrains.kotlin.org.apache.batik.transcoder.TranscoderInput;
import org.jetbrains.kotlin.org.apache.batik.transcoder.image.ImageTranscoder;
import org.jetbrains.kotlin.org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;

public class SVGLoader {
    private TranscoderInput input;
    private BufferedImage img;
    private double width;
    private double height;

    public static Image load(@Nullable URL url, @NotNull InputStream stream2, double scale) throws IOException {
        if (stream2 == null) {
            SVGLoader.$$$reportNull$$$0(2);
        }
        try {
            return new SVGLoader(url, stream2, scale).createImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    private SVGLoader(@Nullable URL url, InputStream stream2, double scale) throws IOException {
        Document document = null;
        String uri = null;
        try {
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        document = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument(uri, stream2);
        if (document == null) {
            throw new IOException("document not created");
        }
        this.input = new TranscoderInput(document);
        this.width = (double)SizeAttr.width.value(document) * scale;
        this.height = (double)SizeAttr.height.value(document) * scale;
    }

    private BufferedImage createImage() throws TranscoderException {
        MyTranscoder r = new MyTranscoder();
        r.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(this.width));
        r.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(this.height));
        r.transcode(this.input, null);
        return this.img;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "url";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "stream";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/util/SVGLoader";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyTranscoder
    extends ImageTranscoder {
        private MyTranscoder() {
        }
    }

    private static class ViewBox {
        private final float x;
        private final float y;
        private final float width;
        private final float height;

        public ViewBox(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public static ViewBox fromString(String s) {
            ArrayList<String> values = new ArrayList<String>(4);
            for (String token : StringUtil.tokenize(s, ", ")) {
                values.add(token);
            }
            if (values.size() == 4) {
                return new ViewBox(Float.parseFloat((String)values.get(0)), Float.parseFloat((String)values.get(1)), Float.parseFloat((String)values.get(2)), Float.parseFloat((String)values.get(3)));
            }
            throw new IllegalArgumentException("String should be formatted like 'x y width height' or 'x, y, width, height'");
        }
    }

    private static enum SizeAttr {
        width,
        height;


        public float value(@NotNull Document document) {
            String value;
            if (document == null) {
                SizeAttr.$$$reportNull$$$0(0);
            }
            if ((value = document.getDocumentElement().getAttribute(this.name())).endsWith("px")) {
                try {
                    return Float.parseFloat(value.substring(0, value.length() - 2));
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                ViewBox viewBox = ViewBox.fromString(document.getDocumentElement().getAttribute("viewBox"));
                return this == width ? viewBox.width : viewBox.height;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 16.0f;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/kotlin/com/intellij/util/SVGLoader$SizeAttr", "value"));
        }
    }
}

