/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.signatory.pgp;

import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;

public class PgpKeyId
implements Comparable<PgpKeyId> {
    private final long asLong;
    private final String asHex;

    public PgpKeyId(long keyId) {
        this.asLong = keyId;
        this.asHex = PgpKeyId.toHex(keyId);
    }

    public PgpKeyId(PGPPublicKey keyId) {
        this(keyId.getKeyID());
    }

    public PgpKeyId(PGPSignature signature) {
        this(signature.getKeyID());
    }

    public PgpKeyId(String keyId) {
        this.asLong = PgpKeyId.toLong(keyId);
        this.asHex = PgpKeyId.toHex(this.asLong);
    }

    public boolean equals(Object other) {
        return other instanceof PgpKeyId && ((PgpKeyId)other).asHex.equals(this.asHex);
    }

    public int hashCode() {
        return this.asHex.hashCode();
    }

    public String toString() {
        return this.asHex;
    }

    @Override
    public int compareTo(PgpKeyId other) {
        return other == null ? -1 : this.asHex.compareTo(other.asHex);
    }

    public final String getAsHex() {
        return this.asHex;
    }

    public final long getAsLong() {
        return this.asLong;
    }

    public static String toHex(long keyId) {
        return String.format("%08X", 0xFFFFFFFFL & keyId);
    }

    public static long toLong(String keyId) {
        if (keyId == null) {
            throw new IllegalArgumentException("'keyId' cannot be null");
        }
        String normalised = PgpKeyId.normaliseKeyId(keyId);
        try {
            return Long.parseLong(normalised, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("the key id '" + keyId + "' is not a valid hex string");
        }
    }

    private static String normaliseKeyId(String keyId) {
        String keyIdUpped = keyId.toUpperCase();
        switch (keyIdUpped.length()) {
            case 10: {
                if (!keyIdUpped.startsWith("0X")) {
                    throw new IllegalArgumentException("10 character key IDs must start with 0x (given value: " + keyId + ")");
                }
                return keyIdUpped.substring(2);
            }
            case 8: {
                if (keyId.startsWith("0X")) {
                    throw new IllegalArgumentException("8 character key IDs must not start with 0x (given value: " + keyId + ")");
                }
                return keyIdUpped;
            }
        }
        throw new IllegalStateException("The key ID must be in a valid form (eg 00B5050F or 0x00B5050F), given value: " + keyId);
    }
}

