/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.caching.internal.BuildCacheHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrderInsensitiveTaskFilePropertyCompareStrategy
implements TaskFilePropertyCompareStrategy.Impl {
    private static final Comparator<Map.Entry<NormalizedFileSnapshot, IncrementalFileSnapshotWithAbsolutePath>> ENTRY_COMPARATOR = new Comparator<Map.Entry<NormalizedFileSnapshot, IncrementalFileSnapshotWithAbsolutePath>>(){

        @Override
        public int compare(Map.Entry<NormalizedFileSnapshot, IncrementalFileSnapshotWithAbsolutePath> o1, Map.Entry<NormalizedFileSnapshot, IncrementalFileSnapshotWithAbsolutePath> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    OrderInsensitiveTaskFilePropertyCompareStrategy() {
    }

    @Override
    public boolean accept(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String propertyTitle, boolean pathIsAbsolute, boolean includeAdded) {
        if (pathIsAbsolute) {
            return this.acceptForAbsolutePaths(visitor, current, previous, propertyTitle, includeAdded);
        }
        return this.acceptForRelativePaths(visitor, current, previous, propertyTitle, includeAdded);
    }

    private boolean acceptForAbsolutePaths(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String propertyTitle, boolean includeAdded) {
        LinkedHashSet<String> unaccountedForPreviousSnapshots = new LinkedHashSet<String>(previous.keySet());
        for (Map.Entry<String, NormalizedFileSnapshot> currentEntry : current.entrySet()) {
            NormalizedFileSnapshot previousNormalizedSnapshot;
            FileContentSnapshot previousSnapshot;
            String currentAbsolutePath = currentEntry.getKey();
            NormalizedFileSnapshot currentNormalizedSnapshot = currentEntry.getValue();
            FileContentSnapshot currentSnapshot = currentNormalizedSnapshot.getSnapshot();
            if (!(unaccountedForPreviousSnapshots.remove(currentAbsolutePath) ? !currentSnapshot.isContentUpToDate(previousSnapshot = (previousNormalizedSnapshot = previous.get(currentAbsolutePath)).getSnapshot()) && !visitor.visitChange(FileChange.modified(currentAbsolutePath, propertyTitle, previousSnapshot.getType(), currentSnapshot.getType())) : includeAdded && !visitor.visitChange(FileChange.added(currentAbsolutePath, propertyTitle, currentSnapshot.getType())))) continue;
            return false;
        }
        for (String previousAbsolutePath : unaccountedForPreviousSnapshots) {
            if (visitor.visitChange(FileChange.removed(previousAbsolutePath, propertyTitle, previous.get(previousAbsolutePath).getSnapshot().getType()))) continue;
            return false;
        }
        return true;
    }

    private boolean acceptForRelativePaths(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String propertyTitle, boolean includeAdded) {
        NormalizedFileSnapshot previousSnapshot;
        ListMultimap unaccountedForPreviousSnapshots = MultimapBuilder.hashKeys((int)previous.size()).linkedListValues().build();
        ListMultimap addedFiles = MultimapBuilder.hashKeys().linkedListValues().build();
        for (Map.Entry<String, NormalizedFileSnapshot> entry : previous.entrySet()) {
            String absolutePath = entry.getKey();
            previousSnapshot = entry.getValue();
            unaccountedForPreviousSnapshots.put((Object)previousSnapshot, (Object)new IncrementalFileSnapshotWithAbsolutePath(absolutePath, previousSnapshot.getSnapshot()));
        }
        for (Map.Entry<String, NormalizedFileSnapshot> entry : current.entrySet()) {
            String currentAbsolutePath = entry.getKey();
            NormalizedFileSnapshot currentNormalizedSnapshot = entry.getValue();
            FileContentSnapshot currentSnapshot = currentNormalizedSnapshot.getSnapshot();
            List previousSnapshotsForNormalizedPath = unaccountedForPreviousSnapshots.get((Object)currentNormalizedSnapshot);
            if (previousSnapshotsForNormalizedPath.isEmpty()) {
                IncrementalFileSnapshotWithAbsolutePath currentSnapshotWithAbsolutePath = new IncrementalFileSnapshotWithAbsolutePath(currentAbsolutePath, currentSnapshot);
                addedFiles.put((Object)currentNormalizedSnapshot.getNormalizedPath(), (Object)currentSnapshotWithAbsolutePath);
                continue;
            }
            IncrementalFileSnapshotWithAbsolutePath previousSnapshotWithAbsolutePath = (IncrementalFileSnapshotWithAbsolutePath)previousSnapshotsForNormalizedPath.remove(0);
            FileContentSnapshot previousSnapshot2 = previousSnapshotWithAbsolutePath.getSnapshot();
            if (currentSnapshot.isContentUpToDate(previousSnapshot2) || visitor.visitChange(FileChange.modified(currentAbsolutePath, propertyTitle, previousSnapshot2.getType(), currentSnapshot.getType()))) continue;
            return false;
        }
        ArrayList unaccountedForPreviousEntries = Lists.newArrayList((Iterable)unaccountedForPreviousSnapshots.entries());
        Collections.sort(unaccountedForPreviousEntries, ENTRY_COMPARATOR);
        for (Map.Entry unaccountedForPreviousSnapshotEntry : unaccountedForPreviousEntries) {
            IncrementalFileSnapshotWithAbsolutePath removedSnapshot;
            IncrementalFileSnapshotWithAbsolutePath modifiedSnapshot;
            previousSnapshot = (NormalizedFileSnapshot)unaccountedForPreviousSnapshotEntry.getKey();
            String normalizedPath = previousSnapshot.getNormalizedPath();
            List addedFilesForNormalizedPath = addedFiles.get((Object)normalizedPath);
            if (!(!addedFilesForNormalizedPath.isEmpty() ? !visitor.visitChange(FileChange.modified((modifiedSnapshot = (IncrementalFileSnapshotWithAbsolutePath)addedFilesForNormalizedPath.remove(0)).getAbsolutePath(), propertyTitle, previousSnapshot.getSnapshot().getType(), modifiedSnapshot.getSnapshot().getType())) : !visitor.visitChange(FileChange.removed((removedSnapshot = (IncrementalFileSnapshotWithAbsolutePath)unaccountedForPreviousSnapshotEntry.getValue()).getAbsolutePath(), propertyTitle, removedSnapshot.getSnapshot().getType())))) continue;
            return false;
        }
        if (includeAdded) {
            for (IncrementalFileSnapshotWithAbsolutePath addedFile : addedFiles.values()) {
                if (visitor.visitChange(FileChange.added(addedFile.getAbsolutePath(), propertyTitle, addedFile.getSnapshot().getType()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        ArrayList normalizedSnapshots = Lists.newArrayList(snapshots);
        Collections.sort(normalizedSnapshots);
        for (NormalizedFileSnapshot normalizedSnapshot : normalizedSnapshots) {
            normalizedSnapshot.appendToHasher(hasher);
        }
    }

    private static class IncrementalFileSnapshotWithAbsolutePath {
        private final String absolutePath;
        private final FileContentSnapshot snapshot;

        public IncrementalFileSnapshotWithAbsolutePath(String absolutePath, FileContentSnapshot snapshot) {
            this.absolutePath = absolutePath;
            this.snapshot = snapshot;
        }

        public String getAbsolutePath() {
            return this.absolutePath;
        }

        public FileContentSnapshot getSnapshot() {
            return this.snapshot;
        }

        public String toString() {
            return String.format("%s (%s)", this.getSnapshot(), this.absolutePath);
        }
    }
}

