/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.DefaultSettingsLoader;
import org.gradle.initialization.ISettingsFinder;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLoaderFactory;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.composite.CompositeBuildSettingsLoader;

public class DefaultSettingsLoaderFactory
implements SettingsLoaderFactory {
    private final ISettingsFinder settingsFinder;
    private final SettingsProcessor settingsProcessor;
    private final BuildSourceBuilder buildSourceBuilder;
    private final BuildStateRegistry buildRegistry;

    public DefaultSettingsLoaderFactory(ISettingsFinder settingsFinder, SettingsProcessor settingsProcessor, BuildSourceBuilder buildSourceBuilder, BuildStateRegistry buildRegistry) {
        this.settingsFinder = settingsFinder;
        this.settingsProcessor = settingsProcessor;
        this.buildSourceBuilder = buildSourceBuilder;
        this.buildRegistry = buildRegistry;
    }

    public SettingsLoader forTopLevelBuild() {
        return this.compositeBuildSettingsLoader();
    }

    public SettingsLoader forNestedBuild() {
        return this.defaultSettingsLoader();
    }

    private SettingsLoader compositeBuildSettingsLoader() {
        return new CompositeBuildSettingsLoader(this.defaultSettingsLoader(), this.buildRegistry);
    }

    private SettingsLoader defaultSettingsLoader() {
        final DefaultSettingsLoader delegate = new DefaultSettingsLoader(this.settingsFinder, this.settingsProcessor, this.buildSourceBuilder);
        return new SettingsLoader(){

            public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
                SettingsInternal settings = delegate.findAndLoadSettings(gradle);
                gradle.setSettings(settings);
                return settings;
            }
        };
    }
}

